/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input object for the endpoint
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointInput implements SdkPojo, Serializable, ToCopyableBuilder<EndpointInput.Builder, EndpointInput> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(EndpointInput::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalPath").getter(getter(EndpointInput::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final SdkField<String> S3_INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3InputMode").getter(getter(EndpointInput::s3InputModeAsString)).setter(setter(Builder::s3InputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputMode").build()).build();

    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3DataDistributionType").getter(getter(EndpointInput::s3DataDistributionTypeAsString))
            .setter(setter(Builder::s3DataDistributionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataDistributionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            LOCAL_PATH_FIELD, S3_INPUT_MODE_FIELD, S3_DATA_DISTRIBUTION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointName;

    private final String localPath;

    private final String s3InputMode;

    private final String s3DataDistributionType;

    private EndpointInput(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.localPath = builder.localPath;
        this.s3InputMode = builder.s3InputMode;
        this.s3DataDistributionType = builder.s3DataDistributionType;
    }

    /**
     * <p>
     * An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled.
     * </p>
     * 
     * @return An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled.
     */
    public String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * Path to the filesystem where the endpoint data is available to the container.
     * </p>
     * 
     * @return Path to the filesystem where the endpoint data is available to the container.
     */
    public String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the
     * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for
     * small files that fit in memory. Defaults to <code>File</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputMode} will
     * return {@link ProcessingS3InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputModeAsString}.
     * </p>
     * 
     * @return Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the
     *         monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is
     *         useful for small files that fit in memory. Defaults to <code>File</code>.
     * @see ProcessingS3InputMode
     */
    public ProcessingS3InputMode s3InputMode() {
        return ProcessingS3InputMode.fromValue(s3InputMode);
    }

    /**
     * <p>
     * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the
     * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for
     * small files that fit in memory. Defaults to <code>File</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputMode} will
     * return {@link ProcessingS3InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputModeAsString}.
     * </p>
     * 
     * @return Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the
     *         monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is
     *         useful for small files that fit in memory. Defaults to <code>File</code>.
     * @see ProcessingS3InputMode
     */
    public String s3InputModeAsString() {
        return s3InputMode;
    }

    /**
     * <p>
     * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
     * <code>FullyReplicated</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link ProcessingS3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
     *         <code>FullyReplicated</code>
     * @see ProcessingS3DataDistributionType
     */
    public ProcessingS3DataDistributionType s3DataDistributionType() {
        return ProcessingS3DataDistributionType.fromValue(s3DataDistributionType);
    }

    /**
     * <p>
     * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
     * <code>FullyReplicated</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link ProcessingS3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
     *         <code>FullyReplicated</code>
     * @see ProcessingS3DataDistributionType
     */
    public String s3DataDistributionTypeAsString() {
        return s3DataDistributionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3InputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataDistributionTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointInput)) {
            return false;
        }
        EndpointInput other = (EndpointInput) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(localPath(), other.localPath())
                && Objects.equals(s3InputModeAsString(), other.s3InputModeAsString())
                && Objects.equals(s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EndpointInput").add("EndpointName", endpointName()).add("LocalPath", localPath())
                .add("S3InputMode", s3InputModeAsString()).add("S3DataDistributionType", s3DataDistributionTypeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "S3InputMode":
            return Optional.ofNullable(clazz.cast(s3InputModeAsString()));
        case "S3DataDistributionType":
            return Optional.ofNullable(clazz.cast(s3DataDistributionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointInput, T> g) {
        return obj -> g.apply((EndpointInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointInput> {
        /**
         * <p>
         * An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled.
         * </p>
         * 
         * @param endpointName
         *        An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * Path to the filesystem where the endpoint data is available to the container.
         * </p>
         * 
         * @param localPath
         *        Path to the filesystem where the endpoint data is available to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the
         * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful
         * for small files that fit in memory. Defaults to <code>File</code>.
         * </p>
         * 
         * @param s3InputMode
         *        Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for
         *        the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode
         *        is useful for small files that fit in memory. Defaults to <code>File</code>.
         * @see ProcessingS3InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3InputMode
         */
        Builder s3InputMode(String s3InputMode);

        /**
         * <p>
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the
         * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful
         * for small files that fit in memory. Defaults to <code>File</code>.
         * </p>
         * 
         * @param s3InputMode
         *        Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for
         *        the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode
         *        is useful for small files that fit in memory. Defaults to <code>File</code>.
         * @see ProcessingS3InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3InputMode
         */
        Builder s3InputMode(ProcessingS3InputMode s3InputMode);

        /**
         * <p>
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
         * <code>FullyReplicated</code>
         * </p>
         * 
         * @param s3DataDistributionType
         *        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
         *        <code>FullyReplicated</code>
         * @see ProcessingS3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataDistributionType
         */
        Builder s3DataDistributionType(String s3DataDistributionType);

        /**
         * <p>
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
         * <code>FullyReplicated</code>
         * </p>
         * 
         * @param s3DataDistributionType
         *        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to
         *        <code>FullyReplicated</code>
         * @see ProcessingS3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataDistributionType
         */
        Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType);
    }

    static final class BuilderImpl implements Builder {
        private String endpointName;

        private String localPath;

        private String s3InputMode;

        private String s3DataDistributionType;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointInput model) {
            endpointName(model.endpointName);
            localPath(model.localPath);
            s3InputMode(model.s3InputMode);
            s3DataDistributionType(model.s3DataDistributionType);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getLocalPath() {
            return localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3InputMode() {
            return s3InputMode;
        }

        @Override
        public final Builder s3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
            return this;
        }

        @Override
        public final Builder s3InputMode(ProcessingS3InputMode s3InputMode) {
            this.s3InputMode(s3InputMode == null ? null : s3InputMode.toString());
            return this;
        }

        public final void setS3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
        }

        public final String getS3DataDistributionType() {
            return s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        @Override
        public EndpointInput build() {
            return new EndpointInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
