/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateModelPackageRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateModelPackageRequest.Builder, UpdateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageArn").getter(getter(UpdateModelPackageRequest::modelPackageArn))
            .setter(setter(Builder::modelPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()).build();

    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelApprovalStatus").getter(getter(UpdateModelPackageRequest::modelApprovalStatusAsString))
            .setter(setter(Builder::modelApprovalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build())
            .build();

    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalDescription").getter(getter(UpdateModelPackageRequest::approvalDescription))
            .setter(setter(Builder::approvalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_ARN_FIELD,
            MODEL_APPROVAL_STATUS_FIELD, APPROVAL_DESCRIPTION_FIELD));

    private final String modelPackageArn;

    private final String modelApprovalStatus;

    private final String approvalDescription;

    private UpdateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageArn = builder.modelPackageArn;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.approvalDescription = builder.approvalDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model.
     */
    public String modelPackageArn() {
        return modelPackageArn;
    }

    /**
     * <p>
     * The approval status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model.
     * @see ModelApprovalStatus
     */
    public ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(modelApprovalStatus);
    }

    /**
     * <p>
     * The approval status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model.
     * @see ModelApprovalStatus
     */
    public String modelApprovalStatusAsString() {
        return modelApprovalStatus;
    }

    /**
     * <p>
     * A description for the approval status of the model.
     * </p>
     * 
     * @return A description for the approval status of the model.
     */
    public String approvalDescription() {
        return approvalDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(approvalDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelPackageRequest)) {
            return false;
        }
        UpdateModelPackageRequest other = (UpdateModelPackageRequest) obj;
        return Objects.equals(modelPackageArn(), other.modelPackageArn())
                && Objects.equals(modelApprovalStatusAsString(), other.modelApprovalStatusAsString())
                && Objects.equals(approvalDescription(), other.approvalDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateModelPackageRequest").add("ModelPackageArn", modelPackageArn())
                .add("ModelApprovalStatus", modelApprovalStatusAsString()).add("ApprovalDescription", approvalDescription())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageArn":
            return Optional.ofNullable(clazz.cast(modelPackageArn()));
        case "ModelApprovalStatus":
            return Optional.ofNullable(clazz.cast(modelApprovalStatusAsString()));
        case "ApprovalDescription":
            return Optional.ofNullable(clazz.cast(approvalDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelPackageRequest, T> g) {
        return obj -> g.apply((UpdateModelPackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateModelPackageRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model.
         * </p>
         * 
         * @param modelPackageArn
         *        The Amazon Resource Name (ARN) of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageArn(String modelPackageArn);

        /**
         * <p>
         * The approval status of the model.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(String modelApprovalStatus);

        /**
         * <p>
         * The approval status of the model.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus);

        /**
         * <p>
         * A description for the approval status of the model.
         * </p>
         * 
         * @param approvalDescription
         *        A description for the approval status of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalDescription(String approvalDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelPackageArn;

        private String modelApprovalStatus;

        private String approvalDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelPackageRequest model) {
            super(model);
            modelPackageArn(model.modelPackageArn);
            modelApprovalStatus(model.modelApprovalStatus);
            approvalDescription(model.approvalDescription);
        }

        public final String getModelPackageArn() {
            return modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        public final String getModelApprovalStatus() {
            return modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        public final String getApprovalDescription() {
            return approvalDescription;
        }

        @Override
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelPackageRequest build() {
            return new UpdateModelPackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
