/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the user who created or modified an experiment, trial, or trial component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserContext implements SdkPojo, Serializable, ToCopyableBuilder<UserContext.Builder, UserContext> {
    private static final SdkField<String> USER_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileArn").getter(getter(UserContext::userProfileArn)).setter(setter(Builder::userProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileArn").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(UserContext::userProfileName)).setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UserContext::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILE_ARN_FIELD,
            USER_PROFILE_NAME_FIELD, DOMAIN_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userProfileArn;

    private final String userProfileName;

    private final String domainId;

    private UserContext(BuilderImpl builder) {
        this.userProfileArn = builder.userProfileArn;
        this.userProfileName = builder.userProfileName;
        this.domainId = builder.domainId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user's profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user's profile.
     */
    public String userProfileArn() {
        return userProfileArn;
    }

    /**
     * <p>
     * The name of the user's profile.
     * </p>
     * 
     * @return The name of the user's profile.
     */
    public String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The domain associated with the user.
     * </p>
     * 
     * @return The domain associated with the user.
     */
    public String domainId() {
        return domainId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserContext)) {
            return false;
        }
        UserContext other = (UserContext) obj;
        return Objects.equals(userProfileArn(), other.userProfileArn())
                && Objects.equals(userProfileName(), other.userProfileName()) && Objects.equals(domainId(), other.domainId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserContext").add("UserProfileArn", userProfileArn()).add("UserProfileName", userProfileName())
                .add("DomainId", domainId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserProfileArn":
            return Optional.ofNullable(clazz.cast(userProfileArn()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserContext, T> g) {
        return obj -> g.apply((UserContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserContext> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user's profile.
         * </p>
         * 
         * @param userProfileArn
         *        The Amazon Resource Name (ARN) of the user's profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileArn(String userProfileArn);

        /**
         * <p>
         * The name of the user's profile.
         * </p>
         * 
         * @param userProfileName
         *        The name of the user's profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The domain associated with the user.
         * </p>
         * 
         * @param domainId
         *        The domain associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);
    }

    static final class BuilderImpl implements Builder {
        private String userProfileArn;

        private String userProfileName;

        private String domainId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserContext model) {
            userProfileArn(model.userProfileArn);
            userProfileName(model.userProfileName);
            domainId(model.domainId);
        }

        public final String getUserProfileArn() {
            return userProfileArn;
        }

        @Override
        public final Builder userProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
            return this;
        }

        public final void setUserProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final String getDomainId() {
            return domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public UserContext build() {
            return new UserContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
