/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteArtifactRequest extends SageMakerRequest implements
        ToCopyableBuilder<DeleteArtifactRequest.Builder, DeleteArtifactRequest> {
    private static final SdkField<String> ARTIFACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactArn").getter(getter(DeleteArtifactRequest::artifactArn)).setter(setter(Builder::artifactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactArn").build()).build();

    private static final SdkField<ArtifactSource> SOURCE_FIELD = SdkField.<ArtifactSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(DeleteArtifactRequest::source)).setter(setter(Builder::source))
            .constructor(ArtifactSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_ARN_FIELD,
            SOURCE_FIELD));

    private final String artifactArn;

    private final ArtifactSource source;

    private DeleteArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.artifactArn = builder.artifactArn;
        this.source = builder.source;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the artifact to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the artifact to delete.
     */
    public String artifactArn() {
        return artifactArn;
    }

    /**
     * <p>
     * The URI of the source.
     * </p>
     * 
     * @return The URI of the source.
     */
    public ArtifactSource source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(artifactArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteArtifactRequest)) {
            return false;
        }
        DeleteArtifactRequest other = (DeleteArtifactRequest) obj;
        return Objects.equals(artifactArn(), other.artifactArn()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteArtifactRequest").add("ArtifactArn", artifactArn()).add("Source", source()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactArn":
            return Optional.ofNullable(clazz.cast(artifactArn()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteArtifactRequest, T> g) {
        return obj -> g.apply((DeleteArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteArtifactRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the artifact to delete.
         * </p>
         * 
         * @param artifactArn
         *        The Amazon Resource Name (ARN) of the artifact to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactArn(String artifactArn);

        /**
         * <p>
         * The URI of the source.
         * </p>
         * 
         * @param source
         *        The URI of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ArtifactSource source);

        /**
         * <p>
         * The URI of the source.
         * </p>
         * This is a convenience that creates an instance of the {@link ArtifactSource.Builder} avoiding the need to
         * create one manually via {@link ArtifactSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArtifactSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ArtifactSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ArtifactSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ArtifactSource)
         */
        default Builder source(Consumer<ArtifactSource.Builder> source) {
            return source(ArtifactSource.builder().applyMutation(source).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String artifactArn;

        private ArtifactSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteArtifactRequest model) {
            super(model);
            artifactArn(model.artifactArn);
            source(model.source);
        }

        public final String getArtifactArn() {
            return artifactArn;
        }

        @Override
        public final Builder artifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
            return this;
        }

        public final void setArtifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
        }

        public final ArtifactSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(ArtifactSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ArtifactSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteArtifactRequest build() {
            return new DeleteArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
