/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceFleetResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeDeviceFleetResponse.Builder, DescribeDeviceFleetResponse> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(DescribeDeviceFleetResponse::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<String> DEVICE_FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetArn").getter(getter(DescribeDeviceFleetResponse::deviceFleetArn))
            .setter(setter(Builder::deviceFleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetArn").build()).build();

    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<EdgeOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(DescribeDeviceFleetResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(EdgeOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeDeviceFleetResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeDeviceFleetResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeDeviceFleetResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeDeviceFleetResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> IOT_ROLE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotRoleAlias").getter(getter(DescribeDeviceFleetResponse::iotRoleAlias))
            .setter(setter(Builder::iotRoleAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotRoleAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD,
            DEVICE_FLEET_ARN_FIELD, OUTPUT_CONFIG_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            ROLE_ARN_FIELD, IOT_ROLE_ALIAS_FIELD));

    private final String deviceFleetName;

    private final String deviceFleetArn;

    private final EdgeOutputConfig outputConfig;

    private final String description;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String roleArn;

    private final String iotRoleAlias;

    private DescribeDeviceFleetResponse(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
        this.deviceFleetArn = builder.deviceFleetArn;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.roleArn = builder.roleArn;
        this.iotRoleAlias = builder.iotRoleAlias;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The The Amazon Resource Name (ARN) of the fleet.
     */
    public String deviceFleetArn() {
        return deviceFleetArn;
    }

    /**
     * <p>
     * The output configuration for storing sampled data.
     * </p>
     * 
     * @return The output configuration for storing sampled data.
     */
    public EdgeOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * A description of the fleet.
     * </p>
     * 
     * @return A description of the fleet.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Timestamp of when the device fleet was created.
     * </p>
     * 
     * @return Timestamp of when the device fleet was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Timestamp of when the device fleet was last updated.
     * </p>
     * 
     * @return Timestamp of when the device fleet was last updated.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) alias created in AWS Internet of Things (IoT).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) alias created in AWS Internet of Things (IoT).
     */
    public String iotRoleAlias() {
        return iotRoleAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(iotRoleAlias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceFleetResponse)) {
            return false;
        }
        DescribeDeviceFleetResponse other = (DescribeDeviceFleetResponse) obj;
        return Objects.equals(deviceFleetName(), other.deviceFleetName())
                && Objects.equals(deviceFleetArn(), other.deviceFleetArn())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(description(), other.description())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(iotRoleAlias(), other.iotRoleAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDeviceFleetResponse").add("DeviceFleetName", deviceFleetName())
                .add("DeviceFleetArn", deviceFleetArn()).add("OutputConfig", outputConfig()).add("Description", description())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).add("RoleArn", roleArn())
                .add("IotRoleAlias", iotRoleAlias()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "DeviceFleetArn":
            return Optional.ofNullable(clazz.cast(deviceFleetArn()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "IotRoleAlias":
            return Optional.ofNullable(clazz.cast(iotRoleAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceFleetResponse, T> g) {
        return obj -> g.apply((DescribeDeviceFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeviceFleetResponse> {
        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param deviceFleetArn
         *        The The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetArn(String deviceFleetArn);

        /**
         * <p>
         * The output configuration for storing sampled data.
         * </p>
         * 
         * @param outputConfig
         *        The output configuration for storing sampled data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(EdgeOutputConfig outputConfig);

        /**
         * <p>
         * The output configuration for storing sampled data.
         * </p>
         * This is a convenience that creates an instance of the {@link EdgeOutputConfig.Builder} avoiding the need to
         * create one manually via {@link EdgeOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EdgeOutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(EdgeOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link EdgeOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(EdgeOutputConfig)
         */
        default Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return outputConfig(EdgeOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * A description of the fleet.
         * </p>
         * 
         * @param description
         *        A description of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Timestamp of when the device fleet was created.
         * </p>
         * 
         * @param creationTime
         *        Timestamp of when the device fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Timestamp of when the device fleet was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        Timestamp of when the device fleet was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) alias created in AWS Internet of Things (IoT).
         * </p>
         * 
         * @param iotRoleAlias
         *        The Amazon Resource Name (ARN) alias created in AWS Internet of Things (IoT).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotRoleAlias(String iotRoleAlias);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String deviceFleetName;

        private String deviceFleetArn;

        private EdgeOutputConfig outputConfig;

        private String description;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String roleArn;

        private String iotRoleAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceFleetResponse model) {
            super(model);
            deviceFleetName(model.deviceFleetName);
            deviceFleetArn(model.deviceFleetArn);
            outputConfig(model.outputConfig);
            description(model.description);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            roleArn(model.roleArn);
            iotRoleAlias(model.iotRoleAlias);
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        public final String getDeviceFleetArn() {
            return deviceFleetArn;
        }

        @Override
        public final Builder deviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
            return this;
        }

        public final void setDeviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getIotRoleAlias() {
            return iotRoleAlias;
        }

        @Override
        public final Builder iotRoleAlias(String iotRoleAlias) {
            this.iotRoleAlias = iotRoleAlias;
            return this;
        }

        public final void setIotRoleAlias(String iotRoleAlias) {
            this.iotRoleAlias = iotRoleAlias;
        }

        @Override
        public DescribeDeviceFleetResponse build() {
            return new DescribeDeviceFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
