/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePipelineDefinitionForExecutionResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribePipelineDefinitionForExecutionResponse.Builder, DescribePipelineDefinitionForExecutionResponse> {
    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDefinition").getter(getter(DescribePipelineDefinitionForExecutionResponse::pipelineDefinition))
            .setter(setter(Builder::pipelineDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribePipelineDefinitionForExecutionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_DEFINITION_FIELD,
            CREATION_TIME_FIELD));

    private final String pipelineDefinition;

    private final Instant creationTime;

    private DescribePipelineDefinitionForExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineDefinition = builder.pipelineDefinition;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The JSON pipeline definition.
     * </p>
     * 
     * @return The JSON pipeline definition.
     */
    public String pipelineDefinition() {
        return pipelineDefinition;
    }

    /**
     * <p>
     * The time when the pipeline was created.
     * </p>
     * 
     * @return The time when the pipeline was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelineDefinitionForExecutionResponse)) {
            return false;
        }
        DescribePipelineDefinitionForExecutionResponse other = (DescribePipelineDefinitionForExecutionResponse) obj;
        return Objects.equals(pipelineDefinition(), other.pipelineDefinition())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePipelineDefinitionForExecutionResponse").add("PipelineDefinition", pipelineDefinition())
                .add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineDefinition":
            return Optional.ofNullable(clazz.cast(pipelineDefinition()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePipelineDefinitionForExecutionResponse, T> g) {
        return obj -> g.apply((DescribePipelineDefinitionForExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePipelineDefinitionForExecutionResponse> {
        /**
         * <p>
         * The JSON pipeline definition.
         * </p>
         * 
         * @param pipelineDefinition
         *        The JSON pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDefinition(String pipelineDefinition);

        /**
         * <p>
         * The time when the pipeline was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String pipelineDefinition;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelineDefinitionForExecutionResponse model) {
            super(model);
            pipelineDefinition(model.pipelineDefinition);
            creationTime(model.creationTime);
        }

        public final String getPipelineDefinition() {
            return pipelineDefinition;
        }

        @Override
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribePipelineDefinitionForExecutionResponse build() {
            return new DescribePipelineDefinitionForExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
