/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresignedDomainUrlRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreatePresignedDomainUrlRequest.Builder, CreatePresignedDomainUrlRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(CreatePresignedDomainUrlRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(CreatePresignedDomainUrlRequest::userProfileName))
            .setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<Integer> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionExpirationDurationInSeconds")
            .getter(getter(CreatePresignedDomainUrlRequest::sessionExpirationDurationInSeconds))
            .setter(setter(Builder::sessionExpirationDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_NAME_FIELD, SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD));

    private final String domainId;

    private final String userProfileName;

    private final Integer sessionExpirationDurationInSeconds;

    private CreatePresignedDomainUrlRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the UserProfile to sign-in as.
     * </p>
     * 
     * @return The name of the UserProfile to sign-in as.
     */
    public String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The session expiration duration in seconds.
     * </p>
     * 
     * @return The session expiration duration in seconds.
     */
    public Integer sessionExpirationDurationInSeconds() {
        return sessionExpirationDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionExpirationDurationInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedDomainUrlRequest)) {
            return false;
        }
        CreatePresignedDomainUrlRequest other = (CreatePresignedDomainUrlRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePresignedDomainUrlRequest").add("DomainId", domainId())
                .add("UserProfileName", userProfileName())
                .add("SessionExpirationDurationInSeconds", sessionExpirationDurationInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "SessionExpirationDurationInSeconds":
            return Optional.ofNullable(clazz.cast(sessionExpirationDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedDomainUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedDomainUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePresignedDomainUrlRequest> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the UserProfile to sign-in as.
         * </p>
         * 
         * @param userProfileName
         *        The name of the UserProfile to sign-in as.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The session expiration duration in seconds.
         * </p>
         * 
         * @param sessionExpirationDurationInSeconds
         *        The session expiration duration in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private String userProfileName;

        private Integer sessionExpirationDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedDomainUrlRequest model) {
            super(model);
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
        }

        public final String getDomainId() {
            return domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final Integer getSessionExpirationDurationInSeconds() {
            return sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        public final void setSessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedDomainUrlRequest build() {
            return new CreatePresignedDomainUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
