/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteModelPackageGroupPolicyRequest extends SageMakerRequest implements
        ToCopyableBuilder<DeleteModelPackageGroupPolicyRequest.Builder, DeleteModelPackageGroupPolicyRequest> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupName").getter(getter(DeleteModelPackageGroupPolicyRequest::modelPackageGroupName))
            .setter(setter(Builder::modelPackageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MODEL_PACKAGE_GROUP_NAME_FIELD));

    private final String modelPackageGroupName;

    private DeleteModelPackageGroupPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageGroupName = builder.modelPackageGroupName;
    }

    /**
     * <p>
     * The name of the model group for which to delete the policy.
     * </p>
     * 
     * @return The name of the model group for which to delete the policy.
     */
    public String modelPackageGroupName() {
        return modelPackageGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteModelPackageGroupPolicyRequest)) {
            return false;
        }
        DeleteModelPackageGroupPolicyRequest other = (DeleteModelPackageGroupPolicyRequest) obj;
        return Objects.equals(modelPackageGroupName(), other.modelPackageGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteModelPackageGroupPolicyRequest").add("ModelPackageGroupName", modelPackageGroupName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageGroupName":
            return Optional.ofNullable(clazz.cast(modelPackageGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteModelPackageGroupPolicyRequest, T> g) {
        return obj -> g.apply((DeleteModelPackageGroupPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteModelPackageGroupPolicyRequest> {
        /**
         * <p>
         * The name of the model group for which to delete the policy.
         * </p>
         * 
         * @param modelPackageGroupName
         *        The name of the model group for which to delete the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupName(String modelPackageGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelPackageGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteModelPackageGroupPolicyRequest model) {
            super(model);
            modelPackageGroupName(model.modelPackageGroupName);
        }

        public final String getModelPackageGroupName() {
            return modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteModelPackageGroupPolicyRequest build() {
            return new DeleteModelPackageGroupPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
