/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeDomainResponse.Builder, DescribeDomainResponse> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainArn").getter(getter(DescribeDomainResponse::domainArn)).setter(setter(Builder::domainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DescribeDomainResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DescribeDomainResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeEfsFileSystemId").getter(getter(DescribeDomainResponse::homeEfsFileSystemId))
            .setter(setter(Builder::homeEfsFileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemId").build())
            .build();

    private static final SdkField<String> SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnManagedApplicationInstanceId")
            .getter(getter(DescribeDomainResponse::singleSignOnManagedApplicationInstanceId))
            .setter(setter(Builder::singleSignOnManagedApplicationInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SingleSignOnManagedApplicationInstanceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDomainResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeDomainResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeDomainResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeDomainResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthMode").getter(getter(DescribeDomainResponse::authModeAsString)).setter(setter(Builder::authMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()).build();

    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField
            .<UserSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultUserSettings")
            .getter(getter(DescribeDomainResponse::defaultUserSettings)).setter(setter(Builder::defaultUserSettings))
            .constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build())
            .build();

    private static final SdkField<String> APP_NETWORK_ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppNetworkAccessType").getter(getter(DescribeDomainResponse::appNetworkAccessTypeAsString))
            .setter(setter(Builder::appNetworkAccessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppNetworkAccessType").build())
            .build();

    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("HomeEfsFileSystemKmsKeyId")
            .getter(getter(DescribeDomainResponse::homeEfsFileSystemKmsKeyId)).setter(setter(Builder::homeEfsFileSystemKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemKmsKeyId").build())
            .build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(DescribeDomainResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(DescribeDomainResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(DescribeDomainResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeDomainResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD,
            DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, HOME_EFS_FILE_SYSTEM_ID_FIELD,
            SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            FAILURE_REASON_FIELD, AUTH_MODE_FIELD, DEFAULT_USER_SETTINGS_FIELD, APP_NETWORK_ACCESS_TYPE_FIELD,
            HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD, SUBNET_IDS_FIELD, URL_FIELD, VPC_ID_FIELD, KMS_KEY_ID_FIELD));

    private final String domainArn;

    private final String domainId;

    private final String domainName;

    private final String homeEfsFileSystemId;

    private final String singleSignOnManagedApplicationInstanceId;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final String authMode;

    private final UserSettings defaultUserSettings;

    private final String appNetworkAccessType;

    private final String homeEfsFileSystemKmsKeyId;

    private final List<String> subnetIds;

    private final String url;

    private final String vpcId;

    private final String kmsKeyId;

    private DescribeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainArn = builder.domainArn;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.homeEfsFileSystemId = builder.homeEfsFileSystemId;
        this.singleSignOnManagedApplicationInstanceId = builder.singleSignOnManagedApplicationInstanceId;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.authMode = builder.authMode;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.appNetworkAccessType = builder.appNetworkAccessType;
        this.homeEfsFileSystemKmsKeyId = builder.homeEfsFileSystemKmsKeyId;
        this.subnetIds = builder.subnetIds;
        this.url = builder.url;
        this.vpcId = builder.vpcId;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The domain's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The domain's Amazon Resource Name (ARN).
     */
    public String domainArn() {
        return domainArn;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     * </p>
     * 
     * @return The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     */
    public String homeEfsFileSystemId() {
        return homeEfsFileSystemId;
    }

    /**
     * <p>
     * The SSO managed application instance ID.
     * </p>
     * 
     * @return The SSO managed application instance ID.
     */
    public String singleSignOnManagedApplicationInstanceId() {
        return singleSignOnManagedApplicationInstanceId;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see DomainStatus
     */
    public DomainStatus status() {
        return DomainStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see DomainStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last modified time.
     * </p>
     * 
     * @return The last modified time.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The failure reason.
     * </p>
     * 
     * @return The failure reason.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The domain's authentication mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return The domain's authentication mode.
     * @see AuthMode
     */
    public AuthMode authMode() {
        return AuthMode.fromValue(authMode);
    }

    /**
     * <p>
     * The domain's authentication mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return The domain's authentication mode.
     * @see AuthMode
     */
    public String authModeAsString() {
        return authMode;
    }

    /**
     * <p>
     * Settings which are applied to all UserProfiles in this domain, if settings are not explicitly specified in a
     * given UserProfile.
     * </p>
     * 
     * @return Settings which are applied to all UserProfiles in this domain, if settings are not explicitly specified
     *         in a given UserProfile.
     */
    public UserSettings defaultUserSettings() {
        return defaultUserSettings;
    }

    /**
     * <p>
     * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
     * direct internet access
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appNetworkAccessType} will return {@link AppNetworkAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appNetworkAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
     *         allows direct internet access
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
     *         </p>
     *         </li>
     * @see AppNetworkAccessType
     */
    public AppNetworkAccessType appNetworkAccessType() {
        return AppNetworkAccessType.fromValue(appNetworkAccessType);
    }

    /**
     * <p>
     * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
     * direct internet access
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appNetworkAccessType} will return {@link AppNetworkAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appNetworkAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
     *         allows direct internet access
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
     *         </p>
     *         </li>
     * @see AppNetworkAccessType
     */
    public String appNetworkAccessTypeAsString() {
        return appNetworkAccessType;
    }

    /**
     * <p>
     * This member is deprecated and replaced with <code>KmsKeyId</code>.
     * </p>
     * 
     * @return This member is deprecated and replaced with <code>KmsKeyId</code>.
     */
    public String homeEfsFileSystemKmsKeyId() {
        return homeEfsFileSystemKmsKeyId;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC subnets that Studio uses for communication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The VPC subnets that Studio uses for communication.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The domain's URL.
     * </p>
     * 
     * @return The domain's URL.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * </p>
     * 
     * @return The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     * </p>
     * 
     * @return The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnManagedApplicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(appNetworkAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse) obj;
        return Objects.equals(domainArn(), other.domainArn()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(homeEfsFileSystemId(), other.homeEfsFileSystemId())
                && Objects.equals(singleSignOnManagedApplicationInstanceId(), other.singleSignOnManagedApplicationInstanceId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(authModeAsString(), other.authModeAsString())
                && Objects.equals(defaultUserSettings(), other.defaultUserSettings())
                && Objects.equals(appNetworkAccessTypeAsString(), other.appNetworkAccessTypeAsString())
                && Objects.equals(homeEfsFileSystemKmsKeyId(), other.homeEfsFileSystemKmsKeyId())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(url(), other.url()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDomainResponse").add("DomainArn", domainArn()).add("DomainId", domainId())
                .add("DomainName", domainName()).add("HomeEfsFileSystemId", homeEfsFileSystemId())
                .add("SingleSignOnManagedApplicationInstanceId", singleSignOnManagedApplicationInstanceId())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("FailureReason", failureReason()).add("AuthMode", authModeAsString())
                .add("DefaultUserSettings", defaultUserSettings()).add("AppNetworkAccessType", appNetworkAccessTypeAsString())
                .add("HomeEfsFileSystemKmsKeyId", homeEfsFileSystemKmsKeyId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Url", url()).add("VpcId", vpcId())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainArn":
            return Optional.ofNullable(clazz.cast(domainArn()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "HomeEfsFileSystemId":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemId()));
        case "SingleSignOnManagedApplicationInstanceId":
            return Optional.ofNullable(clazz.cast(singleSignOnManagedApplicationInstanceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "AuthMode":
            return Optional.ofNullable(clazz.cast(authModeAsString()));
        case "DefaultUserSettings":
            return Optional.ofNullable(clazz.cast(defaultUserSettings()));
        case "AppNetworkAccessType":
            return Optional.ofNullable(clazz.cast(appNetworkAccessTypeAsString()));
        case "HomeEfsFileSystemKmsKeyId":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemKmsKeyId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainResponse, T> g) {
        return obj -> g.apply((DescribeDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDomainResponse> {
        /**
         * <p>
         * The domain's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param domainArn
         *        The domain's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainArn(String domainArn);

        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
         * </p>
         * 
         * @param homeEfsFileSystemId
         *        The ID of the Amazon Elastic File System (EFS) managed by this Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeEfsFileSystemId(String homeEfsFileSystemId);

        /**
         * <p>
         * The SSO managed application instance ID.
         * </p>
         * 
         * @param singleSignOnManagedApplicationInstanceId
         *        The SSO managed application instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(DomainStatus status);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The failure reason.
         * </p>
         * 
         * @param failureReason
         *        The failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The domain's authentication mode.
         * </p>
         * 
         * @param authMode
         *        The domain's authentication mode.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(String authMode);

        /**
         * <p>
         * The domain's authentication mode.
         * </p>
         * 
         * @param authMode
         *        The domain's authentication mode.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(AuthMode authMode);

        /**
         * <p>
         * Settings which are applied to all UserProfiles in this domain, if settings are not explicitly specified in a
         * given UserProfile.
         * </p>
         * 
         * @param defaultUserSettings
         *        Settings which are applied to all UserProfiles in this domain, if settings are not explicitly
         *        specified in a given UserProfile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultUserSettings(UserSettings defaultUserSettings);

        /**
         * <p>
         * Settings which are applied to all UserProfiles in this domain, if settings are not explicitly specified in a
         * given UserProfile.
         * </p>
         * This is a convenience that creates an instance of the {@link UserSettings.Builder} avoiding the need to
         * create one manually via {@link UserSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultUserSettings(UserSettings)}.
         * 
         * @param defaultUserSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultUserSettings(UserSettings)
         */
        default Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return defaultUserSettings(UserSettings.builder().applyMutation(defaultUserSettings).build());
        }

        /**
         * <p>
         * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
         * direct internet access
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
         * </p>
         * </li>
         * </ul>
         * 
         * @param appNetworkAccessType
         *        Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
         *        allows direct internet access
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
         *        </p>
         *        </li>
         * @see AppNetworkAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppNetworkAccessType
         */
        Builder appNetworkAccessType(String appNetworkAccessType);

        /**
         * <p>
         * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
         * direct internet access
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
         * </p>
         * </li>
         * </ul>
         * 
         * @param appNetworkAccessType
         *        Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
         *        allows direct internet access
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets
         *        </p>
         *        </li>
         * @see AppNetworkAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppNetworkAccessType
         */
        Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType);

        /**
         * <p>
         * This member is deprecated and replaced with <code>KmsKeyId</code>.
         * </p>
         * 
         * @param homeEfsFileSystemKmsKeyId
         *        This member is deprecated and replaced with <code>KmsKeyId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId);

        /**
         * <p>
         * The VPC subnets that Studio uses for communication.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets that Studio uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The VPC subnets that Studio uses for communication.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets that Studio uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The domain's URL.
         * </p>
         * 
         * @param url
         *        The domain's URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String domainArn;

        private String domainId;

        private String domainName;

        private String homeEfsFileSystemId;

        private String singleSignOnManagedApplicationInstanceId;

        private String status;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private String authMode;

        private UserSettings defaultUserSettings;

        private String appNetworkAccessType;

        private String homeEfsFileSystemKmsKeyId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String url;

        private String vpcId;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            super(model);
            domainArn(model.domainArn);
            domainId(model.domainId);
            domainName(model.domainName);
            homeEfsFileSystemId(model.homeEfsFileSystemId);
            singleSignOnManagedApplicationInstanceId(model.singleSignOnManagedApplicationInstanceId);
            status(model.status);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            authMode(model.authMode);
            defaultUserSettings(model.defaultUserSettings);
            appNetworkAccessType(model.appNetworkAccessType);
            homeEfsFileSystemKmsKeyId(model.homeEfsFileSystemKmsKeyId);
            subnetIds(model.subnetIds);
            url(model.url);
            vpcId(model.vpcId);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getDomainArn() {
            return domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        public final String getDomainId() {
            return domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getHomeEfsFileSystemId() {
            return homeEfsFileSystemId;
        }

        @Override
        public final Builder homeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
            return this;
        }

        public final void setHomeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
        }

        public final String getSingleSignOnManagedApplicationInstanceId() {
            return singleSignOnManagedApplicationInstanceId;
        }

        @Override
        public final Builder singleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
            return this;
        }

        public final void setSingleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getAuthMode() {
            return authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return defaultUserSettings != null ? defaultUserSettings.toBuilder() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        public final String getAppNetworkAccessType() {
            return appNetworkAccessType;
        }

        @Override
        public final Builder appNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        @Override
        public final Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType) {
            this.appNetworkAccessType(appNetworkAccessType == null ? null : appNetworkAccessType.toString());
            return this;
        }

        public final void setAppNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
        }

        public final String getHomeEfsFileSystemKmsKeyId() {
            return homeEfsFileSystemKmsKeyId;
        }

        @Override
        public final Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
            return this;
        }

        public final void setHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
