/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status of devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceStats implements SdkPojo, Serializable, ToCopyableBuilder<DeviceStats.Builder, DeviceStats> {
    private static final SdkField<Long> CONNECTED_DEVICE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ConnectedDeviceCount").getter(getter(DeviceStats::connectedDeviceCount))
            .setter(setter(Builder::connectedDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDeviceCount").build())
            .build();

    private static final SdkField<Long> REGISTERED_DEVICE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RegisteredDeviceCount").getter(getter(DeviceStats::registeredDeviceCount))
            .setter(setter(Builder::registeredDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredDeviceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTED_DEVICE_COUNT_FIELD,
            REGISTERED_DEVICE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long connectedDeviceCount;

    private final Long registeredDeviceCount;

    private DeviceStats(BuilderImpl builder) {
        this.connectedDeviceCount = builder.connectedDeviceCount;
        this.registeredDeviceCount = builder.registeredDeviceCount;
    }

    /**
     * <p>
     * The number of devices connected with a heartbeat.
     * </p>
     * 
     * @return The number of devices connected with a heartbeat.
     */
    public Long connectedDeviceCount() {
        return connectedDeviceCount;
    }

    /**
     * <p>
     * The number of registered devices.
     * </p>
     * 
     * @return The number of registered devices.
     */
    public Long registeredDeviceCount() {
        return registeredDeviceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(registeredDeviceCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStats)) {
            return false;
        }
        DeviceStats other = (DeviceStats) obj;
        return Objects.equals(connectedDeviceCount(), other.connectedDeviceCount())
                && Objects.equals(registeredDeviceCount(), other.registeredDeviceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceStats").add("ConnectedDeviceCount", connectedDeviceCount())
                .add("RegisteredDeviceCount", registeredDeviceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectedDeviceCount":
            return Optional.ofNullable(clazz.cast(connectedDeviceCount()));
        case "RegisteredDeviceCount":
            return Optional.ofNullable(clazz.cast(registeredDeviceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceStats, T> g) {
        return obj -> g.apply((DeviceStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceStats> {
        /**
         * <p>
         * The number of devices connected with a heartbeat.
         * </p>
         * 
         * @param connectedDeviceCount
         *        The number of devices connected with a heartbeat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDeviceCount(Long connectedDeviceCount);

        /**
         * <p>
         * The number of registered devices.
         * </p>
         * 
         * @param registeredDeviceCount
         *        The number of registered devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredDeviceCount(Long registeredDeviceCount);
    }

    static final class BuilderImpl implements Builder {
        private Long connectedDeviceCount;

        private Long registeredDeviceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStats model) {
            connectedDeviceCount(model.connectedDeviceCount);
            registeredDeviceCount(model.registeredDeviceCount);
        }

        public final Long getConnectedDeviceCount() {
            return connectedDeviceCount;
        }

        @Override
        public final Builder connectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
            return this;
        }

        public final void setConnectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
        }

        public final Long getRegisteredDeviceCount() {
            return registeredDeviceCount;
        }

        @Override
        public final Builder registeredDeviceCount(Long registeredDeviceCount) {
            this.registeredDeviceCount = registeredDeviceCount;
            return this;
        }

        public final void setRegisteredDeviceCount(Long registeredDeviceCount) {
            this.registeredDeviceCount = registeredDeviceCount;
        }

        @Override
        public DeviceStats build() {
            return new DeviceStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
