/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration details for a Git repository in your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitConfig implements SdkPojo, Serializable, ToCopyableBuilder<GitConfig.Builder, GitConfig> {
    private static final SdkField<String> REPOSITORY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryUrl").getter(getter(GitConfig::repositoryUrl)).setter(setter(Builder::repositoryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryUrl").build()).build();

    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Branch")
            .getter(getter(GitConfig::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(GitConfig::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_URL_FIELD,
            BRANCH_FIELD, SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryUrl;

    private final String branch;

    private final String secretArn;

    private GitConfig(BuilderImpl builder) {
        this.repositoryUrl = builder.repositoryUrl;
        this.branch = builder.branch;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * The URL where the Git repository is located.
     * </p>
     * 
     * @return The URL where the Git repository is located.
     */
    public String repositoryUrl() {
        return repositoryUrl;
    }

    /**
     * <p>
     * The default branch for the Git repository.
     * </p>
     * 
     * @return The default branch for the Git repository.
     */
    public String branch() {
        return branch;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the
     * git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following
     * format:
     * </p>
     * <p>
     * <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to
     *         access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in
     *         the following format:</p>
     *         <p>
     *         <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
     */
    public String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitConfig)) {
            return false;
        }
        GitConfig other = (GitConfig) obj;
        return Objects.equals(repositoryUrl(), other.repositoryUrl()) && Objects.equals(branch(), other.branch())
                && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GitConfig").add("RepositoryUrl", repositoryUrl()).add("Branch", branch())
                .add("SecretArn", secretArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryUrl":
            return Optional.ofNullable(clazz.cast(repositoryUrl()));
        case "Branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitConfig, T> g) {
        return obj -> g.apply((GitConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitConfig> {
        /**
         * <p>
         * The URL where the Git repository is located.
         * </p>
         * 
         * @param repositoryUrl
         *        The URL where the Git repository is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryUrl(String repositoryUrl);

        /**
         * <p>
         * The default branch for the Git repository.
         * </p>
         * 
         * @param branch
         *        The default branch for the Git repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access
         * the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the
         * following format:
         * </p>
         * <p>
         * <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to
         *        access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be
         *        in the following format:</p>
         *        <p>
         *        <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryUrl;

        private String branch;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GitConfig model) {
            repositoryUrl(model.repositoryUrl);
            branch(model.branch);
            secretArn(model.secretArn);
        }

        public final String getRepositoryUrl() {
            return repositoryUrl;
        }

        @Override
        public final Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public final void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        public final String getBranch() {
            return branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public GitConfig build() {
            return new GitConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
