/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelExplainabilityJobDefinitionsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListModelExplainabilityJobDefinitionsRequest.Builder, ListModelExplainabilityJobDefinitionsRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(ListModelExplainabilityJobDefinitionsRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListModelExplainabilityJobDefinitionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListModelExplainabilityJobDefinitionsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelExplainabilityJobDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListModelExplainabilityJobDefinitionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListModelExplainabilityJobDefinitionsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListModelExplainabilityJobDefinitionsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListModelExplainabilityJobDefinitionsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAME_CONTAINS_FIELD,
            CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD));

    private final String endpointName;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private ListModelExplainabilityJobDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
    }

    /**
     * <p>
     * Name of the endpoint to monitor for model explainability.
     * </p>
     * 
     * @return Name of the endpoint to monitor for model explainability.
     */
    public String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
     * <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringJobDefinitionSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
     *         <code>CreationTime</code>.
     * @see MonitoringJobDefinitionSortKey
     */
    public MonitoringJobDefinitionSortKey sortBy() {
        return MonitoringJobDefinitionSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
     * <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringJobDefinitionSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
     *         <code>CreationTime</code>.
     * @see MonitoringJobDefinitionSortKey
     */
    public String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next
     * request.
     * </p>
     * 
     * @return The token returned if the response is truncated. To retrieve the next set of job executions, use it in
     *         the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of jobs to return in the response. The default value is 10.
     * </p>
     * 
     * @return The maximum number of jobs to return in the response. The default value is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter for model explainability jobs whose name contains a specified string.
     * </p>
     * 
     * @return Filter for model explainability jobs whose name contains a specified string.
     */
    public String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * A filter that returns only model explainability jobs created before a specified time.
     * </p>
     * 
     * @return A filter that returns only model explainability jobs created before a specified time.
     */
    public Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only model explainability jobs created after a specified time.
     * </p>
     * 
     * @return A filter that returns only model explainability jobs created after a specified time.
     */
    public Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelExplainabilityJobDefinitionsRequest)) {
            return false;
        }
        ListModelExplainabilityJobDefinitionsRequest other = (ListModelExplainabilityJobDefinitionsRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListModelExplainabilityJobDefinitionsRequest").add("EndpointName", endpointName())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("NameContains", nameContains())
                .add("CreationTimeBefore", creationTimeBefore()).add("CreationTimeAfter", creationTimeAfter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelExplainabilityJobDefinitionsRequest, T> g) {
        return obj -> g.apply((ListModelExplainabilityJobDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListModelExplainabilityJobDefinitionsRequest> {
        /**
         * <p>
         * Name of the endpoint to monitor for model explainability.
         * </p>
         * 
         * @param endpointName
         *        Name of the endpoint to monitor for model explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
         * <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
         *        <code>CreationTime</code>.
         * @see MonitoringJobDefinitionSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringJobDefinitionSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
         * <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is
         *        <code>CreationTime</code>.
         * @see MonitoringJobDefinitionSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringJobDefinitionSortKey
         */
        Builder sortBy(MonitoringJobDefinitionSortKey sortBy);

        /**
         * <p>
         * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         * <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         * <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The token returned if the response is truncated. To retrieve the next set of job executions, use it in the
         * next request.
         * </p>
         * 
         * @param nextToken
         *        The token returned if the response is truncated. To retrieve the next set of job executions, use it in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of jobs to return in the response. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of jobs to return in the response. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter for model explainability jobs whose name contains a specified string.
         * </p>
         * 
         * @param nameContains
         *        Filter for model explainability jobs whose name contains a specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * A filter that returns only model explainability jobs created before a specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only model explainability jobs created before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns only model explainability jobs created after a specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only model explainability jobs created after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelExplainabilityJobDefinitionsRequest model) {
            super(model);
            endpointName(model.endpointName);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(MonitoringJobDefinitionSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelExplainabilityJobDefinitionsRequest build() {
            return new ListModelExplainabilityJobDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
