/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProcessingJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListProcessingJobsResponse.Builder, ListProcessingJobsResponse> {
    private static final SdkField<List<ProcessingJobSummary>> PROCESSING_JOB_SUMMARIES_FIELD = SdkField
            .<List<ProcessingJobSummary>> builder(MarshallingType.LIST)
            .memberName("ProcessingJobSummaries")
            .getter(getter(ListProcessingJobsResponse::processingJobSummaries))
            .setter(setter(Builder::processingJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProcessingJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessingJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProcessingJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROCESSING_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ProcessingJobSummary> processingJobSummaries;

    private final String nextToken;

    private ListProcessingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.processingJobSummaries = builder.processingJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ProcessingJobSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProcessingJobSummaries() {
        return processingJobSummaries != null && !(processingJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessingJobSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.
     */
    public List<ProcessingJobSummary> processingJobSummaries() {
        return processingJobSummaries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs,
     * use it in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing
     *         jobs, use it in the subsequent request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessingJobSummaries() ? processingJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProcessingJobsResponse)) {
            return false;
        }
        ListProcessingJobsResponse other = (ListProcessingJobsResponse) obj;
        return hasProcessingJobSummaries() == other.hasProcessingJobSummaries()
                && Objects.equals(processingJobSummaries(), other.processingJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProcessingJobsResponse")
                .add("ProcessingJobSummaries", hasProcessingJobSummaries() ? processingJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessingJobSummaries":
            return Optional.ofNullable(clazz.cast(processingJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProcessingJobsResponse, T> g) {
        return obj -> g.apply((ListProcessingJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProcessingJobsResponse> {
        /**
         * <p>
         * An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.
         * </p>
         * 
         * @param processingJobSummaries
         *        An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobSummaries(Collection<ProcessingJobSummary> processingJobSummaries);

        /**
         * <p>
         * An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.
         * </p>
         * 
         * @param processingJobSummaries
         *        An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobSummaries(ProcessingJobSummary... processingJobSummaries);

        /**
         * <p>
         * An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProcessingJobSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ProcessingJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessingJobSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #processingJobSummaries(List<ProcessingJobSummary>)}.
         * 
         * @param processingJobSummaries
         *        a consumer that will call methods on {@link List<ProcessingJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingJobSummaries(List<ProcessingJobSummary>)
         */
        Builder processingJobSummaries(Consumer<ProcessingJobSummary.Builder>... processingJobSummaries);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing
         * jobs, use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of
         *        processing jobs, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ProcessingJobSummary> processingJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProcessingJobsResponse model) {
            super(model);
            processingJobSummaries(model.processingJobSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<ProcessingJobSummary.Builder> getProcessingJobSummaries() {
            if (processingJobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return processingJobSummaries != null ? processingJobSummaries.stream().map(ProcessingJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processingJobSummaries(Collection<ProcessingJobSummary> processingJobSummaries) {
            this.processingJobSummaries = ProcessingJobSummariesCopier.copy(processingJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingJobSummaries(ProcessingJobSummary... processingJobSummaries) {
            processingJobSummaries(Arrays.asList(processingJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingJobSummaries(Consumer<ProcessingJobSummary.Builder>... processingJobSummaries) {
            processingJobSummaries(Stream.of(processingJobSummaries)
                    .map(c -> ProcessingJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessingJobSummaries(Collection<ProcessingJobSummary.BuilderImpl> processingJobSummaries) {
            this.processingJobSummaries = ProcessingJobSummariesCopier.copyFromBuilder(processingJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProcessingJobsResponse build() {
            return new ListProcessingJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
