/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provided configuration information for the worker UI for a labeling job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UiConfig implements SdkPojo, Serializable, ToCopyableBuilder<UiConfig.Builder, UiConfig> {
    private static final SdkField<String> UI_TEMPLATE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UiTemplateS3Uri").getter(getter(UiConfig::uiTemplateS3Uri)).setter(setter(Builder::uiTemplateS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiTemplateS3Uri").build()).build();

    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanTaskUiArn").getter(getter(UiConfig::humanTaskUiArn)).setter(setter(Builder::humanTaskUiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UI_TEMPLATE_S3_URI_FIELD,
            HUMAN_TASK_UI_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String uiTemplateS3Uri;

    private final String humanTaskUiArn;

    private UiConfig(BuilderImpl builder) {
        this.uiTemplateS3Uri = builder.uiTemplateS3Uri;
        this.humanTaskUiArn = builder.humanTaskUiArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to render
     * the worker UI and tools for labeling job tasks. For more information about the contents of a UI template, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html"> Creating Your Custom
     * Labeling Task Template</a>.
     * </p>
     * 
     * @return The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to
     *         render the worker UI and tools for labeling job tasks. For more information about the contents of a UI
     *         template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html">
     *         Creating Your Custom Labeling Task Template</a>.
     */
    public String uiTemplateS3Uri() {
        return uiTemplateS3Uri;
    }

    /**
     * <p>
     * The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.
     * </p>
     * <p>
     * Use this parameter when you are creating a labeling job for 3D point cloud and video fram labeling jobs. Use your
     * labeling job task type to select one of the following ARN's and use it with this parameter when you create a
     * labeling job. Replace <code>aws-region</code> with the AWS region you are creating your labeling job in.
     * </p>
     * <p>
     * <b>3D Point Cloud HumanTaskUiArns</b>
     * </p>
     * <p>
     * Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object detection
     * adjustment labeling jobs.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object tracking
     * adjustment labeling jobs.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud semantic
     * segmentation adjustment labeling jobs.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Video Frame HumanTaskUiArns</b>
     * </p>
     * <p>
     * Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection adjustment
     * labeling jobs.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking adjustment
     * labeling jobs.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.</p>
     *         <p>
     *         Use this parameter when you are creating a labeling job for 3D point cloud and video fram labeling jobs.
     *         Use your labeling job task type to select one of the following ARN's and use it with this parameter when
     *         you create a labeling job. Replace <code>aws-region</code> with the AWS region you are creating your
     *         labeling job in.
     *         </p>
     *         <p>
     *         <b>3D Point Cloud HumanTaskUiArns</b>
     *         </p>
     *         <p>
     *         Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object
     *         detection adjustment labeling jobs.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object
     *         tracking adjustment labeling jobs.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud semantic
     *         segmentation adjustment labeling jobs.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Video Frame HumanTaskUiArns</b>
     *         </p>
     *         <p>
     *         Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection
     *         adjustment labeling jobs.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking
     *         adjustment labeling jobs.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code>
     *         </p>
     *         </li>
     */
    public String humanTaskUiArn() {
        return humanTaskUiArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uiTemplateS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UiConfig)) {
            return false;
        }
        UiConfig other = (UiConfig) obj;
        return Objects.equals(uiTemplateS3Uri(), other.uiTemplateS3Uri())
                && Objects.equals(humanTaskUiArn(), other.humanTaskUiArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UiConfig").add("UiTemplateS3Uri", uiTemplateS3Uri()).add("HumanTaskUiArn", humanTaskUiArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UiTemplateS3Uri":
            return Optional.ofNullable(clazz.cast(uiTemplateS3Uri()));
        case "HumanTaskUiArn":
            return Optional.ofNullable(clazz.cast(humanTaskUiArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UiConfig, T> g) {
        return obj -> g.apply((UiConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UiConfig> {
        /**
         * <p>
         * The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to
         * render the worker UI and tools for labeling job tasks. For more information about the contents of a UI
         * template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html">
         * Creating Your Custom Labeling Task Template</a>.
         * </p>
         * 
         * @param uiTemplateS3Uri
         *        The Amazon S3 bucket location of the UI template, or worker task template. This is the template used
         *        to render the worker UI and tools for labeling job tasks. For more information about the contents of a
         *        UI template, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html"> Creating Your
         *        Custom Labeling Task Template</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiTemplateS3Uri(String uiTemplateS3Uri);

        /**
         * <p>
         * The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.
         * </p>
         * <p>
         * Use this parameter when you are creating a labeling job for 3D point cloud and video fram labeling jobs. Use
         * your labeling job task type to select one of the following ARN's and use it with this parameter when you
         * create a labeling job. Replace <code>aws-region</code> with the AWS region you are creating your labeling job
         * in.
         * </p>
         * <p>
         * <b>3D Point Cloud HumanTaskUiArns</b>
         * </p>
         * <p>
         * Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object detection
         * adjustment labeling jobs.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object tracking
         * adjustment labeling jobs.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud semantic
         * segmentation adjustment labeling jobs.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Video Frame HumanTaskUiArns</b>
         * </p>
         * <p>
         * Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection
         * adjustment labeling jobs.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking
         * adjustment labeling jobs.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param humanTaskUiArn
         *        The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.</p>
         *        <p>
         *        Use this parameter when you are creating a labeling job for 3D point cloud and video fram labeling
         *        jobs. Use your labeling job task type to select one of the following ARN's and use it with this
         *        parameter when you create a labeling job. Replace <code>aws-region</code> with the AWS region you are
         *        creating your labeling job in.
         *        </p>
         *        <p>
         *        <b>3D Point Cloud HumanTaskUiArns</b>
         *        </p>
         *        <p>
         *        Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object
         *        detection adjustment labeling jobs.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object
         *        tracking adjustment labeling jobs.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud
         *        semantic segmentation adjustment labeling jobs.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Video Frame HumanTaskUiArns</b>
         *        </p>
         *        <p>
         *        Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection
         *        adjustment labeling jobs.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking
         *        adjustment labeling jobs.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiArn(String humanTaskUiArn);
    }

    static final class BuilderImpl implements Builder {
        private String uiTemplateS3Uri;

        private String humanTaskUiArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UiConfig model) {
            uiTemplateS3Uri(model.uiTemplateS3Uri);
            humanTaskUiArn(model.humanTaskUiArn);
        }

        public final String getUiTemplateS3Uri() {
            return uiTemplateS3Uri;
        }

        @Override
        public final Builder uiTemplateS3Uri(String uiTemplateS3Uri) {
            this.uiTemplateS3Uri = uiTemplateS3Uri;
            return this;
        }

        public final void setUiTemplateS3Uri(String uiTemplateS3Uri) {
            this.uiTemplateS3Uri = uiTemplateS3Uri;
        }

        public final String getHumanTaskUiArn() {
            return humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        @Override
        public UiConfig build() {
            return new UiConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
