/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateArtifactRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateArtifactRequest.Builder, UpdateArtifactRequest> {
    private static final SdkField<String> ARTIFACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactArn").getter(getter(UpdateArtifactRequest::artifactArn)).setter(setter(Builder::artifactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactArn").build()).build();

    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactName").getter(getter(UpdateArtifactRequest::artifactName)).setter(setter(Builder::artifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactName").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(UpdateArtifactRequest::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PROPERTIES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PropertiesToRemove")
            .getter(getter(UpdateArtifactRequest::propertiesToRemove))
            .setter(setter(Builder::propertiesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_ARN_FIELD,
            ARTIFACT_NAME_FIELD, PROPERTIES_FIELD, PROPERTIES_TO_REMOVE_FIELD));

    private final String artifactArn;

    private final String artifactName;

    private final Map<String, String> properties;

    private final List<String> propertiesToRemove;

    private UpdateArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.artifactArn = builder.artifactArn;
        this.artifactName = builder.artifactName;
        this.properties = builder.properties;
        this.propertiesToRemove = builder.propertiesToRemove;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the artifact to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the artifact to update.
     */
    public String artifactArn() {
        return artifactArn;
    }

    /**
     * <p>
     * The new name for the artifact.
     * </p>
     * 
     * @return The new name for the artifact.
     */
    public String artifactName() {
        return artifactName;
    }

    /**
     * Returns true if the Properties property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The new list of properties. Overwrites the current property list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new list of properties. Overwrites the current property list.
     */
    public Map<String, String> properties() {
        return properties;
    }

    /**
     * Returns true if the PropertiesToRemove property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPropertiesToRemove() {
        return propertiesToRemove != null && !(propertiesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of properties to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPropertiesToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of properties to remove.
     */
    public List<String> propertiesToRemove() {
        return propertiesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(artifactArn());
        hashCode = 31 * hashCode + Objects.hashCode(artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertiesToRemove() ? propertiesToRemove() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArtifactRequest)) {
            return false;
        }
        UpdateArtifactRequest other = (UpdateArtifactRequest) obj;
        return Objects.equals(artifactArn(), other.artifactArn()) && Objects.equals(artifactName(), other.artifactName())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && hasPropertiesToRemove() == other.hasPropertiesToRemove()
                && Objects.equals(propertiesToRemove(), other.propertiesToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateArtifactRequest").add("ArtifactArn", artifactArn()).add("ArtifactName", artifactName())
                .add("Properties", hasProperties() ? properties() : null)
                .add("PropertiesToRemove", hasPropertiesToRemove() ? propertiesToRemove() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactArn":
            return Optional.ofNullable(clazz.cast(artifactArn()));
        case "ArtifactName":
            return Optional.ofNullable(clazz.cast(artifactName()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "PropertiesToRemove":
            return Optional.ofNullable(clazz.cast(propertiesToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateArtifactRequest, T> g) {
        return obj -> g.apply((UpdateArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateArtifactRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the artifact to update.
         * </p>
         * 
         * @param artifactArn
         *        The Amazon Resource Name (ARN) of the artifact to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactArn(String artifactArn);

        /**
         * <p>
         * The new name for the artifact.
         * </p>
         * 
         * @param artifactName
         *        The new name for the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactName(String artifactName);

        /**
         * <p>
         * The new list of properties. Overwrites the current property list.
         * </p>
         * 
         * @param properties
         *        The new list of properties. Overwrites the current property list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * A list of properties to remove.
         * </p>
         * 
         * @param propertiesToRemove
         *        A list of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToRemove(Collection<String> propertiesToRemove);

        /**
         * <p>
         * A list of properties to remove.
         * </p>
         * 
         * @param propertiesToRemove
         *        A list of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToRemove(String... propertiesToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String artifactArn;

        private String artifactName;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private List<String> propertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArtifactRequest model) {
            super(model);
            artifactArn(model.artifactArn);
            artifactName(model.artifactName);
            properties(model.properties);
            propertiesToRemove(model.propertiesToRemove);
        }

        public final String getArtifactArn() {
            return artifactArn;
        }

        @Override
        public final Builder artifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
            return this;
        }

        public final void setArtifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
        }

        public final String getArtifactName() {
            return artifactName;
        }

        @Override
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        public final Collection<String> getPropertiesToRemove() {
            if (propertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return propertiesToRemove;
        }

        @Override
        public final Builder propertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToRemove(String... propertiesToRemove) {
            propertiesToRemove(Arrays.asList(propertiesToRemove));
            return this;
        }

        public final void setPropertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateArtifactRequest build() {
            return new UpdateArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
