/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Autopilot job returns recommendations, or candidates. Each candidate has futher details about the steps involed,
 * and the status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLCandidate implements SdkPojo, Serializable, ToCopyableBuilder<AutoMLCandidate.Builder, AutoMLCandidate> {
    private static final SdkField<String> CANDIDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateName").getter(getter(AutoMLCandidate::candidateName)).setter(setter(Builder::candidateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateName").build()).build();

    private static final SdkField<FinalAutoMLJobObjectiveMetric> FINAL_AUTO_ML_JOB_OBJECTIVE_METRIC_FIELD = SdkField
            .<FinalAutoMLJobObjectiveMetric> builder(MarshallingType.SDK_POJO)
            .memberName("FinalAutoMLJobObjectiveMetric")
            .getter(getter(AutoMLCandidate::finalAutoMLJobObjectiveMetric))
            .setter(setter(Builder::finalAutoMLJobObjectiveMetric))
            .constructor(FinalAutoMLJobObjectiveMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalAutoMLJobObjectiveMetric")
                    .build()).build();

    private static final SdkField<String> OBJECTIVE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectiveStatus").getter(getter(AutoMLCandidate::objectiveStatusAsString))
            .setter(setter(Builder::objectiveStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatus").build()).build();

    private static final SdkField<List<AutoMLCandidateStep>> CANDIDATE_STEPS_FIELD = SdkField
            .<List<AutoMLCandidateStep>> builder(MarshallingType.LIST)
            .memberName("CandidateSteps")
            .getter(getter(AutoMLCandidate::candidateSteps))
            .setter(setter(Builder::candidateSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLCandidateStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLCandidateStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CANDIDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateStatus").getter(getter(AutoMLCandidate::candidateStatusAsString))
            .setter(setter(Builder::candidateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStatus").build()).build();

    private static final SdkField<List<AutoMLContainerDefinition>> INFERENCE_CONTAINERS_FIELD = SdkField
            .<List<AutoMLContainerDefinition>> builder(MarshallingType.LIST)
            .memberName("InferenceContainers")
            .getter(getter(AutoMLCandidate::inferenceContainers))
            .setter(setter(Builder::inferenceContainers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceContainers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLContainerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLContainerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AutoMLCandidate::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(AutoMLCandidate::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(AutoMLCandidate::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(AutoMLCandidate::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_NAME_FIELD,
            FINAL_AUTO_ML_JOB_OBJECTIVE_METRIC_FIELD, OBJECTIVE_STATUS_FIELD, CANDIDATE_STEPS_FIELD, CANDIDATE_STATUS_FIELD,
            INFERENCE_CONTAINERS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String candidateName;

    private final FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric;

    private final String objectiveStatus;

    private final List<AutoMLCandidateStep> candidateSteps;

    private final String candidateStatus;

    private final List<AutoMLContainerDefinition> inferenceContainers;

    private final Instant creationTime;

    private final Instant endTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private AutoMLCandidate(BuilderImpl builder) {
        this.candidateName = builder.candidateName;
        this.finalAutoMLJobObjectiveMetric = builder.finalAutoMLJobObjectiveMetric;
        this.objectiveStatus = builder.objectiveStatus;
        this.candidateSteps = builder.candidateSteps;
        this.candidateStatus = builder.candidateStatus;
        this.inferenceContainers = builder.inferenceContainers;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The candidate name.
     * </p>
     * 
     * @return The candidate name.
     */
    public String candidateName() {
        return candidateName;
    }

    /**
     * Returns the value of the FinalAutoMLJobObjectiveMetric property for this object.
     * 
     * @return The value of the FinalAutoMLJobObjectiveMetric property for this object.
     */
    public FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric() {
        return finalAutoMLJobObjectiveMetric;
    }

    /**
     * <p>
     * The objective status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectiveStatus}
     * will return {@link ObjectiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectiveStatusAsString}.
     * </p>
     * 
     * @return The objective status.
     * @see ObjectiveStatus
     */
    public ObjectiveStatus objectiveStatus() {
        return ObjectiveStatus.fromValue(objectiveStatus);
    }

    /**
     * <p>
     * The objective status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectiveStatus}
     * will return {@link ObjectiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectiveStatusAsString}.
     * </p>
     * 
     * @return The objective status.
     * @see ObjectiveStatus
     */
    public String objectiveStatusAsString() {
        return objectiveStatus;
    }

    /**
     * Returns true if the CandidateSteps property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCandidateSteps() {
        return candidateSteps != null && !(candidateSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The candidate's steps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCandidateSteps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The candidate's steps.
     */
    public List<AutoMLCandidateStep> candidateSteps() {
        return candidateSteps;
    }

    /**
     * <p>
     * The candidate's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #candidateStatus}
     * will return {@link CandidateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #candidateStatusAsString}.
     * </p>
     * 
     * @return The candidate's status.
     * @see CandidateStatus
     */
    public CandidateStatus candidateStatus() {
        return CandidateStatus.fromValue(candidateStatus);
    }

    /**
     * <p>
     * The candidate's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #candidateStatus}
     * will return {@link CandidateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #candidateStatusAsString}.
     * </p>
     * 
     * @return The candidate's status.
     * @see CandidateStatus
     */
    public String candidateStatusAsString() {
        return candidateStatus;
    }

    /**
     * Returns true if the InferenceContainers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInferenceContainers() {
        return inferenceContainers != null && !(inferenceContainers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inference containers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInferenceContainers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The inference containers.
     */
    public List<AutoMLContainerDefinition> inferenceContainers() {
        return inferenceContainers;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The end time.
     * </p>
     * 
     * @return The end time.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The last modified time.
     * </p>
     * 
     * @return The last modified time.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The failure reason.
     * </p>
     * 
     * @return The failure reason.
     */
    public String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(candidateName());
        hashCode = 31 * hashCode + Objects.hashCode(finalAutoMLJobObjectiveMetric());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCandidateSteps() ? candidateSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(candidateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceContainers() ? inferenceContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLCandidate)) {
            return false;
        }
        AutoMLCandidate other = (AutoMLCandidate) obj;
        return Objects.equals(candidateName(), other.candidateName())
                && Objects.equals(finalAutoMLJobObjectiveMetric(), other.finalAutoMLJobObjectiveMetric())
                && Objects.equals(objectiveStatusAsString(), other.objectiveStatusAsString())
                && hasCandidateSteps() == other.hasCandidateSteps() && Objects.equals(candidateSteps(), other.candidateSteps())
                && Objects.equals(candidateStatusAsString(), other.candidateStatusAsString())
                && hasInferenceContainers() == other.hasInferenceContainers()
                && Objects.equals(inferenceContainers(), other.inferenceContainers())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoMLCandidate").add("CandidateName", candidateName())
                .add("FinalAutoMLJobObjectiveMetric", finalAutoMLJobObjectiveMetric())
                .add("ObjectiveStatus", objectiveStatusAsString())
                .add("CandidateSteps", hasCandidateSteps() ? candidateSteps() : null)
                .add("CandidateStatus", candidateStatusAsString())
                .add("InferenceContainers", hasInferenceContainers() ? inferenceContainers() : null)
                .add("CreationTime", creationTime()).add("EndTime", endTime()).add("LastModifiedTime", lastModifiedTime())
                .add("FailureReason", failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CandidateName":
            return Optional.ofNullable(clazz.cast(candidateName()));
        case "FinalAutoMLJobObjectiveMetric":
            return Optional.ofNullable(clazz.cast(finalAutoMLJobObjectiveMetric()));
        case "ObjectiveStatus":
            return Optional.ofNullable(clazz.cast(objectiveStatusAsString()));
        case "CandidateSteps":
            return Optional.ofNullable(clazz.cast(candidateSteps()));
        case "CandidateStatus":
            return Optional.ofNullable(clazz.cast(candidateStatusAsString()));
        case "InferenceContainers":
            return Optional.ofNullable(clazz.cast(inferenceContainers()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLCandidate, T> g) {
        return obj -> g.apply((AutoMLCandidate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLCandidate> {
        /**
         * <p>
         * The candidate name.
         * </p>
         * 
         * @param candidateName
         *        The candidate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateName(String candidateName);

        /**
         * Sets the value of the FinalAutoMLJobObjectiveMetric property for this object.
         *
         * @param finalAutoMLJobObjectiveMetric
         *        The new value for the FinalAutoMLJobObjectiveMetric property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric);

        /**
         * Sets the value of the FinalAutoMLJobObjectiveMetric property for this object.
         *
         * This is a convenience that creates an instance of the {@link FinalAutoMLJobObjectiveMetric.Builder} avoiding
         * the need to create one manually via {@link FinalAutoMLJobObjectiveMetric#builder()}.
         *
         * When the {@link Consumer} completes, {@link FinalAutoMLJobObjectiveMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric)}
         * .
         * 
         * @param finalAutoMLJobObjectiveMetric
         *        a consumer that will call methods on {@link FinalAutoMLJobObjectiveMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric)
         */
        default Builder finalAutoMLJobObjectiveMetric(
                Consumer<FinalAutoMLJobObjectiveMetric.Builder> finalAutoMLJobObjectiveMetric) {
            return finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric.builder()
                    .applyMutation(finalAutoMLJobObjectiveMetric).build());
        }

        /**
         * <p>
         * The objective status.
         * </p>
         * 
         * @param objectiveStatus
         *        The objective status.
         * @see ObjectiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveStatus
         */
        Builder objectiveStatus(String objectiveStatus);

        /**
         * <p>
         * The objective status.
         * </p>
         * 
         * @param objectiveStatus
         *        The objective status.
         * @see ObjectiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveStatus
         */
        Builder objectiveStatus(ObjectiveStatus objectiveStatus);

        /**
         * <p>
         * The candidate's steps.
         * </p>
         * 
         * @param candidateSteps
         *        The candidate's steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateSteps(Collection<AutoMLCandidateStep> candidateSteps);

        /**
         * <p>
         * The candidate's steps.
         * </p>
         * 
         * @param candidateSteps
         *        The candidate's steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateSteps(AutoMLCandidateStep... candidateSteps);

        /**
         * <p>
         * The candidate's steps.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoMLCandidateStep>.Builder} avoiding the
         * need to create one manually via {@link List<AutoMLCandidateStep>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoMLCandidateStep>.Builder#build()} is called immediately
         * and its result is passed to {@link #candidateSteps(List<AutoMLCandidateStep>)}.
         * 
         * @param candidateSteps
         *        a consumer that will call methods on {@link List<AutoMLCandidateStep>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateSteps(List<AutoMLCandidateStep>)
         */
        Builder candidateSteps(Consumer<AutoMLCandidateStep.Builder>... candidateSteps);

        /**
         * <p>
         * The candidate's status.
         * </p>
         * 
         * @param candidateStatus
         *        The candidate's status.
         * @see CandidateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStatus
         */
        Builder candidateStatus(String candidateStatus);

        /**
         * <p>
         * The candidate's status.
         * </p>
         * 
         * @param candidateStatus
         *        The candidate's status.
         * @see CandidateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStatus
         */
        Builder candidateStatus(CandidateStatus candidateStatus);

        /**
         * <p>
         * The inference containers.
         * </p>
         * 
         * @param inferenceContainers
         *        The inference containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainers(Collection<AutoMLContainerDefinition> inferenceContainers);

        /**
         * <p>
         * The inference containers.
         * </p>
         * 
         * @param inferenceContainers
         *        The inference containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainers(AutoMLContainerDefinition... inferenceContainers);

        /**
         * <p>
         * The inference containers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoMLContainerDefinition>.Builder}
         * avoiding the need to create one manually via {@link List<AutoMLContainerDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoMLContainerDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceContainers(List<AutoMLContainerDefinition>)}.
         * 
         * @param inferenceContainers
         *        a consumer that will call methods on {@link List<AutoMLContainerDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceContainers(List<AutoMLContainerDefinition>)
         */
        Builder inferenceContainers(Consumer<AutoMLContainerDefinition.Builder>... inferenceContainers);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The end time.
         * </p>
         * 
         * @param endTime
         *        The end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The failure reason.
         * </p>
         * 
         * @param failureReason
         *        The failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String candidateName;

        private FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric;

        private String objectiveStatus;

        private List<AutoMLCandidateStep> candidateSteps = DefaultSdkAutoConstructList.getInstance();

        private String candidateStatus;

        private List<AutoMLContainerDefinition> inferenceContainers = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant endTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLCandidate model) {
            candidateName(model.candidateName);
            finalAutoMLJobObjectiveMetric(model.finalAutoMLJobObjectiveMetric);
            objectiveStatus(model.objectiveStatus);
            candidateSteps(model.candidateSteps);
            candidateStatus(model.candidateStatus);
            inferenceContainers(model.inferenceContainers);
            creationTime(model.creationTime);
            endTime(model.endTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
        }

        public final String getCandidateName() {
            return candidateName;
        }

        @Override
        public final Builder candidateName(String candidateName) {
            this.candidateName = candidateName;
            return this;
        }

        public final void setCandidateName(String candidateName) {
            this.candidateName = candidateName;
        }

        public final FinalAutoMLJobObjectiveMetric.Builder getFinalAutoMLJobObjectiveMetric() {
            return finalAutoMLJobObjectiveMetric != null ? finalAutoMLJobObjectiveMetric.toBuilder() : null;
        }

        @Override
        public final Builder finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric) {
            this.finalAutoMLJobObjectiveMetric = finalAutoMLJobObjectiveMetric;
            return this;
        }

        public final void setFinalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric.BuilderImpl finalAutoMLJobObjectiveMetric) {
            this.finalAutoMLJobObjectiveMetric = finalAutoMLJobObjectiveMetric != null ? finalAutoMLJobObjectiveMetric.build()
                    : null;
        }

        public final String getObjectiveStatus() {
            return objectiveStatus;
        }

        @Override
        public final Builder objectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
            return this;
        }

        @Override
        public final Builder objectiveStatus(ObjectiveStatus objectiveStatus) {
            this.objectiveStatus(objectiveStatus == null ? null : objectiveStatus.toString());
            return this;
        }

        public final void setObjectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
        }

        public final Collection<AutoMLCandidateStep.Builder> getCandidateSteps() {
            if (candidateSteps instanceof SdkAutoConstructList) {
                return null;
            }
            return candidateSteps != null ? candidateSteps.stream().map(AutoMLCandidateStep::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder candidateSteps(Collection<AutoMLCandidateStep> candidateSteps) {
            this.candidateSteps = CandidateStepsCopier.copy(candidateSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateSteps(AutoMLCandidateStep... candidateSteps) {
            candidateSteps(Arrays.asList(candidateSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateSteps(Consumer<AutoMLCandidateStep.Builder>... candidateSteps) {
            candidateSteps(Stream.of(candidateSteps).map(c -> AutoMLCandidateStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCandidateSteps(Collection<AutoMLCandidateStep.BuilderImpl> candidateSteps) {
            this.candidateSteps = CandidateStepsCopier.copyFromBuilder(candidateSteps);
        }

        public final String getCandidateStatus() {
            return candidateStatus;
        }

        @Override
        public final Builder candidateStatus(String candidateStatus) {
            this.candidateStatus = candidateStatus;
            return this;
        }

        @Override
        public final Builder candidateStatus(CandidateStatus candidateStatus) {
            this.candidateStatus(candidateStatus == null ? null : candidateStatus.toString());
            return this;
        }

        public final void setCandidateStatus(String candidateStatus) {
            this.candidateStatus = candidateStatus;
        }

        public final Collection<AutoMLContainerDefinition.Builder> getInferenceContainers() {
            if (inferenceContainers instanceof SdkAutoConstructList) {
                return null;
            }
            return inferenceContainers != null ? inferenceContainers.stream().map(AutoMLContainerDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inferenceContainers(Collection<AutoMLContainerDefinition> inferenceContainers) {
            this.inferenceContainers = AutoMLContainerDefinitionsCopier.copy(inferenceContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceContainers(AutoMLContainerDefinition... inferenceContainers) {
            inferenceContainers(Arrays.asList(inferenceContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceContainers(Consumer<AutoMLContainerDefinition.Builder>... inferenceContainers) {
            inferenceContainers(Stream.of(inferenceContainers)
                    .map(c -> AutoMLContainerDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceContainers(Collection<AutoMLContainerDefinition.BuilderImpl> inferenceContainers) {
            this.inferenceContainers = AutoMLContainerDefinitionsCopier.copyFromBuilder(inferenceContainers);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public AutoMLCandidate build() {
            return new AutoMLCandidate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
