/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotebookInstanceLifecycleConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<DescribeNotebookInstanceLifecycleConfigRequest.Builder, DescribeNotebookInstanceLifecycleConfigRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceLifecycleConfigName")
            .getter(getter(DescribeNotebookInstanceLifecycleConfigRequest::notebookInstanceLifecycleConfigName))
            .setter(setter(Builder::notebookInstanceLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NotebookInstanceLifecycleConfigName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD));

    private final String notebookInstanceLifecycleConfigName;

    private DescribeNotebookInstanceLifecycleConfigRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
    }

    /**
     * <p>
     * The name of the lifecycle configuration to describe.
     * </p>
     * 
     * @return The name of the lifecycle configuration to describe.
     */
    public String notebookInstanceLifecycleConfigName() {
        return notebookInstanceLifecycleConfigName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotebookInstanceLifecycleConfigRequest)) {
            return false;
        }
        DescribeNotebookInstanceLifecycleConfigRequest other = (DescribeNotebookInstanceLifecycleConfigRequest) obj;
        return Objects.equals(notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNotebookInstanceLifecycleConfigRequest")
                .add("NotebookInstanceLifecycleConfigName", notebookInstanceLifecycleConfigName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotebookInstanceLifecycleConfigRequest, T> g) {
        return obj -> g.apply((DescribeNotebookInstanceLifecycleConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotebookInstanceLifecycleConfigRequest> {
        /**
         * <p>
         * The name of the lifecycle configuration to describe.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigName
         *        The name of the lifecycle configuration to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String notebookInstanceLifecycleConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotebookInstanceLifecycleConfigRequest model) {
            super(model);
            notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNotebookInstanceLifecycleConfigRequest build() {
            return new DescribeNotebookInstanceLifecycleConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
