/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePipelineResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribePipelineResponse.Builder, DescribePipelineResponse> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(DescribePipelineResponse::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(DescribePipelineResponse::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDisplayName").getter(getter(DescribePipelineResponse::pipelineDisplayName))
            .setter(setter(Builder::pipelineDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build())
            .build();

    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDefinition").getter(getter(DescribePipelineResponse::pipelineDefinition))
            .setter(setter(Builder::pipelineDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build())
            .build();

    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDescription").getter(getter(DescribePipelineResponse::pipelineDescription))
            .setter(setter(Builder::pipelineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribePipelineResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> PIPELINE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineStatus").getter(getter(DescribePipelineResponse::pipelineStatusAsString))
            .setter(setter(Builder::pipelineStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribePipelineResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribePipelineResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> LAST_RUN_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastRunTime").getter(getter(DescribePipelineResponse::lastRunTime)).setter(setter(Builder::lastRunTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribePipelineResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribePipelineResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            PIPELINE_NAME_FIELD, PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DEFINITION_FIELD, PIPELINE_DESCRIPTION_FIELD,
            ROLE_ARN_FIELD, PIPELINE_STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_RUN_TIME_FIELD,
            CREATED_BY_FIELD, LAST_MODIFIED_BY_FIELD));

    private final String pipelineArn;

    private final String pipelineName;

    private final String pipelineDisplayName;

    private final String pipelineDefinition;

    private final String pipelineDescription;

    private final String roleArn;

    private final String pipelineStatus;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Instant lastRunTime;

    private final UserContext createdBy;

    private final UserContext lastModifiedBy;

    private DescribePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDefinition = builder.pipelineDefinition;
        this.pipelineDescription = builder.pipelineDescription;
        this.roleArn = builder.roleArn;
        this.pipelineStatus = builder.pipelineStatus;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastRunTime = builder.lastRunTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The display name of the pipeline.
     * </p>
     * 
     * @return The display name of the pipeline.
     */
    public String pipelineDisplayName() {
        return pipelineDisplayName;
    }

    /**
     * <p>
     * The JSON pipeline definition.
     * </p>
     * 
     * @return The JSON pipeline definition.
     */
    public String pipelineDefinition() {
        return pipelineDefinition;
    }

    /**
     * <p>
     * The description of the pipeline.
     * </p>
     * 
     * @return The description of the pipeline.
     */
    public String pipelineDescription() {
        return pipelineDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that the pipeline uses to execute.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that the pipeline uses to execute.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the pipeline execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineStatus}
     * will return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pipelineStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline execution.
     * @see PipelineStatus
     */
    public PipelineStatus pipelineStatus() {
        return PipelineStatus.fromValue(pipelineStatus);
    }

    /**
     * <p>
     * The status of the pipeline execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineStatus}
     * will return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pipelineStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline execution.
     * @see PipelineStatus
     */
    public String pipelineStatusAsString() {
        return pipelineStatus;
    }

    /**
     * <p>
     * The time when the pipeline was created.
     * </p>
     * 
     * @return The time when the pipeline was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the pipeline was last modified.
     * </p>
     * 
     * @return The time when the pipeline was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The time when the pipeline was last run.
     * </p>
     * 
     * @return The time when the pipeline was last run.
     */
    public Instant lastRunTime() {
        return lastRunTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public UserContext createdBy() {
        return createdBy;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelineResponse)) {
            return false;
        }
        DescribePipelineResponse other = (DescribePipelineResponse) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(pipelineDisplayName(), other.pipelineDisplayName())
                && Objects.equals(pipelineDefinition(), other.pipelineDefinition())
                && Objects.equals(pipelineDescription(), other.pipelineDescription())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(pipelineStatusAsString(), other.pipelineStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastRunTime(), other.lastRunTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePipelineResponse").add("PipelineArn", pipelineArn()).add("PipelineName", pipelineName())
                .add("PipelineDisplayName", pipelineDisplayName()).add("PipelineDefinition", pipelineDefinition())
                .add("PipelineDescription", pipelineDescription()).add("RoleArn", roleArn())
                .add("PipelineStatus", pipelineStatusAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LastRunTime", lastRunTime()).add("CreatedBy", createdBy())
                .add("LastModifiedBy", lastModifiedBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "PipelineDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineDisplayName()));
        case "PipelineDefinition":
            return Optional.ofNullable(clazz.cast(pipelineDefinition()));
        case "PipelineDescription":
            return Optional.ofNullable(clazz.cast(pipelineDescription()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "PipelineStatus":
            return Optional.ofNullable(clazz.cast(pipelineStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastRunTime":
            return Optional.ofNullable(clazz.cast(lastRunTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePipelineResponse, T> g) {
        return obj -> g.apply((DescribePipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePipelineResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The display name of the pipeline.
         * </p>
         * 
         * @param pipelineDisplayName
         *        The display name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDisplayName(String pipelineDisplayName);

        /**
         * <p>
         * The JSON pipeline definition.
         * </p>
         * 
         * @param pipelineDefinition
         *        The JSON pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDefinition(String pipelineDefinition);

        /**
         * <p>
         * The description of the pipeline.
         * </p>
         * 
         * @param pipelineDescription
         *        The description of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDescription(String pipelineDescription);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that the pipeline uses to execute.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) that the pipeline uses to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the pipeline execution.
         * </p>
         * 
         * @param pipelineStatus
         *        The status of the pipeline execution.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder pipelineStatus(String pipelineStatus);

        /**
         * <p>
         * The status of the pipeline execution.
         * </p>
         * 
         * @param pipelineStatus
         *        The status of the pipeline execution.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder pipelineStatus(PipelineStatus pipelineStatus);

        /**
         * <p>
         * The time when the pipeline was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the pipeline was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the pipeline was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The time when the pipeline was last run.
         * </p>
         * 
         * @param lastRunTime
         *        The time when the pipeline was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunTime(Instant lastRunTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String pipelineArn;

        private String pipelineName;

        private String pipelineDisplayName;

        private String pipelineDefinition;

        private String pipelineDescription;

        private String roleArn;

        private String pipelineStatus;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Instant lastRunTime;

        private UserContext createdBy;

        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelineResponse model) {
            super(model);
            pipelineArn(model.pipelineArn);
            pipelineName(model.pipelineName);
            pipelineDisplayName(model.pipelineDisplayName);
            pipelineDefinition(model.pipelineDefinition);
            pipelineDescription(model.pipelineDescription);
            roleArn(model.roleArn);
            pipelineStatus(model.pipelineStatus);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            lastRunTime(model.lastRunTime);
            createdBy(model.createdBy);
            lastModifiedBy(model.lastModifiedBy);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getPipelineDisplayName() {
            return pipelineDisplayName;
        }

        @Override
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        public final String getPipelineDefinition() {
            return pipelineDefinition;
        }

        @Override
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        public final String getPipelineDescription() {
            return pipelineDescription;
        }

        @Override
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getPipelineStatus() {
            return pipelineStatus;
        }

        @Override
        public final Builder pipelineStatus(String pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
            return this;
        }

        @Override
        public final Builder pipelineStatus(PipelineStatus pipelineStatus) {
            this.pipelineStatus(pipelineStatus == null ? null : pipelineStatus.toString());
            return this;
        }

        public final void setPipelineStatus(String pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Instant getLastRunTime() {
            return lastRunTime;
        }

        @Override
        public final Builder lastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
            return this;
        }

        public final void setLastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public DescribePipelineResponse build() {
            return new DescribePipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
