/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAutoMlJobsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListAutoMlJobsRequest.Builder, ListAutoMlJobsRequest> {
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListAutoMlJobsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListAutoMlJobsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeAfter").getter(getter(ListAutoMlJobsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeBefore").getter(getter(ListAutoMlJobsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListAutoMlJobsRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListAutoMlJobsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListAutoMlJobsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListAutoMlJobsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAutoMlJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAutoMlJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_AFTER_FIELD,
            CREATION_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, NAME_CONTAINS_FIELD,
            STATUS_EQUALS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final String nameContains;

    private final String statusEquals;

    private final String sortOrder;

    private final String sortBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListAutoMlJobsRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.nameContains = builder.nameContains;
        this.statusEquals = builder.statusEquals;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Request a list of jobs, using a filter for time.
     * </p>
     * 
     * @return Request a list of jobs, using a filter for time.
     */
    public Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Request a list of jobs, using a filter for time.
     * </p>
     * 
     * @return Request a list of jobs, using a filter for time.
     */
    public Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Request a list of jobs, using a filter for time.
     * </p>
     * 
     * @return Request a list of jobs, using a filter for time.
     */
    public Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * Request a list of jobs, using a filter for time.
     * </p>
     * 
     * @return Request a list of jobs, using a filter for time.
     */
    public Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * Request a list of jobs, using a search filter for name.
     * </p>
     * 
     * @return Request a list of jobs, using a search filter for name.
     */
    public String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Request a list of jobs, using a filter for status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Request a list of jobs, using a filter for status.
     * @see AutoMLJobStatus
     */
    public AutoMLJobStatus statusEquals() {
        return AutoMLJobStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * Request a list of jobs, using a filter for status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Request a list of jobs, using a filter for status.
     * @see AutoMLJobStatus
     */
    public String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * The sort order for the results. The default is Descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link AutoMLSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the results. The default is Descending.
     * @see AutoMLSortOrder
     */
    public AutoMLSortOrder sortOrder() {
        return AutoMLSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for the results. The default is Descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link AutoMLSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the results. The default is Descending.
     * @see AutoMLSortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The parameter by which to sort the results. The default is AutoMLJobName.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AutoMLSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The parameter by which to sort the results. The default is AutoMLJobName.
     * @see AutoMLSortBy
     */
    public AutoMLSortBy sortBy() {
        return AutoMLSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The parameter by which to sort the results. The default is AutoMLJobName.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AutoMLSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The parameter by which to sort the results. The default is AutoMLJobName.
     * @see AutoMLSortBy
     */
    public String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Request a list of jobs up to a specified limit.
     * </p>
     * 
     * @return Request a list of jobs up to a specified limit.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutoMlJobsRequest)) {
            return false;
        }
        ListAutoMlJobsRequest other = (ListAutoMlJobsRequest) obj;
        return Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAutoMlJobsRequest").add("CreationTimeAfter", creationTimeAfter())
                .add("CreationTimeBefore", creationTimeBefore()).add("LastModifiedTimeAfter", lastModifiedTimeAfter())
                .add("LastModifiedTimeBefore", lastModifiedTimeBefore()).add("NameContains", nameContains())
                .add("StatusEquals", statusEqualsAsString()).add("SortOrder", sortOrderAsString())
                .add("SortBy", sortByAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAutoMlJobsRequest, T> g) {
        return obj -> g.apply((ListAutoMlJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAutoMlJobsRequest> {
        /**
         * <p>
         * Request a list of jobs, using a filter for time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Request a list of jobs, using a filter for time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Request a list of jobs, using a filter for time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Request a list of jobs, using a filter for time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Request a list of jobs, using a filter for time.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        Request a list of jobs, using a filter for time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * Request a list of jobs, using a filter for time.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        Request a list of jobs, using a filter for time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * Request a list of jobs, using a search filter for name.
         * </p>
         * 
         * @param nameContains
         *        Request a list of jobs, using a search filter for name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Request a list of jobs, using a filter for status.
         * </p>
         * 
         * @param statusEquals
         *        Request a list of jobs, using a filter for status.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * Request a list of jobs, using a filter for status.
         * </p>
         * 
         * @param statusEquals
         *        Request a list of jobs, using a filter for status.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder statusEquals(AutoMLJobStatus statusEquals);

        /**
         * <p>
         * The sort order for the results. The default is Descending.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the results. The default is Descending.
         * @see AutoMLSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for the results. The default is Descending.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the results. The default is Descending.
         * @see AutoMLSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLSortOrder
         */
        Builder sortOrder(AutoMLSortOrder sortOrder);

        /**
         * <p>
         * The parameter by which to sort the results. The default is AutoMLJobName.
         * </p>
         * 
         * @param sortBy
         *        The parameter by which to sort the results. The default is AutoMLJobName.
         * @see AutoMLSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The parameter by which to sort the results. The default is AutoMLJobName.
         * </p>
         * 
         * @param sortBy
         *        The parameter by which to sort the results. The default is AutoMLJobName.
         * @see AutoMLSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLSortBy
         */
        Builder sortBy(AutoMLSortBy sortBy);

        /**
         * <p>
         * Request a list of jobs up to a specified limit.
         * </p>
         * 
         * @param maxResults
         *        Request a list of jobs up to a specified limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous response was truncated, you receive this token. Use it in your next request to receive the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you receive this token. Use it in your next request to receive
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Instant lastModifiedTimeAfter;

        private Instant lastModifiedTimeBefore;

        private String nameContains;

        private String statusEquals;

        private String sortOrder;

        private String sortBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutoMlJobsRequest model) {
            super(model);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            nameContains(model.nameContains);
            statusEquals(model.statusEquals);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(AutoMLJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(AutoMLSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(AutoMLSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAutoMlJobsRequest build() {
            return new ListAutoMlJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
