/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the location that is configured for storing model artifacts.
 * </p>
 * <p>
 * Model artifacts are the output that results from training a model, and typically consist of trained parameters, a
 * model defintion that desribes how to compute inferences, and other metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelArtifacts implements SdkPojo, Serializable, ToCopyableBuilder<ModelArtifacts.Builder, ModelArtifacts> {
    private static final SdkField<String> S3_MODEL_ARTIFACTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ModelArtifacts").getter(getter(ModelArtifacts::s3ModelArtifacts))
            .setter(setter(Builder::s3ModelArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ModelArtifacts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_MODEL_ARTIFACTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3ModelArtifacts;

    private ModelArtifacts(BuilderImpl builder) {
        this.s3ModelArtifacts = builder.s3ModelArtifacts;
    }

    /**
     * <p>
     * The path of the S3 object that contains the model artifacts. For example,
     * <code>s3://bucket-name/keynameprefix/model.tar.gz</code>.
     * </p>
     * 
     * @return The path of the S3 object that contains the model artifacts. For example,
     *         <code>s3://bucket-name/keynameprefix/model.tar.gz</code>.
     */
    public String s3ModelArtifacts() {
        return s3ModelArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ModelArtifacts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelArtifacts)) {
            return false;
        }
        ModelArtifacts other = (ModelArtifacts) obj;
        return Objects.equals(s3ModelArtifacts(), other.s3ModelArtifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelArtifacts").add("S3ModelArtifacts", s3ModelArtifacts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ModelArtifacts":
            return Optional.ofNullable(clazz.cast(s3ModelArtifacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelArtifacts, T> g) {
        return obj -> g.apply((ModelArtifacts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelArtifacts> {
        /**
         * <p>
         * The path of the S3 object that contains the model artifacts. For example,
         * <code>s3://bucket-name/keynameprefix/model.tar.gz</code>.
         * </p>
         * 
         * @param s3ModelArtifacts
         *        The path of the S3 object that contains the model artifacts. For example,
         *        <code>s3://bucket-name/keynameprefix/model.tar.gz</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ModelArtifacts(String s3ModelArtifacts);
    }

    static final class BuilderImpl implements Builder {
        private String s3ModelArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelArtifacts model) {
            s3ModelArtifacts(model.s3ModelArtifacts);
        }

        public final String getS3ModelArtifacts() {
            return s3ModelArtifacts;
        }

        @Override
        public final Builder s3ModelArtifacts(String s3ModelArtifacts) {
            this.s3ModelArtifacts = s3ModelArtifacts;
            return this;
        }

        public final void setS3ModelArtifacts(String s3ModelArtifacts) {
            this.s3ModelArtifacts = s3ModelArtifacts;
        }

        @Override
        public ModelArtifacts build() {
            return new ModelArtifacts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
