/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information to verify the integrity of stored model artifacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDigests implements SdkPojo, Serializable, ToCopyableBuilder<ModelDigests.Builder, ModelDigests> {
    private static final SdkField<String> ARTIFACT_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactDigest").getter(getter(ModelDigests::artifactDigest)).setter(setter(Builder::artifactDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactDigest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_DIGEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String artifactDigest;

    private ModelDigests(BuilderImpl builder) {
        this.artifactDigest = builder.artifactDigest;
    }

    /**
     * <p>
     * Provides a hash value that uniquely identifies the stored model artifacts.
     * </p>
     * 
     * @return Provides a hash value that uniquely identifies the stored model artifacts.
     */
    public String artifactDigest() {
        return artifactDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifactDigest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDigests)) {
            return false;
        }
        ModelDigests other = (ModelDigests) obj;
        return Objects.equals(artifactDigest(), other.artifactDigest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelDigests").add("ArtifactDigest", artifactDigest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactDigest":
            return Optional.ofNullable(clazz.cast(artifactDigest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDigests, T> g) {
        return obj -> g.apply((ModelDigests) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDigests> {
        /**
         * <p>
         * Provides a hash value that uniquely identifies the stored model artifacts.
         * </p>
         * 
         * @param artifactDigest
         *        Provides a hash value that uniquely identifies the stored model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactDigest(String artifactDigest);
    }

    static final class BuilderImpl implements Builder {
        private String artifactDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDigests model) {
            artifactDigest(model.artifactDigest);
        }

        public final String getArtifactDigest() {
            return artifactDigest;
        }

        @Override
        public final Builder artifactDigest(String artifactDigest) {
            this.artifactDigest = artifactDigest;
            return this;
        }

        public final void setArtifactDigest(String artifactDigest) {
            this.artifactDigest = artifactDigest;
        }

        @Override
        public ModelDigests build() {
            return new ModelDigests(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
