/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkteamResponse extends SageMakerResponse implements
        ToCopyableBuilder<UpdateWorkteamResponse.Builder, UpdateWorkteamResponse> {
    private static final SdkField<Workteam> WORKTEAM_FIELD = SdkField.<Workteam> builder(MarshallingType.SDK_POJO)
            .memberName("Workteam").getter(getter(UpdateWorkteamResponse::workteam)).setter(setter(Builder::workteam))
            .constructor(Workteam::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workteam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_FIELD));

    private final Workteam workteam;

    private UpdateWorkteamResponse(BuilderImpl builder) {
        super(builder);
        this.workteam = builder.workteam;
    }

    /**
     * <p>
     * A <code>Workteam</code> object that describes the updated work team.
     * </p>
     * 
     * @return A <code>Workteam</code> object that describes the updated work team.
     */
    public Workteam workteam() {
        return workteam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workteam());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkteamResponse)) {
            return false;
        }
        UpdateWorkteamResponse other = (UpdateWorkteamResponse) obj;
        return Objects.equals(workteam(), other.workteam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateWorkteamResponse").add("Workteam", workteam()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workteam":
            return Optional.ofNullable(clazz.cast(workteam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkteamResponse, T> g) {
        return obj -> g.apply((UpdateWorkteamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkteamResponse> {
        /**
         * <p>
         * A <code>Workteam</code> object that describes the updated work team.
         * </p>
         * 
         * @param workteam
         *        A <code>Workteam</code> object that describes the updated work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteam(Workteam workteam);

        /**
         * <p>
         * A <code>Workteam</code> object that describes the updated work team.
         * </p>
         * This is a convenience that creates an instance of the {@link Workteam.Builder} avoiding the need to create
         * one manually via {@link Workteam#builder()}.
         *
         * When the {@link Consumer} completes, {@link Workteam.Builder#build()} is called immediately and its result is
         * passed to {@link #workteam(Workteam)}.
         * 
         * @param workteam
         *        a consumer that will call methods on {@link Workteam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workteam(Workteam)
         */
        default Builder workteam(Consumer<Workteam.Builder> workteam) {
            return workteam(Workteam.builder().applyMutation(workteam).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private Workteam workteam;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkteamResponse model) {
            super(model);
            workteam(model.workteam);
        }

        public final Workteam.Builder getWorkteam() {
            return workteam != null ? workteam.toBuilder() : null;
        }

        @Override
        public final Builder workteam(Workteam workteam) {
            this.workteam = workteam;
            return this;
        }

        public final void setWorkteam(Workteam.BuilderImpl workteam) {
            this.workteam = workteam != null ? workteam.build() : null;
        }

        @Override
        public UpdateWorkteamResponse build() {
            return new UpdateWorkteamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
