/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data source for the Autopilot job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLDataSource.Builder, AutoMLDataSource> {
    private static final SdkField<AutoMLS3DataSource> S3_DATA_SOURCE_FIELD = SdkField
            .<AutoMLS3DataSource> builder(MarshallingType.SDK_POJO).memberName("S3DataSource")
            .getter(getter(AutoMLDataSource::s3DataSource)).setter(setter(Builder::s3DataSource))
            .constructor(AutoMLS3DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLS3DataSource s3DataSource;

    private AutoMLDataSource(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
    }

    /**
     * <p>
     * The Amazon S3 location of the input data.
     * </p>
     * <note>
     * <p>
     * The input data must be in CSV format and contain at least 500 rows.
     * </p>
     * </note>
     * 
     * @return The Amazon S3 location of the input data.</p> <note>
     *         <p>
     *         The input data must be in CSV format and contain at least 500 rows.
     *         </p>
     */
    public AutoMLS3DataSource s3DataSource() {
        return s3DataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLDataSource)) {
            return false;
        }
        AutoMLDataSource other = (AutoMLDataSource) obj;
        return Objects.equals(s3DataSource(), other.s3DataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoMLDataSource").add("S3DataSource", s3DataSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3DataSource":
            return Optional.ofNullable(clazz.cast(s3DataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLDataSource, T> g) {
        return obj -> g.apply((AutoMLDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLDataSource> {
        /**
         * <p>
         * The Amazon S3 location of the input data.
         * </p>
         * <note>
         * <p>
         * The input data must be in CSV format and contain at least 500 rows.
         * </p>
         * </note>
         * 
         * @param s3DataSource
         *        The Amazon S3 location of the input data.</p> <note>
         *        <p>
         *        The input data must be in CSV format and contain at least 500 rows.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSource(AutoMLS3DataSource s3DataSource);

        /**
         * <p>
         * The Amazon S3 location of the input data.
         * </p>
         * <note>
         * <p>
         * The input data must be in CSV format and contain at least 500 rows.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link AutoMLS3DataSource.Builder} avoiding the
         * need to create one manually via {@link AutoMLS3DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLS3DataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataSource(AutoMLS3DataSource)}.
         * 
         * @param s3DataSource
         *        a consumer that will call methods on {@link AutoMLS3DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataSource(AutoMLS3DataSource)
         */
        default Builder s3DataSource(Consumer<AutoMLS3DataSource.Builder> s3DataSource) {
            return s3DataSource(AutoMLS3DataSource.builder().applyMutation(s3DataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoMLS3DataSource s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLDataSource model) {
            s3DataSource(model.s3DataSource);
        }

        public final AutoMLS3DataSource.Builder getS3DataSource() {
            return s3DataSource != null ? s3DataSource.toBuilder() : null;
        }

        @Override
        public final Builder s3DataSource(AutoMLS3DataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        public final void setS3DataSource(AutoMLS3DataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public AutoMLDataSource build() {
            return new AutoMLDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
