/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(CreateAppRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(CreateAppRequest::userProfileName))
            .setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppType").getter(getter(CreateAppRequest::appTypeAsString)).setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()).build();

    private static final SdkField<String> APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppName").getter(getter(CreateAppRequest::appName)).setter(setter(Builder::appName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourceSpec> RESOURCE_SPEC_FIELD = SdkField.<ResourceSpec> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceSpec").getter(getter(CreateAppRequest::resourceSpec)).setter(setter(Builder::resourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_NAME_FIELD, APP_TYPE_FIELD, APP_NAME_FIELD, TAGS_FIELD, RESOURCE_SPEC_FIELD));

    private final String domainId;

    private final String userProfileName;

    private final String appType;

    private final String appName;

    private final List<Tag> tags;

    private final ResourceSpec resourceSpec;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.appType = builder.appType;
        this.appName = builder.appName;
        this.tags = builder.tags;
        this.resourceSpec = builder.resourceSpec;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The user profile name.
     * </p>
     * 
     * @return The user profile name.
     */
    public String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public String appName() {
        return appName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     * </p>
     * 
     * @return The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     */
    public ResourceSpec resourceSpec() {
        return resourceSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(appName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpec());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(appTypeAsString(), other.appTypeAsString()) && Objects.equals(appName(), other.appName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(resourceSpec(), other.resourceSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAppRequest").add("DomainId", domainId()).add("UserProfileName", userProfileName())
                .add("AppType", appTypeAsString()).add("AppName", appName()).add("Tags", hasTags() ? tags() : null)
                .add("ResourceSpec", resourceSpec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "AppType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "AppName":
            return Optional.ofNullable(clazz.cast(appName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ResourceSpec":
            return Optional.ofNullable(clazz.cast(resourceSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The user profile name.
         * </p>
         * 
         * @param userProfileName
         *        The user profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param appName
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appName(String appName);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * </p>
         * 
         * @param resourceSpec
         *        The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpec(ResourceSpec resourceSpec);

        /**
         * <p>
         * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceSpec.Builder} avoiding the need to
         * create one manually via {@link ResourceSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceSpec(ResourceSpec)}.
         * 
         * @param resourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpec(ResourceSpec)
         */
        default Builder resourceSpec(Consumer<ResourceSpec.Builder> resourceSpec) {
            return resourceSpec(ResourceSpec.builder().applyMutation(resourceSpec).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private String userProfileName;

        private String appType;

        private String appName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ResourceSpec resourceSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            appType(model.appType);
            appName(model.appName);
            tags(model.tags);
            resourceSpec(model.resourceSpec);
        }

        public final String getDomainId() {
            return domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final String getAppType() {
            return appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        public final String getAppName() {
            return appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final ResourceSpec.Builder getResourceSpec() {
            return resourceSpec != null ? resourceSpec.toBuilder() : null;
        }

        @Override
        public final Builder resourceSpec(ResourceSpec resourceSpec) {
            this.resourceSpec = resourceSpec;
            return this;
        }

        public final void setResourceSpec(ResourceSpec.BuilderImpl resourceSpec) {
            this.resourceSpec = resourceSpec != null ? resourceSpec.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
