/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Currently, the <code>DeploymentConfig</code> API is not supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentConfig.Builder, DeploymentConfig> {
    private static final SdkField<BlueGreenUpdatePolicy> BLUE_GREEN_UPDATE_POLICY_FIELD = SdkField
            .<BlueGreenUpdatePolicy> builder(MarshallingType.SDK_POJO).memberName("BlueGreenUpdatePolicy")
            .getter(getter(DeploymentConfig::blueGreenUpdatePolicy)).setter(setter(Builder::blueGreenUpdatePolicy))
            .constructor(BlueGreenUpdatePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenUpdatePolicy").build())
            .build();

    private static final SdkField<AutoRollbackConfig> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfig> builder(MarshallingType.SDK_POJO).memberName("AutoRollbackConfiguration")
            .getter(getter(DeploymentConfig::autoRollbackConfiguration)).setter(setter(Builder::autoRollbackConfiguration))
            .constructor(AutoRollbackConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollbackConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLUE_GREEN_UPDATE_POLICY_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final BlueGreenUpdatePolicy blueGreenUpdatePolicy;

    private final AutoRollbackConfig autoRollbackConfiguration;

    private DeploymentConfig(BuilderImpl builder) {
        this.blueGreenUpdatePolicy = builder.blueGreenUpdatePolicy;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public BlueGreenUpdatePolicy blueGreenUpdatePolicy() {
        return blueGreenUpdatePolicy;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public AutoRollbackConfig autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfig)) {
            return false;
        }
        DeploymentConfig other = (DeploymentConfig) obj;
        return Objects.equals(blueGreenUpdatePolicy(), other.blueGreenUpdatePolicy())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentConfig").add("BlueGreenUpdatePolicy", blueGreenUpdatePolicy())
                .add("AutoRollbackConfiguration", autoRollbackConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueGreenUpdatePolicy":
            return Optional.ofNullable(clazz.cast(blueGreenUpdatePolicy()));
        case "AutoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfig, T> g) {
        return obj -> g.apply((DeploymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentConfig> {
        /**
         * <p/>
         * 
         * @param blueGreenUpdatePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenUpdatePolicy(BlueGreenUpdatePolicy blueGreenUpdatePolicy);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link BlueGreenUpdatePolicy.Builder} avoiding the need
         * to create one manually via {@link BlueGreenUpdatePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlueGreenUpdatePolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #blueGreenUpdatePolicy(BlueGreenUpdatePolicy)}.
         * 
         * @param blueGreenUpdatePolicy
         *        a consumer that will call methods on {@link BlueGreenUpdatePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenUpdatePolicy(BlueGreenUpdatePolicy)
         */
        default Builder blueGreenUpdatePolicy(Consumer<BlueGreenUpdatePolicy.Builder> blueGreenUpdatePolicy) {
            return blueGreenUpdatePolicy(BlueGreenUpdatePolicy.builder().applyMutation(blueGreenUpdatePolicy).build());
        }

        /**
         * <p/>
         * 
         * @param autoRollbackConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link AutoRollbackConfig.Builder} avoiding the need to
         * create one manually via {@link AutoRollbackConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoRollbackConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfig)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfig)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfig.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfig.builder().applyMutation(autoRollbackConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlueGreenUpdatePolicy blueGreenUpdatePolicy;

        private AutoRollbackConfig autoRollbackConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfig model) {
            blueGreenUpdatePolicy(model.blueGreenUpdatePolicy);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
        }

        public final BlueGreenUpdatePolicy.Builder getBlueGreenUpdatePolicy() {
            return blueGreenUpdatePolicy != null ? blueGreenUpdatePolicy.toBuilder() : null;
        }

        @Override
        public final Builder blueGreenUpdatePolicy(BlueGreenUpdatePolicy blueGreenUpdatePolicy) {
            this.blueGreenUpdatePolicy = blueGreenUpdatePolicy;
            return this;
        }

        public final void setBlueGreenUpdatePolicy(BlueGreenUpdatePolicy.BuilderImpl blueGreenUpdatePolicy) {
            this.blueGreenUpdatePolicy = blueGreenUpdatePolicy != null ? blueGreenUpdatePolicy.build() : null;
        }

        public final AutoRollbackConfig.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfig.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public DeploymentConfig build() {
            return new DeploymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
