/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the possible values for categorical, continuous, and integer hyperparameters to be used by an algorithm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterRange implements SdkPojo, Serializable, ToCopyableBuilder<ParameterRange.Builder, ParameterRange> {
    private static final SdkField<IntegerParameterRangeSpecification> INTEGER_PARAMETER_RANGE_SPECIFICATION_FIELD = SdkField
            .<IntegerParameterRangeSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("IntegerParameterRangeSpecification")
            .getter(getter(ParameterRange::integerParameterRangeSpecification))
            .setter(setter(Builder::integerParameterRangeSpecification))
            .constructor(IntegerParameterRangeSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameterRangeSpecification")
                    .build()).build();

    private static final SdkField<ContinuousParameterRangeSpecification> CONTINUOUS_PARAMETER_RANGE_SPECIFICATION_FIELD = SdkField
            .<ContinuousParameterRangeSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("ContinuousParameterRangeSpecification")
            .getter(getter(ParameterRange::continuousParameterRangeSpecification))
            .setter(setter(Builder::continuousParameterRangeSpecification))
            .constructor(ContinuousParameterRangeSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ContinuousParameterRangeSpecification").build()).build();

    private static final SdkField<CategoricalParameterRangeSpecification> CATEGORICAL_PARAMETER_RANGE_SPECIFICATION_FIELD = SdkField
            .<CategoricalParameterRangeSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CategoricalParameterRangeSpecification")
            .getter(getter(ParameterRange::categoricalParameterRangeSpecification))
            .setter(setter(Builder::categoricalParameterRangeSpecification))
            .constructor(CategoricalParameterRangeSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CategoricalParameterRangeSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGER_PARAMETER_RANGE_SPECIFICATION_FIELD, CONTINUOUS_PARAMETER_RANGE_SPECIFICATION_FIELD,
            CATEGORICAL_PARAMETER_RANGE_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final IntegerParameterRangeSpecification integerParameterRangeSpecification;

    private final ContinuousParameterRangeSpecification continuousParameterRangeSpecification;

    private final CategoricalParameterRangeSpecification categoricalParameterRangeSpecification;

    private ParameterRange(BuilderImpl builder) {
        this.integerParameterRangeSpecification = builder.integerParameterRangeSpecification;
        this.continuousParameterRangeSpecification = builder.continuousParameterRangeSpecification;
        this.categoricalParameterRangeSpecification = builder.categoricalParameterRangeSpecification;
    }

    /**
     * <p>
     * A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer
     * hyperparameter.
     * </p>
     * 
     * @return A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer
     *         hyperparameter.
     */
    public IntegerParameterRangeSpecification integerParameterRangeSpecification() {
        return integerParameterRangeSpecification;
    }

    /**
     * <p>
     * A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a continuous
     * hyperparameter.
     * </p>
     * 
     * @return A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a
     *         continuous hyperparameter.
     */
    public ContinuousParameterRangeSpecification continuousParameterRangeSpecification() {
        return continuousParameterRangeSpecification;
    }

    /**
     * <p>
     * A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a categorical
     * hyperparameter.
     * </p>
     * 
     * @return A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a
     *         categorical hyperparameter.
     */
    public CategoricalParameterRangeSpecification categoricalParameterRangeSpecification() {
        return categoricalParameterRangeSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integerParameterRangeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(continuousParameterRangeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(categoricalParameterRangeSpecification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterRange)) {
            return false;
        }
        ParameterRange other = (ParameterRange) obj;
        return Objects.equals(integerParameterRangeSpecification(), other.integerParameterRangeSpecification())
                && Objects.equals(continuousParameterRangeSpecification(), other.continuousParameterRangeSpecification())
                && Objects.equals(categoricalParameterRangeSpecification(), other.categoricalParameterRangeSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterRange").add("IntegerParameterRangeSpecification", integerParameterRangeSpecification())
                .add("ContinuousParameterRangeSpecification", continuousParameterRangeSpecification())
                .add("CategoricalParameterRangeSpecification", categoricalParameterRangeSpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegerParameterRangeSpecification":
            return Optional.ofNullable(clazz.cast(integerParameterRangeSpecification()));
        case "ContinuousParameterRangeSpecification":
            return Optional.ofNullable(clazz.cast(continuousParameterRangeSpecification()));
        case "CategoricalParameterRangeSpecification":
            return Optional.ofNullable(clazz.cast(categoricalParameterRangeSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterRange, T> g) {
        return obj -> g.apply((ParameterRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterRange> {
        /**
         * <p>
         * A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer
         * hyperparameter.
         * </p>
         * 
         * @param integerParameterRangeSpecification
         *        A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an
         *        integer hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameterRangeSpecification(IntegerParameterRangeSpecification integerParameterRangeSpecification);

        /**
         * <p>
         * A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer
         * hyperparameter.
         * </p>
         * This is a convenience that creates an instance of the {@link IntegerParameterRangeSpecification.Builder}
         * avoiding the need to create one manually via {@link IntegerParameterRangeSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link IntegerParameterRangeSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #integerParameterRangeSpecification(IntegerParameterRangeSpecification)}.
         * 
         * @param integerParameterRangeSpecification
         *        a consumer that will call methods on {@link IntegerParameterRangeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerParameterRangeSpecification(IntegerParameterRangeSpecification)
         */
        default Builder integerParameterRangeSpecification(
                Consumer<IntegerParameterRangeSpecification.Builder> integerParameterRangeSpecification) {
            return integerParameterRangeSpecification(IntegerParameterRangeSpecification.builder()
                    .applyMutation(integerParameterRangeSpecification).build());
        }

        /**
         * <p>
         * A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a continuous
         * hyperparameter.
         * </p>
         * 
         * @param continuousParameterRangeSpecification
         *        A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a
         *        continuous hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousParameterRangeSpecification(ContinuousParameterRangeSpecification continuousParameterRangeSpecification);

        /**
         * <p>
         * A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a continuous
         * hyperparameter.
         * </p>
         * This is a convenience that creates an instance of the {@link ContinuousParameterRangeSpecification.Builder}
         * avoiding the need to create one manually via {@link ContinuousParameterRangeSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContinuousParameterRangeSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #continuousParameterRangeSpecification(ContinuousParameterRangeSpecification)}.
         * 
         * @param continuousParameterRangeSpecification
         *        a consumer that will call methods on {@link ContinuousParameterRangeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousParameterRangeSpecification(ContinuousParameterRangeSpecification)
         */
        default Builder continuousParameterRangeSpecification(
                Consumer<ContinuousParameterRangeSpecification.Builder> continuousParameterRangeSpecification) {
            return continuousParameterRangeSpecification(ContinuousParameterRangeSpecification.builder()
                    .applyMutation(continuousParameterRangeSpecification).build());
        }

        /**
         * <p>
         * A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a
         * categorical hyperparameter.
         * </p>
         * 
         * @param categoricalParameterRangeSpecification
         *        A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a
         *        categorical hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalParameterRangeSpecification(
                CategoricalParameterRangeSpecification categoricalParameterRangeSpecification);

        /**
         * <p>
         * A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a
         * categorical hyperparameter.
         * </p>
         * This is a convenience that creates an instance of the {@link CategoricalParameterRangeSpecification.Builder}
         * avoiding the need to create one manually via {@link CategoricalParameterRangeSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CategoricalParameterRangeSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #categoricalParameterRangeSpecification(CategoricalParameterRangeSpecification)}.
         * 
         * @param categoricalParameterRangeSpecification
         *        a consumer that will call methods on {@link CategoricalParameterRangeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalParameterRangeSpecification(CategoricalParameterRangeSpecification)
         */
        default Builder categoricalParameterRangeSpecification(
                Consumer<CategoricalParameterRangeSpecification.Builder> categoricalParameterRangeSpecification) {
            return categoricalParameterRangeSpecification(CategoricalParameterRangeSpecification.builder()
                    .applyMutation(categoricalParameterRangeSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IntegerParameterRangeSpecification integerParameterRangeSpecification;

        private ContinuousParameterRangeSpecification continuousParameterRangeSpecification;

        private CategoricalParameterRangeSpecification categoricalParameterRangeSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterRange model) {
            integerParameterRangeSpecification(model.integerParameterRangeSpecification);
            continuousParameterRangeSpecification(model.continuousParameterRangeSpecification);
            categoricalParameterRangeSpecification(model.categoricalParameterRangeSpecification);
        }

        public final IntegerParameterRangeSpecification.Builder getIntegerParameterRangeSpecification() {
            return integerParameterRangeSpecification != null ? integerParameterRangeSpecification.toBuilder() : null;
        }

        @Override
        public final Builder integerParameterRangeSpecification(
                IntegerParameterRangeSpecification integerParameterRangeSpecification) {
            this.integerParameterRangeSpecification = integerParameterRangeSpecification;
            return this;
        }

        public final void setIntegerParameterRangeSpecification(
                IntegerParameterRangeSpecification.BuilderImpl integerParameterRangeSpecification) {
            this.integerParameterRangeSpecification = integerParameterRangeSpecification != null ? integerParameterRangeSpecification
                    .build() : null;
        }

        public final ContinuousParameterRangeSpecification.Builder getContinuousParameterRangeSpecification() {
            return continuousParameterRangeSpecification != null ? continuousParameterRangeSpecification.toBuilder() : null;
        }

        @Override
        public final Builder continuousParameterRangeSpecification(
                ContinuousParameterRangeSpecification continuousParameterRangeSpecification) {
            this.continuousParameterRangeSpecification = continuousParameterRangeSpecification;
            return this;
        }

        public final void setContinuousParameterRangeSpecification(
                ContinuousParameterRangeSpecification.BuilderImpl continuousParameterRangeSpecification) {
            this.continuousParameterRangeSpecification = continuousParameterRangeSpecification != null ? continuousParameterRangeSpecification
                    .build() : null;
        }

        public final CategoricalParameterRangeSpecification.Builder getCategoricalParameterRangeSpecification() {
            return categoricalParameterRangeSpecification != null ? categoricalParameterRangeSpecification.toBuilder() : null;
        }

        @Override
        public final Builder categoricalParameterRangeSpecification(
                CategoricalParameterRangeSpecification categoricalParameterRangeSpecification) {
            this.categoricalParameterRangeSpecification = categoricalParameterRangeSpecification;
            return this;
        }

        public final void setCategoricalParameterRangeSpecification(
                CategoricalParameterRangeSpecification.BuilderImpl categoricalParameterRangeSpecification) {
            this.categoricalParameterRangeSpecification = categoricalParameterRangeSpecification != null ? categoricalParameterRangeSpecification
                    .build() : null;
        }

        @Override
        public ParameterRange build() {
            return new ParameterRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
