/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the cluster used to run a processing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingClusterConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingClusterConfig.Builder, ProcessingClusterConfig> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(ProcessingClusterConfig::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ProcessingClusterConfig::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeInGB").getter(getter(ProcessingClusterConfig::volumeSizeInGB))
            .setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeKmsKeyId").getter(getter(ProcessingClusterConfig::volumeKmsKeyId))
            .setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            INSTANCE_TYPE_FIELD, VOLUME_SIZE_IN_GB_FIELD, VOLUME_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final String instanceType;

    private final Integer volumeSizeInGB;

    private final String volumeKmsKeyId;

    private ProcessingClusterConfig(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
    }

    /**
     * <p>
     * The number of ML compute instances to use in the processing job. For distributed processing jobs, specify a value
     * greater than 1. The default value is 1.
     * </p>
     * 
     * @return The number of ML compute instances to use in the processing job. For distributed processing jobs, specify
     *         a value greater than 1. The default value is 1.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The ML compute instance type for the processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProcessingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The ML compute instance type for the processing job.
     * @see ProcessingInstanceType
     */
    public ProcessingInstanceType instanceType() {
        return ProcessingInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The ML compute instance type for the processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProcessingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The ML compute instance type for the processing job.
     * @see ProcessingInstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient ML storage
     * for your scenario.
     * </p>
     * 
     * @return The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient ML
     *         storage for your scenario.
     */
    public Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instance(s) that run the processing job.
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage
     *         volume attached to the ML compute instance(s) that run the processing job.
     */
    public String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingClusterConfig)) {
            return false;
        }
        ProcessingClusterConfig other = (ProcessingClusterConfig) obj;
        return Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProcessingClusterConfig").add("InstanceCount", instanceCount())
                .add("InstanceType", instanceTypeAsString()).add("VolumeSizeInGB", volumeSizeInGB())
                .add("VolumeKmsKeyId", volumeKmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingClusterConfig, T> g) {
        return obj -> g.apply((ProcessingClusterConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingClusterConfig> {
        /**
         * <p>
         * The number of ML compute instances to use in the processing job. For distributed processing jobs, specify a
         * value greater than 1. The default value is 1.
         * </p>
         * 
         * @param instanceCount
         *        The number of ML compute instances to use in the processing job. For distributed processing jobs,
         *        specify a value greater than 1. The default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The ML compute instance type for the processing job.
         * </p>
         * 
         * @param instanceType
         *        The ML compute instance type for the processing job.
         * @see ProcessingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ML compute instance type for the processing job.
         * </p>
         * 
         * @param instanceType
         *        The ML compute instance type for the processing job.
         * @see ProcessingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingInstanceType
         */
        Builder instanceType(ProcessingInstanceType instanceType);

        /**
         * <p>
         * The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient ML
         * storage for your scenario.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient
         *        ML storage for your scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume
         * attached to the ML compute instance(s) that run the processing job.
         * </p>
         * 
         * @param volumeKmsKeyId
         *        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage
         *        volume attached to the ML compute instance(s) that run the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String instanceType;

        private Integer volumeSizeInGB;

        private String volumeKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingClusterConfig model) {
            instanceCount(model.instanceCount);
            instanceType(model.instanceType);
            volumeSizeInGB(model.volumeSizeInGB);
            volumeKmsKeyId(model.volumeKmsKeyId);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProcessingInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public ProcessingClusterConfig build() {
            return new ProcessingClusterConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
