/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Part of the <code>SuggestionQuery</code> type. Specifies a hint for retrieving property names that begin with the
 * specified text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyNameQuery implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyNameQuery.Builder, PropertyNameQuery> {
    private static final SdkField<String> PROPERTY_NAME_HINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyNameHint").getter(getter(PropertyNameQuery::propertyNameHint))
            .setter(setter(Builder::propertyNameHint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyNameHint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_NAME_HINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyNameHint;

    private PropertyNameQuery(BuilderImpl builder) {
        this.propertyNameHint = builder.propertyNameHint;
    }

    /**
     * <p>
     * Text that begins a property's name.
     * </p>
     * 
     * @return Text that begins a property's name.
     */
    public String propertyNameHint() {
        return propertyNameHint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyNameHint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyNameQuery)) {
            return false;
        }
        PropertyNameQuery other = (PropertyNameQuery) obj;
        return Objects.equals(propertyNameHint(), other.propertyNameHint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PropertyNameQuery").add("PropertyNameHint", propertyNameHint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyNameHint":
            return Optional.ofNullable(clazz.cast(propertyNameHint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyNameQuery, T> g) {
        return obj -> g.apply((PropertyNameQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyNameQuery> {
        /**
         * <p>
         * Text that begins a property's name.
         * </p>
         * 
         * @param propertyNameHint
         *        Text that begins a property's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyNameHint(String propertyNameHint);
    }

    static final class BuilderImpl implements Builder {
        private String propertyNameHint;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyNameQuery model) {
            propertyNameHint(model.propertyNameHint);
        }

        public final String getPropertyNameHint() {
            return propertyNameHint;
        }

        @Override
        public final Builder propertyNameHint(String propertyNameHint) {
            this.propertyNameHint = propertyNameHint;
            return this;
        }

        public final void setPropertyNameHint(String propertyNameHint) {
            this.propertyNameHint = propertyNameHint;
        }

        @Override
        public PropertyNameQuery build() {
            return new PropertyNameQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
