/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for running a SageMaker image as a KernelGateway app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppImageConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AppImageConfigDetails.Builder, AppImageConfigDetails> {
    private static final SdkField<String> APP_IMAGE_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppImageConfigArn").getter(getter(AppImageConfigDetails::appImageConfigArn))
            .setter(setter(Builder::appImageConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigArn").build()).build();

    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppImageConfigName").getter(getter(AppImageConfigDetails::appImageConfigName))
            .setter(setter(Builder::appImageConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AppImageConfigDetails::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(AppImageConfigDetails::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<KernelGatewayImageConfig> KERNEL_GATEWAY_IMAGE_CONFIG_FIELD = SdkField
            .<KernelGatewayImageConfig> builder(MarshallingType.SDK_POJO).memberName("KernelGatewayImageConfig")
            .getter(getter(AppImageConfigDetails::kernelGatewayImageConfig)).setter(setter(Builder::kernelGatewayImageConfig))
            .constructor(KernelGatewayImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayImageConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_IMAGE_CONFIG_ARN_FIELD,
            APP_IMAGE_CONFIG_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, KERNEL_GATEWAY_IMAGE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appImageConfigArn;

    private final String appImageConfigName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final KernelGatewayImageConfig kernelGatewayImageConfig;

    private AppImageConfigDetails(BuilderImpl builder) {
        this.appImageConfigArn = builder.appImageConfigArn;
        this.appImageConfigName = builder.appImageConfigName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.kernelGatewayImageConfig = builder.kernelGatewayImageConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AppImageConfig.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AppImageConfig.
     */
    public String appImageConfigArn() {
        return appImageConfigArn;
    }

    /**
     * <p>
     * The name of the AppImageConfig. Must be unique to your account.
     * </p>
     * 
     * @return The name of the AppImageConfig. Must be unique to your account.
     */
    public String appImageConfigName() {
        return appImageConfigName;
    }

    /**
     * <p>
     * When the AppImageConfig was created.
     * </p>
     * 
     * @return When the AppImageConfig was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the AppImageConfig was last modified.
     * </p>
     * 
     * @return When the AppImageConfig was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The configuration for the file system and kernels in the SageMaker image.
     * </p>
     * 
     * @return The configuration for the file system and kernels in the SageMaker image.
     */
    public KernelGatewayImageConfig kernelGatewayImageConfig() {
        return kernelGatewayImageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appImageConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(appImageConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(kernelGatewayImageConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppImageConfigDetails)) {
            return false;
        }
        AppImageConfigDetails other = (AppImageConfigDetails) obj;
        return Objects.equals(appImageConfigArn(), other.appImageConfigArn())
                && Objects.equals(appImageConfigName(), other.appImageConfigName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(kernelGatewayImageConfig(), other.kernelGatewayImageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AppImageConfigDetails").add("AppImageConfigArn", appImageConfigArn())
                .add("AppImageConfigName", appImageConfigName()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("KernelGatewayImageConfig", kernelGatewayImageConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppImageConfigArn":
            return Optional.ofNullable(clazz.cast(appImageConfigArn()));
        case "AppImageConfigName":
            return Optional.ofNullable(clazz.cast(appImageConfigName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "KernelGatewayImageConfig":
            return Optional.ofNullable(clazz.cast(kernelGatewayImageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppImageConfigDetails, T> g) {
        return obj -> g.apply((AppImageConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppImageConfigDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AppImageConfig.
         * </p>
         * 
         * @param appImageConfigArn
         *        The Amazon Resource Name (ARN) of the AppImageConfig.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigArn(String appImageConfigArn);

        /**
         * <p>
         * The name of the AppImageConfig. Must be unique to your account.
         * </p>
         * 
         * @param appImageConfigName
         *        The name of the AppImageConfig. Must be unique to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigName(String appImageConfigName);

        /**
         * <p>
         * When the AppImageConfig was created.
         * </p>
         * 
         * @param creationTime
         *        When the AppImageConfig was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the AppImageConfig was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the AppImageConfig was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The configuration for the file system and kernels in the SageMaker image.
         * </p>
         * 
         * @param kernelGatewayImageConfig
         *        The configuration for the file system and kernels in the SageMaker image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig);

        /**
         * <p>
         * The configuration for the file system and kernels in the SageMaker image.
         * </p>
         * This is a convenience that creates an instance of the {@link KernelGatewayImageConfig.Builder} avoiding the
         * need to create one manually via {@link KernelGatewayImageConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link KernelGatewayImageConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #kernelGatewayImageConfig(KernelGatewayImageConfig)}.
         * 
         * @param kernelGatewayImageConfig
         *        a consumer that will call methods on {@link KernelGatewayImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelGatewayImageConfig(KernelGatewayImageConfig)
         */
        default Builder kernelGatewayImageConfig(Consumer<KernelGatewayImageConfig.Builder> kernelGatewayImageConfig) {
            return kernelGatewayImageConfig(KernelGatewayImageConfig.builder().applyMutation(kernelGatewayImageConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String appImageConfigArn;

        private String appImageConfigName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private KernelGatewayImageConfig kernelGatewayImageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AppImageConfigDetails model) {
            appImageConfigArn(model.appImageConfigArn);
            appImageConfigName(model.appImageConfigName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            kernelGatewayImageConfig(model.kernelGatewayImageConfig);
        }

        public final String getAppImageConfigArn() {
            return appImageConfigArn;
        }

        @Override
        public final Builder appImageConfigArn(String appImageConfigArn) {
            this.appImageConfigArn = appImageConfigArn;
            return this;
        }

        public final void setAppImageConfigArn(String appImageConfigArn) {
            this.appImageConfigArn = appImageConfigArn;
        }

        public final String getAppImageConfigName() {
            return appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final KernelGatewayImageConfig.Builder getKernelGatewayImageConfig() {
            return kernelGatewayImageConfig != null ? kernelGatewayImageConfig.toBuilder() : null;
        }

        @Override
        public final Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        public final void setKernelGatewayImageConfig(KernelGatewayImageConfig.BuilderImpl kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig != null ? kernelGatewayImageConfig.build() : null;
        }

        @Override
        public AppImageConfigDetails build() {
            return new AppImageConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
