/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCodeRepositoryRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateCodeRepositoryRequest.Builder, CreateCodeRepositoryRequest> {
    private static final SdkField<String> CODE_REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeRepositoryName").getter(getter(CreateCodeRepositoryRequest::codeRepositoryName))
            .setter(setter(Builder::codeRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryName").build())
            .build();

    private static final SdkField<GitConfig> GIT_CONFIG_FIELD = SdkField.<GitConfig> builder(MarshallingType.SDK_POJO)
            .memberName("GitConfig").getter(getter(CreateCodeRepositoryRequest::gitConfig)).setter(setter(Builder::gitConfig))
            .constructor(GitConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateCodeRepositoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_NAME_FIELD,
            GIT_CONFIG_FIELD, TAGS_FIELD));

    private final String codeRepositoryName;

    private final GitConfig gitConfig;

    private final List<Tag> tags;

    private CreateCodeRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.codeRepositoryName = builder.codeRepositoryName;
        this.gitConfig = builder.gitConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     * (hyphen).
     * </p>
     * 
     * @return The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z,
     *         0-9, and - (hyphen).
     */
    public String codeRepositoryName() {
        return codeRepositoryName;
    }

    /**
     * <p>
     * Specifies details about the repository, including the URL where the repository is located, the default branch,
     * and credentials to use to access the repository.
     * </p>
     * 
     * @return Specifies details about the repository, including the URL where the repository is located, the default
     *         branch, and credentials to use to access the repository.
     */
    public GitConfig gitConfig() {
        return gitConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by
     * purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
     *         example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(gitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeRepositoryRequest)) {
            return false;
        }
        CreateCodeRepositoryRequest other = (CreateCodeRepositoryRequest) obj;
        return Objects.equals(codeRepositoryName(), other.codeRepositoryName()) && Objects.equals(gitConfig(), other.gitConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCodeRepositoryRequest").add("CodeRepositoryName", codeRepositoryName())
                .add("GitConfig", gitConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeRepositoryName":
            return Optional.ofNullable(clazz.cast(codeRepositoryName()));
        case "GitConfig":
            return Optional.ofNullable(clazz.cast(gitConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeRepositoryRequest, T> g) {
        return obj -> g.apply((CreateCodeRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCodeRepositoryRequest> {
        /**
         * <p>
         * The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9,
         * and - (hyphen).
         * </p>
         * 
         * @param codeRepositoryName
         *        The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z,
         *        0-9, and - (hyphen).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryName(String codeRepositoryName);

        /**
         * <p>
         * Specifies details about the repository, including the URL where the repository is located, the default
         * branch, and credentials to use to access the repository.
         * </p>
         * 
         * @param gitConfig
         *        Specifies details about the repository, including the URL where the repository is located, the default
         *        branch, and credentials to use to access the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitConfig(GitConfig gitConfig);

        /**
         * <p>
         * Specifies details about the repository, including the URL where the repository is located, the default
         * branch, and credentials to use to access the repository.
         * </p>
         * This is a convenience that creates an instance of the {@link GitConfig.Builder} avoiding the need to create
         * one manually via {@link GitConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link GitConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #gitConfig(GitConfig)}.
         * 
         * @param gitConfig
         *        a consumer that will call methods on {@link GitConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitConfig(GitConfig)
         */
        default Builder gitConfig(Consumer<GitConfig.Builder> gitConfig) {
            return gitConfig(GitConfig.builder().applyMutation(gitConfig).build());
        }

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         * example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         *        example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         * example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         *        example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         * example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String codeRepositoryName;

        private GitConfig gitConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeRepositoryRequest model) {
            super(model);
            codeRepositoryName(model.codeRepositoryName);
            gitConfig(model.gitConfig);
            tags(model.tags);
        }

        public final String getCodeRepositoryName() {
            return codeRepositoryName;
        }

        @Override
        public final Builder codeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
            return this;
        }

        public final void setCodeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
        }

        public final GitConfig.Builder getGitConfig() {
            return gitConfig != null ? gitConfig.toBuilder() : null;
        }

        @Override
        public final Builder gitConfig(GitConfig gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        public final void setGitConfig(GitConfig.BuilderImpl gitConfig) {
            this.gitConfig = gitConfig != null ? gitConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeRepositoryRequest build() {
            return new CreateCodeRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
