/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppImageConfigsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListAppImageConfigsResponse.Builder, ListAppImageConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppImageConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<AppImageConfigDetails>> APP_IMAGE_CONFIGS_FIELD = SdkField
            .<List<AppImageConfigDetails>> builder(MarshallingType.LIST)
            .memberName("AppImageConfigs")
            .getter(getter(ListAppImageConfigsResponse::appImageConfigs))
            .setter(setter(Builder::appImageConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppImageConfigDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppImageConfigDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            APP_IMAGE_CONFIGS_FIELD));

    private final String nextToken;

    private final List<AppImageConfigDetails> appImageConfigs;

    private ListAppImageConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.appImageConfigs = builder.appImageConfigs;
    }

    /**
     * <p>
     * A token for getting the next set of AppImageConfigs, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of AppImageConfigs, if there are any.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the AppImageConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAppImageConfigs() {
        return appImageConfigs != null && !(appImageConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AppImageConfigs and their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAppImageConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AppImageConfigs and their properties.
     */
    public List<AppImageConfigDetails> appImageConfigs() {
        return appImageConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppImageConfigs() ? appImageConfigs() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppImageConfigsResponse)) {
            return false;
        }
        ListAppImageConfigsResponse other = (ListAppImageConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAppImageConfigs() == other.hasAppImageConfigs()
                && Objects.equals(appImageConfigs(), other.appImageConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAppImageConfigsResponse").add("NextToken", nextToken())
                .add("AppImageConfigs", hasAppImageConfigs() ? appImageConfigs() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AppImageConfigs":
            return Optional.ofNullable(clazz.cast(appImageConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppImageConfigsResponse, T> g) {
        return obj -> g.apply((ListAppImageConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppImageConfigsResponse> {
        /**
         * <p>
         * A token for getting the next set of AppImageConfigs, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of AppImageConfigs, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of AppImageConfigs and their properties.
         * </p>
         * 
         * @param appImageConfigs
         *        A list of AppImageConfigs and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigs(Collection<AppImageConfigDetails> appImageConfigs);

        /**
         * <p>
         * A list of AppImageConfigs and their properties.
         * </p>
         * 
         * @param appImageConfigs
         *        A list of AppImageConfigs and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigs(AppImageConfigDetails... appImageConfigs);

        /**
         * <p>
         * A list of AppImageConfigs and their properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppImageConfigDetails>.Builder} avoiding
         * the need to create one manually via {@link List<AppImageConfigDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppImageConfigDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #appImageConfigs(List<AppImageConfigDetails>)}.
         * 
         * @param appImageConfigs
         *        a consumer that will call methods on {@link List<AppImageConfigDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appImageConfigs(List<AppImageConfigDetails>)
         */
        Builder appImageConfigs(Consumer<AppImageConfigDetails.Builder>... appImageConfigs);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AppImageConfigDetails> appImageConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppImageConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            appImageConfigs(model.appImageConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<AppImageConfigDetails.Builder> getAppImageConfigs() {
            if (appImageConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return appImageConfigs != null ? appImageConfigs.stream().map(AppImageConfigDetails::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder appImageConfigs(Collection<AppImageConfigDetails> appImageConfigs) {
            this.appImageConfigs = AppImageConfigListCopier.copy(appImageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appImageConfigs(AppImageConfigDetails... appImageConfigs) {
            appImageConfigs(Arrays.asList(appImageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appImageConfigs(Consumer<AppImageConfigDetails.Builder>... appImageConfigs) {
            appImageConfigs(Stream.of(appImageConfigs).map(c -> AppImageConfigDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAppImageConfigs(Collection<AppImageConfigDetails.BuilderImpl> appImageConfigs) {
            this.appImageConfigs = AppImageConfigListCopier.copyFromBuilder(appImageConfigs);
        }

        @Override
        public ListAppImageConfigsResponse build() {
            return new ListAppImageConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
