/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTransformJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeTransformJobResponse.Builder, DescribeTransformJobResponse> {
    private static final SdkField<String> TRANSFORM_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformJobName").getter(getter(DescribeTransformJobResponse::transformJobName))
            .setter(setter(Builder::transformJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobName").build()).build();

    private static final SdkField<String> TRANSFORM_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformJobArn").getter(getter(DescribeTransformJobResponse::transformJobArn))
            .setter(setter(Builder::transformJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobArn").build()).build();

    private static final SdkField<String> TRANSFORM_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformJobStatus").getter(getter(DescribeTransformJobResponse::transformJobStatusAsString))
            .setter(setter(Builder::transformJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeTransformJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(DescribeTransformJobResponse::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_TRANSFORMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentTransforms").getter(getter(DescribeTransformJobResponse::maxConcurrentTransforms))
            .setter(setter(Builder::maxConcurrentTransforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTransforms").build())
            .build();

    private static final SdkField<ModelClientConfig> MODEL_CLIENT_CONFIG_FIELD = SdkField
            .<ModelClientConfig> builder(MarshallingType.SDK_POJO).memberName("ModelClientConfig")
            .getter(getter(DescribeTransformJobResponse::modelClientConfig)).setter(setter(Builder::modelClientConfig))
            .constructor(ModelClientConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelClientConfig").build()).build();

    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxPayloadInMB").getter(getter(DescribeTransformJobResponse::maxPayloadInMB))
            .setter(setter(Builder::maxPayloadInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadInMB").build()).build();

    private static final SdkField<String> BATCH_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchStrategy").getter(getter(DescribeTransformJobResponse::batchStrategyAsString))
            .setter(setter(Builder::batchStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchStrategy").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Environment")
            .getter(getter(DescribeTransformJobResponse::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TransformInput> TRANSFORM_INPUT_FIELD = SdkField
            .<TransformInput> builder(MarshallingType.SDK_POJO).memberName("TransformInput")
            .getter(getter(DescribeTransformJobResponse::transformInput)).setter(setter(Builder::transformInput))
            .constructor(TransformInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformInput").build()).build();

    private static final SdkField<TransformOutput> TRANSFORM_OUTPUT_FIELD = SdkField
            .<TransformOutput> builder(MarshallingType.SDK_POJO).memberName("TransformOutput")
            .getter(getter(DescribeTransformJobResponse::transformOutput)).setter(setter(Builder::transformOutput))
            .constructor(TransformOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOutput").build()).build();

    private static final SdkField<TransformResources> TRANSFORM_RESOURCES_FIELD = SdkField
            .<TransformResources> builder(MarshallingType.SDK_POJO).memberName("TransformResources")
            .getter(getter(DescribeTransformJobResponse::transformResources)).setter(setter(Builder::transformResources))
            .constructor(TransformResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformResources").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeTransformJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> TRANSFORM_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TransformStartTime").getter(getter(DescribeTransformJobResponse::transformStartTime))
            .setter(setter(Builder::transformStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformStartTime").build())
            .build();

    private static final SdkField<Instant> TRANSFORM_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TransformEndTime").getter(getter(DescribeTransformJobResponse::transformEndTime))
            .setter(setter(Builder::transformEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformEndTime").build()).build();

    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelingJobArn").getter(getter(DescribeTransformJobResponse::labelingJobArn))
            .setter(setter(Builder::labelingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobArn").getter(getter(DescribeTransformJobResponse::autoMLJobArn))
            .setter(setter(Builder::autoMLJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()).build();

    private static final SdkField<DataProcessing> DATA_PROCESSING_FIELD = SdkField
            .<DataProcessing> builder(MarshallingType.SDK_POJO).memberName("DataProcessing")
            .getter(getter(DescribeTransformJobResponse::dataProcessing)).setter(setter(Builder::dataProcessing))
            .constructor(DataProcessing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProcessing").build()).build();

    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField
            .<ExperimentConfig> builder(MarshallingType.SDK_POJO).memberName("ExperimentConfig")
            .getter(getter(DescribeTransformJobResponse::experimentConfig)).setter(setter(Builder::experimentConfig))
            .constructor(ExperimentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_NAME_FIELD,
            TRANSFORM_JOB_ARN_FIELD, TRANSFORM_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, MODEL_NAME_FIELD,
            MAX_CONCURRENT_TRANSFORMS_FIELD, MODEL_CLIENT_CONFIG_FIELD, MAX_PAYLOAD_IN_MB_FIELD, BATCH_STRATEGY_FIELD,
            ENVIRONMENT_FIELD, TRANSFORM_INPUT_FIELD, TRANSFORM_OUTPUT_FIELD, TRANSFORM_RESOURCES_FIELD, CREATION_TIME_FIELD,
            TRANSFORM_START_TIME_FIELD, TRANSFORM_END_TIME_FIELD, LABELING_JOB_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD,
            DATA_PROCESSING_FIELD, EXPERIMENT_CONFIG_FIELD));

    private final String transformJobName;

    private final String transformJobArn;

    private final String transformJobStatus;

    private final String failureReason;

    private final String modelName;

    private final Integer maxConcurrentTransforms;

    private final ModelClientConfig modelClientConfig;

    private final Integer maxPayloadInMB;

    private final String batchStrategy;

    private final Map<String, String> environment;

    private final TransformInput transformInput;

    private final TransformOutput transformOutput;

    private final TransformResources transformResources;

    private final Instant creationTime;

    private final Instant transformStartTime;

    private final Instant transformEndTime;

    private final String labelingJobArn;

    private final String autoMLJobArn;

    private final DataProcessing dataProcessing;

    private final ExperimentConfig experimentConfig;

    private DescribeTransformJobResponse(BuilderImpl builder) {
        super(builder);
        this.transformJobName = builder.transformJobName;
        this.transformJobArn = builder.transformJobArn;
        this.transformJobStatus = builder.transformJobStatus;
        this.failureReason = builder.failureReason;
        this.modelName = builder.modelName;
        this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
        this.modelClientConfig = builder.modelClientConfig;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.batchStrategy = builder.batchStrategy;
        this.environment = builder.environment;
        this.transformInput = builder.transformInput;
        this.transformOutput = builder.transformOutput;
        this.transformResources = builder.transformResources;
        this.creationTime = builder.creationTime;
        this.transformStartTime = builder.transformStartTime;
        this.transformEndTime = builder.transformEndTime;
        this.labelingJobArn = builder.labelingJobArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.dataProcessing = builder.dataProcessing;
        this.experimentConfig = builder.experimentConfig;
    }

    /**
     * <p>
     * The name of the transform job.
     * </p>
     * 
     * @return The name of the transform job.
     */
    public String transformJobName() {
        return transformJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the transform job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the transform job.
     */
    public String transformJobArn() {
        return transformJobArn;
    }

    /**
     * <p>
     * The status of the transform job. If the transform job failed, the reason is returned in the
     * <code>FailureReason</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transformJobStatus} will return {@link TransformJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #transformJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transform job. If the transform job failed, the reason is returned in the
     *         <code>FailureReason</code> field.
     * @see TransformJobStatus
     */
    public TransformJobStatus transformJobStatus() {
        return TransformJobStatus.fromValue(transformJobStatus);
    }

    /**
     * <p>
     * The status of the transform job. If the transform job failed, the reason is returned in the
     * <code>FailureReason</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transformJobStatus} will return {@link TransformJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #transformJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transform job. If the transform job failed, the reason is returned in the
     *         <code>FailureReason</code> field.
     * @see TransformJobStatus
     */
    public String transformJobStatusAsString() {
        return transformJobStatus;
    }

    /**
     * <p>
     * If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log
     * file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with
     * Amazon CloudWatch</a>.
     * </p>
     * 
     * @return If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates
     *         a log file, which includes error messages, and stores it as an Amazon S3 object. For more information,
     *         see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon
     *         SageMaker Events with Amazon CloudWatch</a>.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The name of the model used in the transform job.
     * </p>
     * 
     * @return The name of the model used in the transform job.
     */
    public String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The maximum number of parallel requests on each instance node that can be launched in a transform job. The
     * default value is 1.
     * </p>
     * 
     * @return The maximum number of parallel requests on each instance node that can be launched in a transform job.
     *         The default value is 1.
     */
    public Integer maxConcurrentTransforms() {
        return maxConcurrentTransforms;
    }

    /**
     * <p>
     * The timeout and maximum number of retries for processing a transform job invocation.
     * </p>
     * 
     * @return The timeout and maximum number of retries for processing a transform job invocation.
     */
    public ModelClientConfig modelClientConfig() {
        return modelClientConfig;
    }

    /**
     * <p>
     * The maximum payload size, in MB, used in the transform job.
     * </p>
     * 
     * @return The maximum payload size, in MB, used in the transform job.
     */
    public Integer maxPayloadInMB() {
        return maxPayloadInMB;
    }

    /**
     * <p>
     * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is
     * a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
     * </p>
     * <p>
     * To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or
     * <code>TFRecord</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batchStrategy}
     * will return {@link BatchStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #batchStrategyAsString}.
     * </p>
     * 
     * @return Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
     *         <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV
     *         file is a record. </p>
     *         <p>
     *         To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>,
     *         <code>RecordIO</code>, or <code>TFRecord</code>.
     * @see BatchStrategy
     */
    public BatchStrategy batchStrategy() {
        return BatchStrategy.fromValue(batchStrategy);
    }

    /**
     * <p>
     * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is
     * a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
     * </p>
     * <p>
     * To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or
     * <code>TFRecord</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batchStrategy}
     * will return {@link BatchStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #batchStrategyAsString}.
     * </p>
     * 
     * @return Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
     *         <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV
     *         file is a record. </p>
     *         <p>
     *         To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>,
     *         <code>RecordIO</code>, or <code>TFRecord</code>.
     * @see BatchStrategy
     */
    public String batchStrategyAsString() {
        return batchStrategy;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The environment variables to set in the Docker container. We support up to 16 key and values entries in
     *         the map.
     */
    public Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * Describes the dataset to be transformed and the Amazon S3 location where it is stored.
     * </p>
     * 
     * @return Describes the dataset to be transformed and the Amazon S3 location where it is stored.
     */
    public TransformInput transformInput() {
        return transformInput;
    }

    /**
     * <p>
     * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
     * </p>
     * 
     * @return Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform
     *         job.
     */
    public TransformOutput transformOutput() {
        return transformOutput;
    }

    /**
     * <p>
     * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
     * </p>
     * 
     * @return Describes the resources, including ML instance types and ML instance count, to use for the transform job.
     */
    public TransformResources transformResources() {
        return transformResources;
    }

    /**
     * <p>
     * A timestamp that shows when the transform Job was created.
     * </p>
     * 
     * @return A timestamp that shows when the transform Job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Indicates when the transform job starts on ML instances. You are billed for the time interval between this time
     * and the value of <code>TransformEndTime</code>.
     * </p>
     * 
     * @return Indicates when the transform job starts on ML instances. You are billed for the time interval between
     *         this time and the value of <code>TransformEndTime</code>.
     */
    public Instant transformStartTime() {
        return transformStartTime;
    }

    /**
     * <p>
     * Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time
     * interval between this time and the value of <code>TransformStartTime</code>.
     * </p>
     * 
     * @return Indicates when the transform job has been completed, or has stopped or failed. You are billed for the
     *         time interval between this time and the value of <code>TransformStartTime</code>.
     */
    public Instant transformEndTime() {
        return transformEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or
     * training job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the
     *         transform or training job.
     */
    public String labelingJobArn() {
        return labelingJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AutoML transform job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AutoML transform job.
     */
    public String autoMLJobArn() {
        return autoMLJobArn;
    }

    /**
     * Returns the value of the DataProcessing property for this object.
     * 
     * @return The value of the DataProcessing property for this object.
     */
    public DataProcessing dataProcessing() {
        return dataProcessing;
    }

    /**
     * Returns the value of the ExperimentConfig property for this object.
     * 
     * @return The value of the ExperimentConfig property for this object.
     */
    public ExperimentConfig experimentConfig() {
        return experimentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(transformJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(transformJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentTransforms());
        hashCode = 31 * hashCode + Objects.hashCode(modelClientConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(batchStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transformInput());
        hashCode = 31 * hashCode + Objects.hashCode(transformOutput());
        hashCode = 31 * hashCode + Objects.hashCode(transformResources());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(transformStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(transformEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(experimentConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransformJobResponse)) {
            return false;
        }
        DescribeTransformJobResponse other = (DescribeTransformJobResponse) obj;
        return Objects.equals(transformJobName(), other.transformJobName())
                && Objects.equals(transformJobArn(), other.transformJobArn())
                && Objects.equals(transformJobStatusAsString(), other.transformJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(maxConcurrentTransforms(), other.maxConcurrentTransforms())
                && Objects.equals(modelClientConfig(), other.modelClientConfig())
                && Objects.equals(maxPayloadInMB(), other.maxPayloadInMB())
                && Objects.equals(batchStrategyAsString(), other.batchStrategyAsString())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment())
                && Objects.equals(transformInput(), other.transformInput())
                && Objects.equals(transformOutput(), other.transformOutput())
                && Objects.equals(transformResources(), other.transformResources())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(transformStartTime(), other.transformStartTime())
                && Objects.equals(transformEndTime(), other.transformEndTime())
                && Objects.equals(labelingJobArn(), other.labelingJobArn())
                && Objects.equals(autoMLJobArn(), other.autoMLJobArn())
                && Objects.equals(dataProcessing(), other.dataProcessing())
                && Objects.equals(experimentConfig(), other.experimentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTransformJobResponse").add("TransformJobName", transformJobName())
                .add("TransformJobArn", transformJobArn()).add("TransformJobStatus", transformJobStatusAsString())
                .add("FailureReason", failureReason()).add("ModelName", modelName())
                .add("MaxConcurrentTransforms", maxConcurrentTransforms()).add("ModelClientConfig", modelClientConfig())
                .add("MaxPayloadInMB", maxPayloadInMB()).add("BatchStrategy", batchStrategyAsString())
                .add("Environment", hasEnvironment() ? environment() : null).add("TransformInput", transformInput())
                .add("TransformOutput", transformOutput()).add("TransformResources", transformResources())
                .add("CreationTime", creationTime()).add("TransformStartTime", transformStartTime())
                .add("TransformEndTime", transformEndTime()).add("LabelingJobArn", labelingJobArn())
                .add("AutoMLJobArn", autoMLJobArn()).add("DataProcessing", dataProcessing())
                .add("ExperimentConfig", experimentConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformJobName":
            return Optional.ofNullable(clazz.cast(transformJobName()));
        case "TransformJobArn":
            return Optional.ofNullable(clazz.cast(transformJobArn()));
        case "TransformJobStatus":
            return Optional.ofNullable(clazz.cast(transformJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "MaxConcurrentTransforms":
            return Optional.ofNullable(clazz.cast(maxConcurrentTransforms()));
        case "ModelClientConfig":
            return Optional.ofNullable(clazz.cast(modelClientConfig()));
        case "MaxPayloadInMB":
            return Optional.ofNullable(clazz.cast(maxPayloadInMB()));
        case "BatchStrategy":
            return Optional.ofNullable(clazz.cast(batchStrategyAsString()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "TransformInput":
            return Optional.ofNullable(clazz.cast(transformInput()));
        case "TransformOutput":
            return Optional.ofNullable(clazz.cast(transformOutput()));
        case "TransformResources":
            return Optional.ofNullable(clazz.cast(transformResources()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TransformStartTime":
            return Optional.ofNullable(clazz.cast(transformStartTime()));
        case "TransformEndTime":
            return Optional.ofNullable(clazz.cast(transformEndTime()));
        case "LabelingJobArn":
            return Optional.ofNullable(clazz.cast(labelingJobArn()));
        case "AutoMLJobArn":
            return Optional.ofNullable(clazz.cast(autoMLJobArn()));
        case "DataProcessing":
            return Optional.ofNullable(clazz.cast(dataProcessing()));
        case "ExperimentConfig":
            return Optional.ofNullable(clazz.cast(experimentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransformJobResponse, T> g) {
        return obj -> g.apply((DescribeTransformJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTransformJobResponse> {
        /**
         * <p>
         * The name of the transform job.
         * </p>
         * 
         * @param transformJobName
         *        The name of the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobName(String transformJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transform job.
         * </p>
         * 
         * @param transformJobArn
         *        The Amazon Resource Name (ARN) of the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobArn(String transformJobArn);

        /**
         * <p>
         * The status of the transform job. If the transform job failed, the reason is returned in the
         * <code>FailureReason</code> field.
         * </p>
         * 
         * @param transformJobStatus
         *        The status of the transform job. If the transform job failed, the reason is returned in the
         *        <code>FailureReason</code> field.
         * @see TransformJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformJobStatus
         */
        Builder transformJobStatus(String transformJobStatus);

        /**
         * <p>
         * The status of the transform job. If the transform job failed, the reason is returned in the
         * <code>FailureReason</code> field.
         * </p>
         * 
         * @param transformJobStatus
         *        The status of the transform job. If the transform job failed, the reason is returned in the
         *        <code>FailureReason</code> field.
         * @see TransformJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformJobStatus
         */
        Builder transformJobStatus(TransformJobStatus transformJobStatus);

        /**
         * <p>
         * If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a
         * log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events
         * with Amazon CloudWatch</a>.
         * </p>
         * 
         * @param failureReason
         *        If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job
         *        creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more
         *        information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log
         *        Amazon SageMaker Events with Amazon CloudWatch</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The name of the model used in the transform job.
         * </p>
         * 
         * @param modelName
         *        The name of the model used in the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The maximum number of parallel requests on each instance node that can be launched in a transform job. The
         * default value is 1.
         * </p>
         * 
         * @param maxConcurrentTransforms
         *        The maximum number of parallel requests on each instance node that can be launched in a transform job.
         *        The default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentTransforms(Integer maxConcurrentTransforms);

        /**
         * <p>
         * The timeout and maximum number of retries for processing a transform job invocation.
         * </p>
         * 
         * @param modelClientConfig
         *        The timeout and maximum number of retries for processing a transform job invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelClientConfig(ModelClientConfig modelClientConfig);

        /**
         * <p>
         * The timeout and maximum number of retries for processing a transform job invocation.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelClientConfig.Builder} avoiding the need to
         * create one manually via {@link ModelClientConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelClientConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #modelClientConfig(ModelClientConfig)}.
         * 
         * @param modelClientConfig
         *        a consumer that will call methods on {@link ModelClientConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelClientConfig(ModelClientConfig)
         */
        default Builder modelClientConfig(Consumer<ModelClientConfig.Builder> modelClientConfig) {
            return modelClientConfig(ModelClientConfig.builder().applyMutation(modelClientConfig).build());
        }

        /**
         * <p>
         * The maximum payload size, in MB, used in the transform job.
         * </p>
         * 
         * @param maxPayloadInMB
         *        The maximum payload size, in MB, used in the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPayloadInMB(Integer maxPayloadInMB);

        /**
         * <p>
         * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
         * <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file
         * is a record.
         * </p>
         * <p>
         * To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>
         * , or <code>TFRecord</code>.
         * </p>
         * 
         * @param batchStrategy
         *        Specifies the number of records to include in a mini-batch for an HTTP inference request. A
         *        <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single
         *        line in a CSV file is a record. </p>
         *        <p>
         *        To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>,
         *        <code>RecordIO</code>, or <code>TFRecord</code>.
         * @see BatchStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchStrategy
         */
        Builder batchStrategy(String batchStrategy);

        /**
         * <p>
         * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
         * <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file
         * is a record.
         * </p>
         * <p>
         * To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>
         * , or <code>TFRecord</code>.
         * </p>
         * 
         * @param batchStrategy
         *        Specifies the number of records to include in a mini-batch for an HTTP inference request. A
         *        <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single
         *        line in a CSV file is a record. </p>
         *        <p>
         *        To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>,
         *        <code>RecordIO</code>, or <code>TFRecord</code>.
         * @see BatchStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchStrategy
         */
        Builder batchStrategy(BatchStrategy batchStrategy);

        /**
         * <p>
         * The environment variables to set in the Docker container. We support up to 16 key and values entries in the
         * map.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container. We support up to 16 key and values entries
         *        in the map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * Describes the dataset to be transformed and the Amazon S3 location where it is stored.
         * </p>
         * 
         * @param transformInput
         *        Describes the dataset to be transformed and the Amazon S3 location where it is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformInput(TransformInput transformInput);

        /**
         * <p>
         * Describes the dataset to be transformed and the Amazon S3 location where it is stored.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformInput.Builder} avoiding the need to
         * create one manually via {@link TransformInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformInput.Builder#build()} is called immediately and its
         * result is passed to {@link #transformInput(TransformInput)}.
         * 
         * @param transformInput
         *        a consumer that will call methods on {@link TransformInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformInput(TransformInput)
         */
        default Builder transformInput(Consumer<TransformInput.Builder> transformInput) {
            return transformInput(TransformInput.builder().applyMutation(transformInput).build());
        }

        /**
         * <p>
         * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
         * </p>
         * 
         * @param transformOutput
         *        Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the
         *        transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformOutput(TransformOutput transformOutput);

        /**
         * <p>
         * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformOutput.Builder} avoiding the need to
         * create one manually via {@link TransformOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #transformOutput(TransformOutput)}.
         * 
         * @param transformOutput
         *        a consumer that will call methods on {@link TransformOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformOutput(TransformOutput)
         */
        default Builder transformOutput(Consumer<TransformOutput.Builder> transformOutput) {
            return transformOutput(TransformOutput.builder().applyMutation(transformOutput).build());
        }

        /**
         * <p>
         * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
         * </p>
         * 
         * @param transformResources
         *        Describes the resources, including ML instance types and ML instance count, to use for the transform
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformResources(TransformResources transformResources);

        /**
         * <p>
         * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformResources.Builder} avoiding the need to
         * create one manually via {@link TransformResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformResources.Builder#build()} is called immediately and its
         * result is passed to {@link #transformResources(TransformResources)}.
         * 
         * @param transformResources
         *        a consumer that will call methods on {@link TransformResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformResources(TransformResources)
         */
        default Builder transformResources(Consumer<TransformResources.Builder> transformResources) {
            return transformResources(TransformResources.builder().applyMutation(transformResources).build());
        }

        /**
         * <p>
         * A timestamp that shows when the transform Job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the transform Job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Indicates when the transform job starts on ML instances. You are billed for the time interval between this
         * time and the value of <code>TransformEndTime</code>.
         * </p>
         * 
         * @param transformStartTime
         *        Indicates when the transform job starts on ML instances. You are billed for the time interval between
         *        this time and the value of <code>TransformEndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformStartTime(Instant transformStartTime);

        /**
         * <p>
         * Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time
         * interval between this time and the value of <code>TransformStartTime</code>.
         * </p>
         * 
         * @param transformEndTime
         *        Indicates when the transform job has been completed, or has stopped or failed. You are billed for the
         *        time interval between this time and the value of <code>TransformStartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformEndTime(Instant transformEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform
         * or training job.
         * </p>
         * 
         * @param labelingJobArn
         *        The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the
         *        transform or training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobArn(String labelingJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AutoML transform job.
         * </p>
         * 
         * @param autoMLJobArn
         *        The Amazon Resource Name (ARN) of the AutoML transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArn(String autoMLJobArn);

        /**
         * Sets the value of the DataProcessing property for this object.
         *
         * @param dataProcessing
         *        The new value for the DataProcessing property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProcessing(DataProcessing dataProcessing);

        /**
         * Sets the value of the DataProcessing property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataProcessing.Builder} avoiding the need to
         * create one manually via {@link DataProcessing#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataProcessing.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProcessing(DataProcessing)}.
         * 
         * @param dataProcessing
         *        a consumer that will call methods on {@link DataProcessing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProcessing(DataProcessing)
         */
        default Builder dataProcessing(Consumer<DataProcessing.Builder> dataProcessing) {
            return dataProcessing(DataProcessing.builder().applyMutation(dataProcessing).build());
        }

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * @param experimentConfig
         *        The new value for the ExperimentConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentConfig(ExperimentConfig experimentConfig);

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExperimentConfig.Builder} avoiding the need to
         * create one manually via {@link ExperimentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentConfig(ExperimentConfig)}.
         * 
         * @param experimentConfig
         *        a consumer that will call methods on {@link ExperimentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentConfig(ExperimentConfig)
         */
        default Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return experimentConfig(ExperimentConfig.builder().applyMutation(experimentConfig).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String transformJobName;

        private String transformJobArn;

        private String transformJobStatus;

        private String failureReason;

        private String modelName;

        private Integer maxConcurrentTransforms;

        private ModelClientConfig modelClientConfig;

        private Integer maxPayloadInMB;

        private String batchStrategy;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private TransformInput transformInput;

        private TransformOutput transformOutput;

        private TransformResources transformResources;

        private Instant creationTime;

        private Instant transformStartTime;

        private Instant transformEndTime;

        private String labelingJobArn;

        private String autoMLJobArn;

        private DataProcessing dataProcessing;

        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransformJobResponse model) {
            super(model);
            transformJobName(model.transformJobName);
            transformJobArn(model.transformJobArn);
            transformJobStatus(model.transformJobStatus);
            failureReason(model.failureReason);
            modelName(model.modelName);
            maxConcurrentTransforms(model.maxConcurrentTransforms);
            modelClientConfig(model.modelClientConfig);
            maxPayloadInMB(model.maxPayloadInMB);
            batchStrategy(model.batchStrategy);
            environment(model.environment);
            transformInput(model.transformInput);
            transformOutput(model.transformOutput);
            transformResources(model.transformResources);
            creationTime(model.creationTime);
            transformStartTime(model.transformStartTime);
            transformEndTime(model.transformEndTime);
            labelingJobArn(model.labelingJobArn);
            autoMLJobArn(model.autoMLJobArn);
            dataProcessing(model.dataProcessing);
            experimentConfig(model.experimentConfig);
        }

        public final String getTransformJobName() {
            return transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        public final String getTransformJobArn() {
            return transformJobArn;
        }

        @Override
        public final Builder transformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
            return this;
        }

        public final void setTransformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
        }

        public final String getTransformJobStatus() {
            return transformJobStatus;
        }

        @Override
        public final Builder transformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
            return this;
        }

        @Override
        public final Builder transformJobStatus(TransformJobStatus transformJobStatus) {
            this.transformJobStatus(transformJobStatus == null ? null : transformJobStatus.toString());
            return this;
        }

        public final void setTransformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Integer getMaxConcurrentTransforms() {
            return maxConcurrentTransforms;
        }

        @Override
        public final Builder maxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public final void setMaxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
        }

        public final ModelClientConfig.Builder getModelClientConfig() {
            return modelClientConfig != null ? modelClientConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelClientConfig(ModelClientConfig modelClientConfig) {
            this.modelClientConfig = modelClientConfig;
            return this;
        }

        public final void setModelClientConfig(ModelClientConfig.BuilderImpl modelClientConfig) {
            this.modelClientConfig = modelClientConfig != null ? modelClientConfig.build() : null;
        }

        public final Integer getMaxPayloadInMB() {
            return maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        public final String getBatchStrategy() {
            return batchStrategy;
        }

        @Override
        public final Builder batchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Override
        public final Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy(batchStrategy == null ? null : batchStrategy.toString());
            return this;
        }

        public final void setBatchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
        }

        public final TransformInput.Builder getTransformInput() {
            return transformInput != null ? transformInput.toBuilder() : null;
        }

        @Override
        public final Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public final void setTransformInput(TransformInput.BuilderImpl transformInput) {
            this.transformInput = transformInput != null ? transformInput.build() : null;
        }

        public final TransformOutput.Builder getTransformOutput() {
            return transformOutput != null ? transformOutput.toBuilder() : null;
        }

        @Override
        public final Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public final void setTransformOutput(TransformOutput.BuilderImpl transformOutput) {
            this.transformOutput = transformOutput != null ? transformOutput.build() : null;
        }

        public final TransformResources.Builder getTransformResources() {
            return transformResources != null ? transformResources.toBuilder() : null;
        }

        @Override
        public final Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public final void setTransformResources(TransformResources.BuilderImpl transformResources) {
            this.transformResources = transformResources != null ? transformResources.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTransformStartTime() {
            return transformStartTime;
        }

        @Override
        public final Builder transformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
            return this;
        }

        public final void setTransformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
        }

        public final Instant getTransformEndTime() {
            return transformEndTime;
        }

        @Override
        public final Builder transformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
            return this;
        }

        public final void setTransformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
        }

        public final String getLabelingJobArn() {
            return labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        public final String getAutoMLJobArn() {
            return autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final DataProcessing.Builder getDataProcessing() {
            return dataProcessing != null ? dataProcessing.toBuilder() : null;
        }

        @Override
        public final Builder dataProcessing(DataProcessing dataProcessing) {
            this.dataProcessing = dataProcessing;
            return this;
        }

        public final void setDataProcessing(DataProcessing.BuilderImpl dataProcessing) {
            this.dataProcessing = dataProcessing != null ? dataProcessing.build() : null;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return experimentConfig != null ? experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public DescribeTransformJobResponse build() {
            return new DescribeTransformJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
