/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the properties of an experiment. To get the complete set of properties, call the
 * <a>DescribeExperiment</a> API and provide the <code>ExperimentName</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentSummary.Builder, ExperimentSummary> {
    private static final SdkField<String> EXPERIMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentArn").getter(getter(ExperimentSummary::experimentArn)).setter(setter(Builder::experimentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentArn").build()).build();

    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentName").getter(getter(ExperimentSummary::experimentName))
            .setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(ExperimentSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<ExperimentSource> EXPERIMENT_SOURCE_FIELD = SdkField
            .<ExperimentSource> builder(MarshallingType.SDK_POJO).memberName("ExperimentSource")
            .getter(getter(ExperimentSummary::experimentSource)).setter(setter(Builder::experimentSource))
            .constructor(ExperimentSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentSource").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ExperimentSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ExperimentSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ARN_FIELD,
            EXPERIMENT_NAME_FIELD, DISPLAY_NAME_FIELD, EXPERIMENT_SOURCE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String experimentArn;

    private final String experimentName;

    private final String displayName;

    private final ExperimentSource experimentSource;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private ExperimentSummary(BuilderImpl builder) {
        this.experimentArn = builder.experimentArn;
        this.experimentName = builder.experimentName;
        this.displayName = builder.displayName;
        this.experimentSource = builder.experimentSource;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the experiment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the experiment.
     */
    public String experimentArn() {
        return experimentArn;
    }

    /**
     * <p>
     * The name of the experiment.
     * </p>
     * 
     * @return The name of the experiment.
     */
    public String experimentName() {
        return experimentName;
    }

    /**
     * <p>
     * The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code>
     * is displayed.
     * </p>
     * 
     * @return The name of the experiment as displayed. If <code>DisplayName</code> isn't specified,
     *         <code>ExperimentName</code> is displayed.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the ExperimentSource property for this object.
     * 
     * @return The value of the ExperimentSource property for this object.
     */
    public ExperimentSource experimentSource() {
        return experimentSource;
    }

    /**
     * <p>
     * When the experiment was created.
     * </p>
     * 
     * @return When the experiment was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the experiment was last modified.
     * </p>
     * 
     * @return When the experiment was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(experimentArn());
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(experimentSource());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentSummary)) {
            return false;
        }
        ExperimentSummary other = (ExperimentSummary) obj;
        return Objects.equals(experimentArn(), other.experimentArn()) && Objects.equals(experimentName(), other.experimentName())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(experimentSource(), other.experimentSource())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExperimentSummary").add("ExperimentArn", experimentArn())
                .add("ExperimentName", experimentName()).add("DisplayName", displayName())
                .add("ExperimentSource", experimentSource()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExperimentArn":
            return Optional.ofNullable(clazz.cast(experimentArn()));
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ExperimentSource":
            return Optional.ofNullable(clazz.cast(experimentSource()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentSummary, T> g) {
        return obj -> g.apply((ExperimentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the experiment.
         * </p>
         * 
         * @param experimentArn
         *        The Amazon Resource Name (ARN) of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentArn(String experimentArn);

        /**
         * <p>
         * The name of the experiment.
         * </p>
         * 
         * @param experimentName
         *        The name of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * <p>
         * The name of the experiment as displayed. If <code>DisplayName</code> isn't specified,
         * <code>ExperimentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the experiment as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>ExperimentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the ExperimentSource property for this object.
         *
         * @param experimentSource
         *        The new value for the ExperimentSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentSource(ExperimentSource experimentSource);

        /**
         * Sets the value of the ExperimentSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExperimentSource.Builder} avoiding the need to
         * create one manually via {@link ExperimentSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentSource.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentSource(ExperimentSource)}.
         * 
         * @param experimentSource
         *        a consumer that will call methods on {@link ExperimentSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentSource(ExperimentSource)
         */
        default Builder experimentSource(Consumer<ExperimentSource.Builder> experimentSource) {
            return experimentSource(ExperimentSource.builder().applyMutation(experimentSource).build());
        }

        /**
         * <p>
         * When the experiment was created.
         * </p>
         * 
         * @param creationTime
         *        When the experiment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the experiment was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the experiment was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String experimentArn;

        private String experimentName;

        private String displayName;

        private ExperimentSource experimentSource;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentSummary model) {
            experimentArn(model.experimentArn);
            experimentName(model.experimentName);
            displayName(model.displayName);
            experimentSource(model.experimentSource);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getExperimentArn() {
            return experimentArn;
        }

        @Override
        public final Builder experimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
            return this;
        }

        public final void setExperimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
        }

        public final String getExperimentName() {
            return experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final ExperimentSource.Builder getExperimentSource() {
            return experimentSource != null ? experimentSource.toBuilder() : null;
        }

        @Override
        public final Builder experimentSource(ExperimentSource experimentSource) {
            this.experimentSource = experimentSource;
            return this;
        }

        public final void setExperimentSource(ExperimentSource.BuilderImpl experimentSource) {
            this.experimentSource = experimentSource != null ? experimentSource.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public ExperimentSummary build() {
            return new ExperimentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
