/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for auto-labeling of your data objects. A <code>LabelingJobAlgorithmsConfig</code>
 * object must be supplied in order to use auto-labeling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobAlgorithmsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobAlgorithmsConfig.Builder, LabelingJobAlgorithmsConfig> {
    private static final SdkField<String> LABELING_JOB_ALGORITHM_SPECIFICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LabelingJobAlgorithmSpecificationArn")
            .getter(getter(LabelingJobAlgorithmsConfig::labelingJobAlgorithmSpecificationArn))
            .setter(setter(Builder::labelingJobAlgorithmSpecificationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LabelingJobAlgorithmSpecificationArn").build()).build();

    private static final SdkField<String> INITIAL_ACTIVE_LEARNING_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InitialActiveLearningModelArn")
            .getter(getter(LabelingJobAlgorithmsConfig::initialActiveLearningModelArn))
            .setter(setter(Builder::initialActiveLearningModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialActiveLearningModelArn")
                    .build()).build();

    private static final SdkField<LabelingJobResourceConfig> LABELING_JOB_RESOURCE_CONFIG_FIELD = SdkField
            .<LabelingJobResourceConfig> builder(MarshallingType.SDK_POJO).memberName("LabelingJobResourceConfig")
            .getter(getter(LabelingJobAlgorithmsConfig::labelingJobResourceConfig))
            .setter(setter(Builder::labelingJobResourceConfig)).constructor(LabelingJobResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobResourceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LABELING_JOB_ALGORITHM_SPECIFICATION_ARN_FIELD, INITIAL_ACTIVE_LEARNING_MODEL_ARN_FIELD,
            LABELING_JOB_RESOURCE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String labelingJobAlgorithmSpecificationArn;

    private final String initialActiveLearningModelArn;

    private final LabelingJobResourceConfig labelingJobResourceConfig;

    private LabelingJobAlgorithmsConfig(BuilderImpl builder) {
        this.labelingJobAlgorithmSpecificationArn = builder.labelingJobAlgorithmSpecificationArn;
        this.initialActiveLearningModelArn = builder.initialActiveLearningModelArn;
        this.labelingJobResourceConfig = builder.labelingJobResourceConfig;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the
     * following ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Image classification</i>
     * </p>
     * <p>
     * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Text classification</i>
     * </p>
     * <p>
     * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Object detection</i>
     * </p>
     * <p>
     * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Semantic Segmentation</i>
     * </p>
     * <p>
     * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of
     *         the following ARNs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Image classification</i>
     *         </p>
     *         <p>
     *         <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Text classification</i>
     *         </p>
     *         <p>
     *         <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Object detection</i>
     *         </p>
     *         <p>
     *         <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Semantic Segmentation</i>
     *         </p>
     *         <p>
     *         <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code>
     *         </p>
     *         </li>
     */
    public String labelingJobAlgorithmSpecificationArn() {
        return labelingJobAlgorithmSpecificationArn;
    }

    /**
     * <p>
     * At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used for
     * auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN of
     * the model here.
     * </p>
     * 
     * @return At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used
     *         for auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing
     *         the ARN of the model here.
     */
    public String initialActiveLearningModelArn() {
        return initialActiveLearningModelArn;
    }

    /**
     * <p>
     * Provides configuration information for a labeling job.
     * </p>
     * 
     * @return Provides configuration information for a labeling job.
     */
    public LabelingJobResourceConfig labelingJobResourceConfig() {
        return labelingJobResourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobAlgorithmSpecificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(initialActiveLearningModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobResourceConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobAlgorithmsConfig)) {
            return false;
        }
        LabelingJobAlgorithmsConfig other = (LabelingJobAlgorithmsConfig) obj;
        return Objects.equals(labelingJobAlgorithmSpecificationArn(), other.labelingJobAlgorithmSpecificationArn())
                && Objects.equals(initialActiveLearningModelArn(), other.initialActiveLearningModelArn())
                && Objects.equals(labelingJobResourceConfig(), other.labelingJobResourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LabelingJobAlgorithmsConfig")
                .add("LabelingJobAlgorithmSpecificationArn", labelingJobAlgorithmSpecificationArn())
                .add("InitialActiveLearningModelArn", initialActiveLearningModelArn())
                .add("LabelingJobResourceConfig", labelingJobResourceConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobAlgorithmSpecificationArn":
            return Optional.ofNullable(clazz.cast(labelingJobAlgorithmSpecificationArn()));
        case "InitialActiveLearningModelArn":
            return Optional.ofNullable(clazz.cast(initialActiveLearningModelArn()));
        case "LabelingJobResourceConfig":
            return Optional.ofNullable(clazz.cast(labelingJobResourceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobAlgorithmsConfig, T> g) {
        return obj -> g.apply((LabelingJobAlgorithmsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobAlgorithmsConfig> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the
         * following ARNs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Image classification</i>
         * </p>
         * <p>
         * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Text classification</i>
         * </p>
         * <p>
         * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Object detection</i>
         * </p>
         * <p>
         * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Semantic Segmentation</i>
         * </p>
         * <p>
         * <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param labelingJobAlgorithmSpecificationArn
         *        Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one
         *        of the following ARNs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Image classification</i>
         *        </p>
         *        <p>
         *        <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Text classification</i>
         *        </p>
         *        <p>
         *        <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Object detection</i>
         *        </p>
         *        <p>
         *        <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Semantic Segmentation</i>
         *        </p>
         *        <p>
         *        <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobAlgorithmSpecificationArn(String labelingJobAlgorithmSpecificationArn);

        /**
         * <p>
         * At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used for
         * auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN
         * of the model here.
         * </p>
         * 
         * @param initialActiveLearningModelArn
         *        At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model
         *        used for auto-labeling. You can use this model as the starting point for subsequent similar jobs by
         *        providing the ARN of the model here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialActiveLearningModelArn(String initialActiveLearningModelArn);

        /**
         * <p>
         * Provides configuration information for a labeling job.
         * </p>
         * 
         * @param labelingJobResourceConfig
         *        Provides configuration information for a labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobResourceConfig(LabelingJobResourceConfig labelingJobResourceConfig);

        /**
         * <p>
         * Provides configuration information for a labeling job.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelingJobResourceConfig.Builder} avoiding the
         * need to create one manually via {@link LabelingJobResourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobResourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #labelingJobResourceConfig(LabelingJobResourceConfig)}.
         * 
         * @param labelingJobResourceConfig
         *        a consumer that will call methods on {@link LabelingJobResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingJobResourceConfig(LabelingJobResourceConfig)
         */
        default Builder labelingJobResourceConfig(Consumer<LabelingJobResourceConfig.Builder> labelingJobResourceConfig) {
            return labelingJobResourceConfig(LabelingJobResourceConfig.builder().applyMutation(labelingJobResourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String labelingJobAlgorithmSpecificationArn;

        private String initialActiveLearningModelArn;

        private LabelingJobResourceConfig labelingJobResourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobAlgorithmsConfig model) {
            labelingJobAlgorithmSpecificationArn(model.labelingJobAlgorithmSpecificationArn);
            initialActiveLearningModelArn(model.initialActiveLearningModelArn);
            labelingJobResourceConfig(model.labelingJobResourceConfig);
        }

        public final String getLabelingJobAlgorithmSpecificationArn() {
            return labelingJobAlgorithmSpecificationArn;
        }

        @Override
        public final Builder labelingJobAlgorithmSpecificationArn(String labelingJobAlgorithmSpecificationArn) {
            this.labelingJobAlgorithmSpecificationArn = labelingJobAlgorithmSpecificationArn;
            return this;
        }

        public final void setLabelingJobAlgorithmSpecificationArn(String labelingJobAlgorithmSpecificationArn) {
            this.labelingJobAlgorithmSpecificationArn = labelingJobAlgorithmSpecificationArn;
        }

        public final String getInitialActiveLearningModelArn() {
            return initialActiveLearningModelArn;
        }

        @Override
        public final Builder initialActiveLearningModelArn(String initialActiveLearningModelArn) {
            this.initialActiveLearningModelArn = initialActiveLearningModelArn;
            return this;
        }

        public final void setInitialActiveLearningModelArn(String initialActiveLearningModelArn) {
            this.initialActiveLearningModelArn = initialActiveLearningModelArn;
        }

        public final LabelingJobResourceConfig.Builder getLabelingJobResourceConfig() {
            return labelingJobResourceConfig != null ? labelingJobResourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder labelingJobResourceConfig(LabelingJobResourceConfig labelingJobResourceConfig) {
            this.labelingJobResourceConfig = labelingJobResourceConfig;
            return this;
        }

        public final void setLabelingJobResourceConfig(LabelingJobResourceConfig.BuilderImpl labelingJobResourceConfig) {
            this.labelingJobResourceConfig = labelingJobResourceConfig != null ? labelingJobResourceConfig.build() : null;
        }

        @Override
        public LabelingJobAlgorithmsConfig build() {
            return new LabelingJobAlgorithmsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
