/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsSource implements SdkPojo, Serializable, ToCopyableBuilder<MetricsSource.Builder, MetricsSource> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(MetricsSource::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> CONTENT_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentDigest").getter(getter(MetricsSource::contentDigest)).setter(setter(Builder::contentDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDigest").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(MetricsSource::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_DIGEST_FIELD, S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentType;

    private final String contentDigest;

    private final String s3Uri;

    private MetricsSource(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.contentDigest = builder.contentDigest;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentDigest() {
        return contentDigest;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(contentDigest());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsSource)) {
            return false;
        }
        MetricsSource other = (MetricsSource) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(contentDigest(), other.contentDigest())
                && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MetricsSource").add("ContentType", contentType()).add("ContentDigest", contentDigest())
                .add("S3Uri", s3Uri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "ContentDigest":
            return Optional.ofNullable(clazz.cast(contentDigest()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricsSource, T> g) {
        return obj -> g.apply((MetricsSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsSource> {
        /**
         * <p/>
         * 
         * @param contentType
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p/>
         * 
         * @param contentDigest
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDigest(String contentDigest);

        /**
         * <p/>
         * 
         * @param s3Uri
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String contentType;

        private String contentDigest;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsSource model) {
            contentType(model.contentType);
            contentDigest(model.contentDigest);
            s3Uri(model.s3Uri);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContentDigest() {
            return contentDigest;
        }

        @Override
        public final Builder contentDigest(String contentDigest) {
            this.contentDigest = contentDigest;
            return this;
        }

        public final void setContentDigest(String contentDigest) {
            this.contentDigest = contentDigest;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public MetricsSource build() {
            return new MetricsSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
