/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a model group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackageGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackageGroupSummary.Builder, ModelPackageGroupSummary> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupName").getter(getter(ModelPackageGroupSummary::modelPackageGroupName))
            .setter(setter(Builder::modelPackageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupArn").getter(getter(ModelPackageGroupSummary::modelPackageGroupArn))
            .setter(setter(Builder::modelPackageGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupArn").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupDescription")
            .getter(getter(ModelPackageGroupSummary::modelPackageGroupDescription))
            .setter(setter(Builder::modelPackageGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupDescription")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelPackageGroupSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupStatus").getter(getter(ModelPackageGroupSummary::modelPackageGroupStatusAsString))
            .setter(setter(Builder::modelPackageGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_GROUP_ARN_FIELD, MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD,
            CREATION_TIME_FIELD, MODEL_PACKAGE_GROUP_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelPackageGroupName;

    private final String modelPackageGroupArn;

    private final String modelPackageGroupDescription;

    private final Instant creationTime;

    private final String modelPackageGroupStatus;

    private ModelPackageGroupSummary(BuilderImpl builder) {
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageGroupArn = builder.modelPackageGroupArn;
        this.modelPackageGroupDescription = builder.modelPackageGroupDescription;
        this.creationTime = builder.creationTime;
        this.modelPackageGroupStatus = builder.modelPackageGroupStatus;
    }

    /**
     * <p>
     * The name of the model group.
     * </p>
     * 
     * @return The name of the model group.
     */
    public String modelPackageGroupName() {
        return modelPackageGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model group.
     */
    public String modelPackageGroupArn() {
        return modelPackageGroupArn;
    }

    /**
     * <p>
     * A description of the model group.
     * </p>
     * 
     * @return A description of the model group.
     */
    public String modelPackageGroupDescription() {
        return modelPackageGroupDescription;
    }

    /**
     * <p>
     * The time that the model group was created.
     * </p>
     * 
     * @return The time that the model group was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The status of the model group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageGroupStatus} will return {@link ModelPackageGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelPackageGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the model group.
     * @see ModelPackageGroupStatus
     */
    public ModelPackageGroupStatus modelPackageGroupStatus() {
        return ModelPackageGroupStatus.fromValue(modelPackageGroupStatus);
    }

    /**
     * <p>
     * The status of the model group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageGroupStatus} will return {@link ModelPackageGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelPackageGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the model group.
     * @see ModelPackageGroupStatus
     */
    public String modelPackageGroupStatusAsString() {
        return modelPackageGroupStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageGroupSummary)) {
            return false;
        }
        ModelPackageGroupSummary other = (ModelPackageGroupSummary) obj;
        return Objects.equals(modelPackageGroupName(), other.modelPackageGroupName())
                && Objects.equals(modelPackageGroupArn(), other.modelPackageGroupArn())
                && Objects.equals(modelPackageGroupDescription(), other.modelPackageGroupDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modelPackageGroupStatusAsString(), other.modelPackageGroupStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelPackageGroupSummary").add("ModelPackageGroupName", modelPackageGroupName())
                .add("ModelPackageGroupArn", modelPackageGroupArn())
                .add("ModelPackageGroupDescription", modelPackageGroupDescription()).add("CreationTime", creationTime())
                .add("ModelPackageGroupStatus", modelPackageGroupStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageGroupName":
            return Optional.ofNullable(clazz.cast(modelPackageGroupName()));
        case "ModelPackageGroupArn":
            return Optional.ofNullable(clazz.cast(modelPackageGroupArn()));
        case "ModelPackageGroupDescription":
            return Optional.ofNullable(clazz.cast(modelPackageGroupDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModelPackageGroupStatus":
            return Optional.ofNullable(clazz.cast(modelPackageGroupStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageGroupSummary, T> g) {
        return obj -> g.apply((ModelPackageGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackageGroupSummary> {
        /**
         * <p>
         * The name of the model group.
         * </p>
         * 
         * @param modelPackageGroupName
         *        The name of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupName(String modelPackageGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model group.
         * </p>
         * 
         * @param modelPackageGroupArn
         *        The Amazon Resource Name (ARN) of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupArn(String modelPackageGroupArn);

        /**
         * <p>
         * A description of the model group.
         * </p>
         * 
         * @param modelPackageGroupDescription
         *        A description of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupDescription(String modelPackageGroupDescription);

        /**
         * <p>
         * The time that the model group was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the model group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The status of the model group.
         * </p>
         * 
         * @param modelPackageGroupStatus
         *        The status of the model group.
         * @see ModelPackageGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageGroupStatus
         */
        Builder modelPackageGroupStatus(String modelPackageGroupStatus);

        /**
         * <p>
         * The status of the model group.
         * </p>
         * 
         * @param modelPackageGroupStatus
         *        The status of the model group.
         * @see ModelPackageGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageGroupStatus
         */
        Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus);
    }

    static final class BuilderImpl implements Builder {
        private String modelPackageGroupName;

        private String modelPackageGroupArn;

        private String modelPackageGroupDescription;

        private Instant creationTime;

        private String modelPackageGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageGroupSummary model) {
            modelPackageGroupName(model.modelPackageGroupName);
            modelPackageGroupArn(model.modelPackageGroupArn);
            modelPackageGroupDescription(model.modelPackageGroupDescription);
            creationTime(model.creationTime);
            modelPackageGroupStatus(model.modelPackageGroupStatus);
        }

        public final String getModelPackageGroupName() {
            return modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        public final String getModelPackageGroupArn() {
            return modelPackageGroupArn;
        }

        @Override
        public final Builder modelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
            return this;
        }

        public final void setModelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
        }

        public final String getModelPackageGroupDescription() {
            return modelPackageGroupDescription;
        }

        @Override
        public final Builder modelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
            return this;
        }

        public final void setModelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModelPackageGroupStatus() {
            return modelPackageGroupStatus;
        }

        @Override
        public final Builder modelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
            return this;
        }

        @Override
        public final Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus) {
            this.modelPackageGroupStatus(modelPackageGroupStatus == null ? null : modelPackageGroupStatus.toString());
            return this;
        }

        public final void setModelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
        }

        @Override
        public ModelPackageGroupSummary build() {
            return new ModelPackageGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
