/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the maximum number of training jobs and parallel training jobs that a hyperparameter tuning job can launch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceLimits implements SdkPojo, Serializable, ToCopyableBuilder<ResourceLimits.Builder, ResourceLimits> {
    private static final SdkField<Integer> MAX_NUMBER_OF_TRAINING_JOBS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxNumberOfTrainingJobs")
            .getter(getter(ResourceLimits::maxNumberOfTrainingJobs)).setter(setter(Builder::maxNumberOfTrainingJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfTrainingJobs").build())
            .build();

    private static final SdkField<Integer> MAX_PARALLEL_TRAINING_JOBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxParallelTrainingJobs").getter(getter(ResourceLimits::maxParallelTrainingJobs))
            .setter(setter(Builder::maxParallelTrainingJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxParallelTrainingJobs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_NUMBER_OF_TRAINING_JOBS_FIELD, MAX_PARALLEL_TRAINING_JOBS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxNumberOfTrainingJobs;

    private final Integer maxParallelTrainingJobs;

    private ResourceLimits(BuilderImpl builder) {
        this.maxNumberOfTrainingJobs = builder.maxNumberOfTrainingJobs;
        this.maxParallelTrainingJobs = builder.maxParallelTrainingJobs;
    }

    /**
     * <p>
     * The maximum number of training jobs that a hyperparameter tuning job can launch.
     * </p>
     * 
     * @return The maximum number of training jobs that a hyperparameter tuning job can launch.
     */
    public Integer maxNumberOfTrainingJobs() {
        return maxNumberOfTrainingJobs;
    }

    /**
     * <p>
     * The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.
     * </p>
     * 
     * @return The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.
     */
    public Integer maxParallelTrainingJobs() {
        return maxParallelTrainingJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelTrainingJobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceLimits)) {
            return false;
        }
        ResourceLimits other = (ResourceLimits) obj;
        return Objects.equals(maxNumberOfTrainingJobs(), other.maxNumberOfTrainingJobs())
                && Objects.equals(maxParallelTrainingJobs(), other.maxParallelTrainingJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceLimits").add("MaxNumberOfTrainingJobs", maxNumberOfTrainingJobs())
                .add("MaxParallelTrainingJobs", maxParallelTrainingJobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxNumberOfTrainingJobs":
            return Optional.ofNullable(clazz.cast(maxNumberOfTrainingJobs()));
        case "MaxParallelTrainingJobs":
            return Optional.ofNullable(clazz.cast(maxParallelTrainingJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceLimits, T> g) {
        return obj -> g.apply((ResourceLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceLimits> {
        /**
         * <p>
         * The maximum number of training jobs that a hyperparameter tuning job can launch.
         * </p>
         * 
         * @param maxNumberOfTrainingJobs
         *        The maximum number of training jobs that a hyperparameter tuning job can launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfTrainingJobs(Integer maxNumberOfTrainingJobs);

        /**
         * <p>
         * The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.
         * </p>
         * 
         * @param maxParallelTrainingJobs
         *        The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelTrainingJobs(Integer maxParallelTrainingJobs);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxNumberOfTrainingJobs;

        private Integer maxParallelTrainingJobs;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceLimits model) {
            maxNumberOfTrainingJobs(model.maxNumberOfTrainingJobs);
            maxParallelTrainingJobs(model.maxParallelTrainingJobs);
        }

        public final Integer getMaxNumberOfTrainingJobs() {
            return maxNumberOfTrainingJobs;
        }

        @Override
        public final Builder maxNumberOfTrainingJobs(Integer maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
            return this;
        }

        public final void setMaxNumberOfTrainingJobs(Integer maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
        }

        public final Integer getMaxParallelTrainingJobs() {
            return maxParallelTrainingJobs;
        }

        @Override
        public final Builder maxParallelTrainingJobs(Integer maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
            return this;
        }

        public final void setMaxParallelTrainingJobs(Integer maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
        }

        @Override
        public ResourceLimits build() {
            return new ResourceLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
