/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the input source of a transform job and the way the transform job consumes it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformInput implements SdkPojo, Serializable, ToCopyableBuilder<TransformInput.Builder, TransformInput> {
    private static final SdkField<TransformDataSource> DATA_SOURCE_FIELD = SdkField
            .<TransformDataSource> builder(MarshallingType.SDK_POJO).memberName("DataSource")
            .getter(getter(TransformInput::dataSource)).setter(setter(Builder::dataSource))
            .constructor(TransformDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(TransformInput::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompressionType").getter(getter(TransformInput::compressionTypeAsString))
            .setter(setter(Builder::compressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()).build();

    private static final SdkField<String> SPLIT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SplitType").getter(getter(TransformInput::splitTypeAsString)).setter(setter(Builder::splitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            CONTENT_TYPE_FIELD, COMPRESSION_TYPE_FIELD, SPLIT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TransformDataSource dataSource;

    private final String contentType;

    private final String compressionType;

    private final String splitType;

    private TransformInput(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.contentType = builder.contentType;
        this.compressionType = builder.compressionType;
        this.splitType = builder.splitType;
    }

    /**
     * <p>
     * Describes the location of the channel data, which is, the S3 location of the input data that the model can
     * consume.
     * </p>
     * 
     * @return Describes the location of the channel data, which is, the S3 location of the input data that the model
     *         can consume.
     */
    public TransformDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each
     * http call to transfer data to the transform job.
     * </p>
     * 
     * @return The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type
     *         with each http call to transfer data to the transform job.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses
     * the data for the transform job accordingly. The default value is <code>None</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return If your transform data is compressed, specify the compression type. Amazon SageMaker automatically
     *         decompresses the data for the transform job accordingly. The default value is <code>None</code>.
     * @see CompressionType
     */
    public CompressionType compressionType() {
        return CompressionType.fromValue(compressionType);
    }

    /**
     * <p>
     * If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses
     * the data for the transform job accordingly. The default value is <code>None</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return If your transform data is compressed, specify the compression type. Amazon SageMaker automatically
     *         decompresses the data for the transform job accordingly. The default value is <code>None</code>.
     * @see CompressionType
     */
    public String compressionTypeAsString() {
        return compressionType;
    }

    /**
     * <p>
     * The method to use to split the transform job's data files into smaller batches. Splitting is necessary when the
     * total size of each object is too large to fit in a single request. You can also use data splitting to improve
     * performance by processing multiple concurrent mini-batches. The default value for <code>SplitType</code> is
     * <code>None</code>, which indicates that input data files are not split, and request payloads contain the entire
     * contents of an input object. Set the value of this parameter to <code>Line</code> to split records on a newline
     * character boundary. <code>SplitType</code> also supports a number of record-oriented binary data formats.
     * Currently, the supported record formats are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RecordIO
     * </p>
     * </li>
     * <li>
     * <p>
     * TFRecord
     * </p>
     * </li>
     * </ul>
     * <p>
     * When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code> and
     * <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is <code>MultiRecord</code>,
     * Amazon SageMaker sends the maximum number of records in each request, up to the <code>MaxPayloadInMB</code>
     * limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual
     * records in each request.
     * </p>
     * <note>
     * <p>
     * Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is
     * applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to
     * <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to
     * <code>MultiRecord</code>.
     * </p>
     * <p>
     * For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create
     * a Dataset Using RecordIO</a> in the MXNet documentation. For more information about <code>TFRecord</code>, see <a
     * href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a> in the
     * TensorFlow documentation.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #splitType} will
     * return {@link SplitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #splitTypeAsString}.
     * </p>
     * 
     * @return The method to use to split the transform job's data files into smaller batches. Splitting is necessary
     *         when the total size of each object is too large to fit in a single request. You can also use data
     *         splitting to improve performance by processing multiple concurrent mini-batches. The default value for
     *         <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and
     *         request payloads contain the entire contents of an input object. Set the value of this parameter to
     *         <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also supports
     *         a number of record-oriented binary data formats. Currently, the supported record formats are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         RecordIO
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TFRecord
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When splitting is enabled, the size of a mini-batch depends on the values of the
     *         <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of
     *         <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of
     *         records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of
     *         <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual records in
     *         each request.
     *         </p>
     *         <note>
     *         <p>
     *         Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting
     *         is applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set
     *         to <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to
     *         <code>MultiRecord</code>.
     *         </p>
     *         <p>
     *         For more information about <code>RecordIO</code>, see <a
     *         href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet
     *         documentation. For more information about <code>TFRecord</code>, see <a
     *         href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a> in
     *         the TensorFlow documentation.
     *         </p>
     * @see SplitType
     */
    public SplitType splitType() {
        return SplitType.fromValue(splitType);
    }

    /**
     * <p>
     * The method to use to split the transform job's data files into smaller batches. Splitting is necessary when the
     * total size of each object is too large to fit in a single request. You can also use data splitting to improve
     * performance by processing multiple concurrent mini-batches. The default value for <code>SplitType</code> is
     * <code>None</code>, which indicates that input data files are not split, and request payloads contain the entire
     * contents of an input object. Set the value of this parameter to <code>Line</code> to split records on a newline
     * character boundary. <code>SplitType</code> also supports a number of record-oriented binary data formats.
     * Currently, the supported record formats are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RecordIO
     * </p>
     * </li>
     * <li>
     * <p>
     * TFRecord
     * </p>
     * </li>
     * </ul>
     * <p>
     * When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code> and
     * <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is <code>MultiRecord</code>,
     * Amazon SageMaker sends the maximum number of records in each request, up to the <code>MaxPayloadInMB</code>
     * limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual
     * records in each request.
     * </p>
     * <note>
     * <p>
     * Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is
     * applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to
     * <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to
     * <code>MultiRecord</code>.
     * </p>
     * <p>
     * For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create
     * a Dataset Using RecordIO</a> in the MXNet documentation. For more information about <code>TFRecord</code>, see <a
     * href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a> in the
     * TensorFlow documentation.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #splitType} will
     * return {@link SplitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #splitTypeAsString}.
     * </p>
     * 
     * @return The method to use to split the transform job's data files into smaller batches. Splitting is necessary
     *         when the total size of each object is too large to fit in a single request. You can also use data
     *         splitting to improve performance by processing multiple concurrent mini-batches. The default value for
     *         <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and
     *         request payloads contain the entire contents of an input object. Set the value of this parameter to
     *         <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also supports
     *         a number of record-oriented binary data formats. Currently, the supported record formats are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         RecordIO
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TFRecord
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When splitting is enabled, the size of a mini-batch depends on the values of the
     *         <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of
     *         <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of
     *         records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of
     *         <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual records in
     *         each request.
     *         </p>
     *         <note>
     *         <p>
     *         Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting
     *         is applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set
     *         to <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to
     *         <code>MultiRecord</code>.
     *         </p>
     *         <p>
     *         For more information about <code>RecordIO</code>, see <a
     *         href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet
     *         documentation. For more information about <code>TFRecord</code>, see <a
     *         href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a> in
     *         the TensorFlow documentation.
     *         </p>
     * @see SplitType
     */
    public String splitTypeAsString() {
        return splitType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(splitTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformInput)) {
            return false;
        }
        TransformInput other = (TransformInput) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(compressionTypeAsString(), other.compressionTypeAsString())
                && Objects.equals(splitTypeAsString(), other.splitTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransformInput").add("DataSource", dataSource()).add("ContentType", contentType())
                .add("CompressionType", compressionTypeAsString()).add("SplitType", splitTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "CompressionType":
            return Optional.ofNullable(clazz.cast(compressionTypeAsString()));
        case "SplitType":
            return Optional.ofNullable(clazz.cast(splitTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformInput, T> g) {
        return obj -> g.apply((TransformInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformInput> {
        /**
         * <p>
         * Describes the location of the channel data, which is, the S3 location of the input data that the model can
         * consume.
         * </p>
         * 
         * @param dataSource
         *        Describes the location of the channel data, which is, the S3 location of the input data that the model
         *        can consume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(TransformDataSource dataSource);

        /**
         * <p>
         * Describes the location of the channel data, which is, the S3 location of the input data that the model can
         * consume.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformDataSource.Builder} avoiding the need
         * to create one manually via {@link TransformDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformDataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSource(TransformDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link TransformDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(TransformDataSource)
         */
        default Builder dataSource(Consumer<TransformDataSource.Builder> dataSource) {
            return dataSource(TransformDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with
         * each http call to transfer data to the transform job.
         * </p>
         * 
         * @param contentType
         *        The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type
         *        with each http call to transfer data to the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * If your transform data is compressed, specify the compression type. Amazon SageMaker automatically
         * decompresses the data for the transform job accordingly. The default value is <code>None</code>.
         * </p>
         * 
         * @param compressionType
         *        If your transform data is compressed, specify the compression type. Amazon SageMaker automatically
         *        decompresses the data for the transform job accordingly. The default value is <code>None</code>.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(String compressionType);

        /**
         * <p>
         * If your transform data is compressed, specify the compression type. Amazon SageMaker automatically
         * decompresses the data for the transform job accordingly. The default value is <code>None</code>.
         * </p>
         * 
         * @param compressionType
         *        If your transform data is compressed, specify the compression type. Amazon SageMaker automatically
         *        decompresses the data for the transform job accordingly. The default value is <code>None</code>.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(CompressionType compressionType);

        /**
         * <p>
         * The method to use to split the transform job's data files into smaller batches. Splitting is necessary when
         * the total size of each object is too large to fit in a single request. You can also use data splitting to
         * improve performance by processing multiple concurrent mini-batches. The default value for
         * <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and request
         * payloads contain the entire contents of an input object. Set the value of this parameter to <code>Line</code>
         * to split records on a newline character boundary. <code>SplitType</code> also supports a number of
         * record-oriented binary data formats. Currently, the supported record formats are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RecordIO
         * </p>
         * </li>
         * <li>
         * <p>
         * TFRecord
         * </p>
         * </li>
         * </ul>
         * <p>
         * When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code>
         * and <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is
         * <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of records in each request, up to the
         * <code>MaxPayloadInMB</code> limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code>,
         * Amazon SageMaker sends individual records in each request.
         * </p>
         * <note>
         * <p>
         * Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is
         * applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to
         * <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to
         * <code>MultiRecord</code>.
         * </p>
         * <p>
         * For more information about <code>RecordIO</code>, see <a
         * href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet
         * documentation. For more information about <code>TFRecord</code>, see <a
         * href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a> in the
         * TensorFlow documentation.
         * </p>
         * </note>
         * 
         * @param splitType
         *        The method to use to split the transform job's data files into smaller batches. Splitting is necessary
         *        when the total size of each object is too large to fit in a single request. You can also use data
         *        splitting to improve performance by processing multiple concurrent mini-batches. The default value for
         *        <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and
         *        request payloads contain the entire contents of an input object. Set the value of this parameter to
         *        <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also
         *        supports a number of record-oriented binary data formats. Currently, the supported record formats
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        RecordIO
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TFRecord
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When splitting is enabled, the size of a mini-batch depends on the values of the
         *        <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of
         *        <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of
         *        records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of
         *        <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual records in
         *        each request.
         *        </p>
         *        <note>
         *        <p>
         *        Some data formats represent a record as a binary payload wrapped with extra padding bytes. When
         *        splitting is applied to a binary data format, padding is removed if the value of
         *        <code>BatchStrategy</code> is set to <code>SingleRecord</code>. Padding is not removed if the value of
         *        <code>BatchStrategy</code> is set to <code>MultiRecord</code>.
         *        </p>
         *        <p>
         *        For more information about <code>RecordIO</code>, see <a
         *        href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet
         *        documentation. For more information about <code>TFRecord</code>, see <a
         *        href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a>
         *        in the TensorFlow documentation.
         *        </p>
         * @see SplitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SplitType
         */
        Builder splitType(String splitType);

        /**
         * <p>
         * The method to use to split the transform job's data files into smaller batches. Splitting is necessary when
         * the total size of each object is too large to fit in a single request. You can also use data splitting to
         * improve performance by processing multiple concurrent mini-batches. The default value for
         * <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and request
         * payloads contain the entire contents of an input object. Set the value of this parameter to <code>Line</code>
         * to split records on a newline character boundary. <code>SplitType</code> also supports a number of
         * record-oriented binary data formats. Currently, the supported record formats are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RecordIO
         * </p>
         * </li>
         * <li>
         * <p>
         * TFRecord
         * </p>
         * </li>
         * </ul>
         * <p>
         * When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code>
         * and <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is
         * <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of records in each request, up to the
         * <code>MaxPayloadInMB</code> limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code>,
         * Amazon SageMaker sends individual records in each request.
         * </p>
         * <note>
         * <p>
         * Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is
         * applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to
         * <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to
         * <code>MultiRecord</code>.
         * </p>
         * <p>
         * For more information about <code>RecordIO</code>, see <a
         * href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet
         * documentation. For more information about <code>TFRecord</code>, see <a
         * href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a> in the
         * TensorFlow documentation.
         * </p>
         * </note>
         * 
         * @param splitType
         *        The method to use to split the transform job's data files into smaller batches. Splitting is necessary
         *        when the total size of each object is too large to fit in a single request. You can also use data
         *        splitting to improve performance by processing multiple concurrent mini-batches. The default value for
         *        <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and
         *        request payloads contain the entire contents of an input object. Set the value of this parameter to
         *        <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also
         *        supports a number of record-oriented binary data formats. Currently, the supported record formats
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        RecordIO
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TFRecord
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When splitting is enabled, the size of a mini-batch depends on the values of the
         *        <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of
         *        <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of
         *        records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of
         *        <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual records in
         *        each request.
         *        </p>
         *        <note>
         *        <p>
         *        Some data formats represent a record as a binary payload wrapped with extra padding bytes. When
         *        splitting is applied to a binary data format, padding is removed if the value of
         *        <code>BatchStrategy</code> is set to <code>SingleRecord</code>. Padding is not removed if the value of
         *        <code>BatchStrategy</code> is set to <code>MultiRecord</code>.
         *        </p>
         *        <p>
         *        For more information about <code>RecordIO</code>, see <a
         *        href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet
         *        documentation. For more information about <code>TFRecord</code>, see <a
         *        href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a>
         *        in the TensorFlow documentation.
         *        </p>
         * @see SplitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SplitType
         */
        Builder splitType(SplitType splitType);
    }

    static final class BuilderImpl implements Builder {
        private TransformDataSource dataSource;

        private String contentType;

        private String compressionType;

        private String splitType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformInput model) {
            dataSource(model.dataSource);
            contentType(model.contentType);
            compressionType(model.compressionType);
            splitType(model.splitType);
        }

        public final TransformDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(TransformDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(TransformDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getCompressionType() {
            return compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public final String getSplitType() {
            return splitType;
        }

        @Override
        public final Builder splitType(String splitType) {
            this.splitType = splitType;
            return this;
        }

        @Override
        public final Builder splitType(SplitType splitType) {
            this.splitType(splitType == null ? null : splitType.toString());
            return this;
        }

        public final void setSplitType(String splitType) {
            this.splitType = splitType;
        }

        @Override
        public TransformInput build() {
            return new TransformInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
