/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContextRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateContextRequest.Builder, CreateContextRequest> {
    private static final SdkField<String> CONTEXT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextName").getter(getter(CreateContextRequest::contextName)).setter(setter(Builder::contextName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextName").build()).build();

    private static final SdkField<ContextSource> SOURCE_FIELD = SdkField.<ContextSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(CreateContextRequest::source)).setter(setter(Builder::source))
            .constructor(ContextSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> CONTEXT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextType").getter(getter(CreateContextRequest::contextType)).setter(setter(Builder::contextType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateContextRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(CreateContextRequest::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateContextRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_NAME_FIELD,
            SOURCE_FIELD, CONTEXT_TYPE_FIELD, DESCRIPTION_FIELD, PROPERTIES_FIELD, TAGS_FIELD));

    private final String contextName;

    private final ContextSource source;

    private final String contextType;

    private final String description;

    private final Map<String, String> properties;

    private final List<Tag> tags;

    private CreateContextRequest(BuilderImpl builder) {
        super(builder);
        this.contextName = builder.contextName;
        this.source = builder.source;
        this.contextType = builder.contextType;
        this.description = builder.description;
        this.properties = builder.properties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the context. Must be unique to your account in an AWS Region.
     * </p>
     * 
     * @return The name of the context. Must be unique to your account in an AWS Region.
     */
    public final String contextName() {
        return contextName;
    }

    /**
     * <p>
     * The source type, ID, and URI.
     * </p>
     * 
     * @return The source type, ID, and URI.
     */
    public final ContextSource source() {
        return source;
    }

    /**
     * <p>
     * The context type.
     * </p>
     * 
     * @return The context type.
     */
    public final String contextType() {
        return contextType;
    }

    /**
     * <p>
     * The description of the context.
     * </p>
     * 
     * @return The description of the context.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Properties property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of properties to add to the context.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of properties to add to the context.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to apply to the context.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to apply to the context.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contextName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(contextType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContextRequest)) {
            return false;
        }
        CreateContextRequest other = (CreateContextRequest) obj;
        return Objects.equals(contextName(), other.contextName()) && Objects.equals(source(), other.source())
                && Objects.equals(contextType(), other.contextType()) && Objects.equals(description(), other.description())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContextRequest").add("ContextName", contextName()).add("Source", source())
                .add("ContextType", contextType()).add("Description", description())
                .add("Properties", hasProperties() ? properties() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextName":
            return Optional.ofNullable(clazz.cast(contextName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ContextType":
            return Optional.ofNullable(clazz.cast(contextType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContextRequest, T> g) {
        return obj -> g.apply((CreateContextRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContextRequest> {
        /**
         * <p>
         * The name of the context. Must be unique to your account in an AWS Region.
         * </p>
         * 
         * @param contextName
         *        The name of the context. Must be unique to your account in an AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextName(String contextName);

        /**
         * <p>
         * The source type, ID, and URI.
         * </p>
         * 
         * @param source
         *        The source type, ID, and URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ContextSource source);

        /**
         * <p>
         * The source type, ID, and URI.
         * </p>
         * This is a convenience that creates an instance of the {@link ContextSource.Builder} avoiding the need to
         * create one manually via {@link ContextSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContextSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ContextSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ContextSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ContextSource)
         */
        default Builder source(Consumer<ContextSource.Builder> source) {
            return source(ContextSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The context type.
         * </p>
         * 
         * @param contextType
         *        The context type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextType(String contextType);

        /**
         * <p>
         * The description of the context.
         * </p>
         * 
         * @param description
         *        The description of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of properties to add to the context.
         * </p>
         * 
         * @param properties
         *        A list of properties to add to the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * A list of tags to apply to the context.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to apply to the context.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to apply to the context.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String contextName;

        private ContextSource source;

        private String contextType;

        private String description;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContextRequest model) {
            super(model);
            contextName(model.contextName);
            source(model.source);
            contextType(model.contextType);
            description(model.description);
            properties(model.properties);
            tags(model.tags);
        }

        public final String getContextName() {
            return contextName;
        }

        @Override
        public final Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public final void setContextName(String contextName) {
            this.contextName = contextName;
        }

        public final ContextSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(ContextSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ContextSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getContextType() {
            return contextType;
        }

        @Override
        public final Builder contextType(String contextType) {
            this.contextType = contextType;
            return this;
        }

        public final void setContextType(String contextType) {
            this.contextType = contextType;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContextRequest build() {
            return new CreateContextRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
