/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for processing job outputs in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingS3Output implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingS3Output.Builder, ProcessingS3Output> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(ProcessingS3Output::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalPath").getter(getter(ProcessingS3Output::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final SdkField<String> S3_UPLOAD_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3UploadMode").getter(getter(ProcessingS3Output::s3UploadModeAsString))
            .setter(setter(Builder::s3UploadMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UploadMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            LOCAL_PATH_FIELD, S3_UPLOAD_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String localPath;

    private final String s3UploadMode;

    private ProcessingS3Output(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.localPath = builder.localPath;
        this.s3UploadMode = builder.s3UploadMode;
    }

    /**
     * <p>
     * A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of a processing
     * job.
     * </p>
     * 
     * @return A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of a
     *         processing job.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The local path to the Amazon S3 bucket where you want Amazon SageMaker to save the results of an processing job.
     * <code>LocalPath</code> is an absolute path to the input data.
     * </p>
     * 
     * @return The local path to the Amazon S3 bucket where you want Amazon SageMaker to save the results of an
     *         processing job. <code>LocalPath</code> is an absolute path to the input data.
     */
    public final String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Whether to upload the results of the processing job continuously or after the job completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3UploadMode} will
     * return {@link ProcessingS3UploadMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3UploadModeAsString}.
     * </p>
     * 
     * @return Whether to upload the results of the processing job continuously or after the job completes.
     * @see ProcessingS3UploadMode
     */
    public final ProcessingS3UploadMode s3UploadMode() {
        return ProcessingS3UploadMode.fromValue(s3UploadMode);
    }

    /**
     * <p>
     * Whether to upload the results of the processing job continuously or after the job completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3UploadMode} will
     * return {@link ProcessingS3UploadMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3UploadModeAsString}.
     * </p>
     * 
     * @return Whether to upload the results of the processing job continuously or after the job completes.
     * @see ProcessingS3UploadMode
     */
    public final String s3UploadModeAsString() {
        return s3UploadMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3UploadModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingS3Output)) {
            return false;
        }
        ProcessingS3Output other = (ProcessingS3Output) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(localPath(), other.localPath())
                && Objects.equals(s3UploadModeAsString(), other.s3UploadModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessingS3Output").add("S3Uri", s3Uri()).add("LocalPath", localPath())
                .add("S3UploadMode", s3UploadModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "S3UploadMode":
            return Optional.ofNullable(clazz.cast(s3UploadModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingS3Output, T> g) {
        return obj -> g.apply((ProcessingS3Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingS3Output> {
        /**
         * <p>
         * A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of a
         * processing job.
         * </p>
         * 
         * @param s3Uri
         *        A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of a
         *        processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The local path to the Amazon S3 bucket where you want Amazon SageMaker to save the results of an processing
         * job. <code>LocalPath</code> is an absolute path to the input data.
         * </p>
         * 
         * @param localPath
         *        The local path to the Amazon S3 bucket where you want Amazon SageMaker to save the results of an
         *        processing job. <code>LocalPath</code> is an absolute path to the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Whether to upload the results of the processing job continuously or after the job completes.
         * </p>
         * 
         * @param s3UploadMode
         *        Whether to upload the results of the processing job continuously or after the job completes.
         * @see ProcessingS3UploadMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3UploadMode
         */
        Builder s3UploadMode(String s3UploadMode);

        /**
         * <p>
         * Whether to upload the results of the processing job continuously or after the job completes.
         * </p>
         * 
         * @param s3UploadMode
         *        Whether to upload the results of the processing job continuously or after the job completes.
         * @see ProcessingS3UploadMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3UploadMode
         */
        Builder s3UploadMode(ProcessingS3UploadMode s3UploadMode);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String localPath;

        private String s3UploadMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingS3Output model) {
            s3Uri(model.s3Uri);
            localPath(model.localPath);
            s3UploadMode(model.s3UploadMode);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getLocalPath() {
            return localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3UploadMode() {
            return s3UploadMode;
        }

        @Override
        public final Builder s3UploadMode(String s3UploadMode) {
            this.s3UploadMode = s3UploadMode;
            return this;
        }

        @Override
        public final Builder s3UploadMode(ProcessingS3UploadMode s3UploadMode) {
            this.s3UploadMode(s3UploadMode == null ? null : s3UploadMode.toString());
            return this;
        }

        public final void setS3UploadMode(String s3UploadMode) {
            this.s3UploadMode = s3UploadMode;
        }

        @Override
        public ProcessingS3Output build() {
            return new ProcessingS3Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
