/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointConfigResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeEndpointConfigResponse.Builder, DescribeEndpointConfigResponse> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(DescribeEndpointConfigResponse::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<String> ENDPOINT_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigArn").getter(getter(DescribeEndpointConfigResponse::endpointConfigArn))
            .setter(setter(Builder::endpointConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigArn").build()).build();

    private static final SdkField<List<ProductionVariant>> PRODUCTION_VARIANTS_FIELD = SdkField
            .<List<ProductionVariant>> builder(MarshallingType.LIST)
            .memberName("ProductionVariants")
            .getter(getter(DescribeEndpointConfigResponse::productionVariants))
            .setter(setter(Builder::productionVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductionVariant> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductionVariant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataCaptureConfig> DATA_CAPTURE_CONFIG_FIELD = SdkField
            .<DataCaptureConfig> builder(MarshallingType.SDK_POJO).memberName("DataCaptureConfig")
            .getter(getter(DescribeEndpointConfigResponse::dataCaptureConfig)).setter(setter(Builder::dataCaptureConfig))
            .constructor(DataCaptureConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeEndpointConfigResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeEndpointConfigResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD,
            ENDPOINT_CONFIG_ARN_FIELD, PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD, KMS_KEY_ID_FIELD,
            CREATION_TIME_FIELD));

    private final String endpointConfigName;

    private final String endpointConfigArn;

    private final List<ProductionVariant> productionVariants;

    private final DataCaptureConfig dataCaptureConfig;

    private final String kmsKeyId;

    private final Instant creationTime;

    private DescribeEndpointConfigResponse(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.endpointConfigArn = builder.endpointConfigArn;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * Name of the Amazon SageMaker endpoint configuration.
     * </p>
     * 
     * @return Name of the Amazon SageMaker endpoint configuration.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint configuration.
     */
    public final String endpointConfigArn() {
        return endpointConfigArn;
    }

    /**
     * Returns true if the ProductionVariants property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProductionVariants() {
        return productionVariants != null && !(productionVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductionVariants()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this
     *         endpoint.
     */
    public final List<ProductionVariant> productionVariants() {
        return productionVariants;
    }

    /**
     * Returns the value of the DataCaptureConfig property for this object.
     * 
     * @return The value of the DataCaptureConfig property for this object.
     */
    public final DataCaptureConfig dataCaptureConfig() {
        return dataCaptureConfig;
    }

    /**
     * <p>
     * AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the
     * instance.
     * </p>
     * 
     * @return AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to
     *         the instance.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A timestamp that shows when the endpoint configuration was created.
     * </p>
     * 
     * @return A timestamp that shows when the endpoint configuration was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductionVariants() ? productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointConfigResponse)) {
            return false;
        }
        DescribeEndpointConfigResponse other = (DescribeEndpointConfigResponse) obj;
        return Objects.equals(endpointConfigName(), other.endpointConfigName())
                && Objects.equals(endpointConfigArn(), other.endpointConfigArn())
                && hasProductionVariants() == other.hasProductionVariants()
                && Objects.equals(productionVariants(), other.productionVariants())
                && Objects.equals(dataCaptureConfig(), other.dataCaptureConfig()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointConfigResponse").add("EndpointConfigName", endpointConfigName())
                .add("EndpointConfigArn", endpointConfigArn())
                .add("ProductionVariants", hasProductionVariants() ? productionVariants() : null)
                .add("DataCaptureConfig", dataCaptureConfig()).add("KmsKeyId", kmsKeyId()).add("CreationTime", creationTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "EndpointConfigArn":
            return Optional.ofNullable(clazz.cast(endpointConfigArn()));
        case "ProductionVariants":
            return Optional.ofNullable(clazz.cast(productionVariants()));
        case "DataCaptureConfig":
            return Optional.ofNullable(clazz.cast(dataCaptureConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointConfigResponse, T> g) {
        return obj -> g.apply((DescribeEndpointConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEndpointConfigResponse> {
        /**
         * <p>
         * Name of the Amazon SageMaker endpoint configuration.
         * </p>
         * 
         * @param endpointConfigName
         *        Name of the Amazon SageMaker endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint configuration.
         * </p>
         * 
         * @param endpointConfigArn
         *        The Amazon Resource Name (ARN) of the endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigArn(String endpointConfigArn);

        /**
         * <p>
         * An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         * endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(Collection<ProductionVariant> productionVariants);

        /**
         * <p>
         * An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         * endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(ProductionVariant... productionVariants);

        /**
         * <p>
         * An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         * endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductionVariant>.Builder} avoiding the
         * need to create one manually via {@link List<ProductionVariant>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductionVariant>.Builder#build()} is called immediately
         * and its result is passed to {@link #productionVariants(List<ProductionVariant>)}.
         * 
         * @param productionVariants
         *        a consumer that will call methods on {@link List<ProductionVariant>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionVariants(List<ProductionVariant>)
         */
        Builder productionVariants(Consumer<ProductionVariant.Builder>... productionVariants);

        /**
         * Sets the value of the DataCaptureConfig property for this object.
         *
         * @param dataCaptureConfig
         *        The new value for the DataCaptureConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCaptureConfig(DataCaptureConfig dataCaptureConfig);

        /**
         * Sets the value of the DataCaptureConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataCaptureConfig.Builder} avoiding the need to
         * create one manually via {@link DataCaptureConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCaptureConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataCaptureConfig(DataCaptureConfig)}.
         * 
         * @param dataCaptureConfig
         *        a consumer that will call methods on {@link DataCaptureConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCaptureConfig(DataCaptureConfig)
         */
        default Builder dataCaptureConfig(Consumer<DataCaptureConfig.Builder> dataCaptureConfig) {
            return dataCaptureConfig(DataCaptureConfig.builder().applyMutation(dataCaptureConfig).build());
        }

        /**
         * <p>
         * AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the
         * instance.
         * </p>
         * 
         * @param kmsKeyId
         *        AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached
         *        to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A timestamp that shows when the endpoint configuration was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the endpoint configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String endpointConfigName;

        private String endpointConfigArn;

        private List<ProductionVariant> productionVariants = DefaultSdkAutoConstructList.getInstance();

        private DataCaptureConfig dataCaptureConfig;

        private String kmsKeyId;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointConfigResponse model) {
            super(model);
            endpointConfigName(model.endpointConfigName);
            endpointConfigArn(model.endpointConfigArn);
            productionVariants(model.productionVariants);
            dataCaptureConfig(model.dataCaptureConfig);
            kmsKeyId(model.kmsKeyId);
            creationTime(model.creationTime);
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final String getEndpointConfigArn() {
            return endpointConfigArn;
        }

        @Override
        public final Builder endpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
            return this;
        }

        public final void setEndpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
        }

        public final Collection<ProductionVariant.Builder> getProductionVariants() {
            if (productionVariants instanceof SdkAutoConstructList) {
                return null;
            }
            return productionVariants != null ? productionVariants.stream().map(ProductionVariant::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant... productionVariants) {
            productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariant.Builder>... productionVariants) {
            productionVariants(Stream.of(productionVariants).map(c -> ProductionVariant.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        public final DataCaptureConfig.Builder getDataCaptureConfig() {
            return dataCaptureConfig != null ? dataCaptureConfig.toBuilder() : null;
        }

        @Override
        public final Builder dataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final void setDataCaptureConfig(DataCaptureConfig.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeEndpointConfigResponse build() {
            return new DescribeEndpointConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
