/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrialComponentResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeTrialComponentResponse.Builder, DescribeTrialComponentResponse> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentName").getter(getter(DescribeTrialComponentResponse::trialComponentName))
            .setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<String> TRIAL_COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentArn").getter(getter(DescribeTrialComponentResponse::trialComponentArn))
            .setter(setter(Builder::trialComponentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(DescribeTrialComponentResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<TrialComponentSource> SOURCE_FIELD = SdkField
            .<TrialComponentSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(DescribeTrialComponentResponse::source)).setter(setter(Builder::source))
            .constructor(TrialComponentSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField
            .<TrialComponentStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(DescribeTrialComponentResponse::status)).setter(setter(Builder::status))
            .constructor(TrialComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeTrialComponentResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeTrialComponentResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeTrialComponentResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeTrialComponentResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeTrialComponentResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeTrialComponentResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, TrialComponentParameterValue>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(DescribeTrialComponentResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("InputArtifacts")
            .getter(getter(DescribeTrialComponentResponse::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("OutputArtifacts")
            .getter(getter(DescribeTrialComponentResponse::outputArtifacts))
            .setter(setter(Builder::outputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(DescribeTrialComponentResponse::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<List<TrialComponentMetricSummary>> METRICS_FIELD = SdkField
            .<List<TrialComponentMetricSummary>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(DescribeTrialComponentResponse::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrialComponentMetricSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentMetricSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD,
            TRIAL_COMPONENT_ARN_FIELD, DISPLAY_NAME_FIELD, SOURCE_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, PARAMETERS_FIELD,
            INPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_FIELD, METADATA_PROPERTIES_FIELD, METRICS_FIELD));

    private final String trialComponentName;

    private final String trialComponentArn;

    private final String displayName;

    private final TrialComponentSource source;

    private final TrialComponentStatus status;

    private final Instant startTime;

    private final Instant endTime;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final Map<String, TrialComponentParameterValue> parameters;

    private final Map<String, TrialComponentArtifact> inputArtifacts;

    private final Map<String, TrialComponentArtifact> outputArtifacts;

    private final MetadataProperties metadataProperties;

    private final List<TrialComponentMetricSummary> metrics;

    private DescribeTrialComponentResponse(BuilderImpl builder) {
        super(builder);
        this.trialComponentName = builder.trialComponentName;
        this.trialComponentArn = builder.trialComponentArn;
        this.displayName = builder.displayName;
        this.source = builder.source;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.parameters = builder.parameters;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.metadataProperties = builder.metadataProperties;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * The name of the trial component.
     * </p>
     * 
     * @return The name of the trial component.
     */
    public final String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial component.
     */
    public final String trialComponentArn() {
        return trialComponentArn;
    }

    /**
     * <p>
     * The name of the component as displayed. If <code>DisplayName</code> isn't specified,
     * <code>TrialComponentName</code> is displayed.
     * </p>
     * 
     * @return The name of the component as displayed. If <code>DisplayName</code> isn't specified,
     *         <code>TrialComponentName</code> is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source and, optionally, the job type.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source and, optionally, the job type.
     */
    public final TrialComponentSource source() {
        return source;
    }

    /**
     * <p>
     * The status of the component. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * InProgress
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the component. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         InProgress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed
     *         </p>
     *         </li>
     */
    public final TrialComponentStatus status() {
        return status;
    }

    /**
     * <p>
     * When the component started.
     * </p>
     * 
     * @return When the component started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the component ended.
     * </p>
     * 
     * @return When the component ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * When the component was created.
     * </p>
     * 
     * @return When the component was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Who created the component.
     * </p>
     * 
     * @return Who created the component.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * When the component was last modified.
     * </p>
     * 
     * @return When the component was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Who last modified the component.
     * </p>
     * 
     * @return Who last modified the component.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The hyperparameters of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The hyperparameters of the component.
     */
    public final Map<String, TrialComponentParameterValue> parameters() {
        return parameters;
    }

    /**
     * Returns true if the InputArtifacts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The input artifacts of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The input artifacts of the component.
     */
    public final Map<String, TrialComponentArtifact> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * Returns true if the OutputArtifacts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOutputArtifacts() {
        return outputArtifacts != null && !(outputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The output artifacts of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The output artifacts of the component.
     */
    public final Map<String, TrialComponentArtifact> outputArtifacts() {
        return outputArtifacts;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * Returns true if the Metrics property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics for the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metrics for the component.
     */
    public final List<TrialComponentMetricSummary> metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputArtifacts() ? inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputArtifacts() ? outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrialComponentResponse)) {
            return false;
        }
        DescribeTrialComponentResponse other = (DescribeTrialComponentResponse) obj;
        return Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(trialComponentArn(), other.trialComponentArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(source(), other.source())
                && Objects.equals(status(), other.status()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && hasInputArtifacts() == other.hasInputArtifacts()
                && Objects.equals(inputArtifacts(), other.inputArtifacts()) && hasOutputArtifacts() == other.hasOutputArtifacts()
                && Objects.equals(outputArtifacts(), other.outputArtifacts())
                && Objects.equals(metadataProperties(), other.metadataProperties()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrialComponentResponse").add("TrialComponentName", trialComponentName())
                .add("TrialComponentArn", trialComponentArn()).add("DisplayName", displayName()).add("Source", source())
                .add("Status", status()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("Parameters", hasParameters() ? parameters() : null)
                .add("InputArtifacts", hasInputArtifacts() ? inputArtifacts() : null)
                .add("OutputArtifacts", hasOutputArtifacts() ? outputArtifacts() : null)
                .add("MetadataProperties", metadataProperties()).add("Metrics", hasMetrics() ? metrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "TrialComponentArn":
            return Optional.ofNullable(clazz.cast(trialComponentArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "InputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "OutputArtifacts":
            return Optional.ofNullable(clazz.cast(outputArtifacts()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrialComponentResponse, T> g) {
        return obj -> g.apply((DescribeTrialComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrialComponentResponse> {
        /**
         * <p>
         * The name of the trial component.
         * </p>
         * 
         * @param trialComponentName
         *        The name of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial component.
         * </p>
         * 
         * @param trialComponentArn
         *        The Amazon Resource Name (ARN) of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentArn(String trialComponentArn);

        /**
         * <p>
         * The name of the component as displayed. If <code>DisplayName</code> isn't specified,
         * <code>TrialComponentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the component as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>TrialComponentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source and, optionally, the job type.
         * </p>
         * 
         * @param source
         *        The Amazon Resource Name (ARN) of the source and, optionally, the job type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TrialComponentSource source);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source and, optionally, the job type.
         * </p>
         * This is a convenience that creates an instance of the {@link TrialComponentSource.Builder} avoiding the need
         * to create one manually via {@link TrialComponentSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponentSource.Builder#build()} is called immediately and
         * its result is passed to {@link #source(TrialComponentSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TrialComponentSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TrialComponentSource)
         */
        default Builder source(Consumer<TrialComponentSource.Builder> source) {
            return source(TrialComponentSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the component. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        InProgress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(TrialComponentStatus status);

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link TrialComponentStatus.Builder} avoiding the need
         * to create one manually via {@link TrialComponentStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(TrialComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link TrialComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(TrialComponentStatus)
         */
        default Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return status(TrialComponentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * When the component started.
         * </p>
         * 
         * @param startTime
         *        When the component started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the component ended.
         * </p>
         * 
         * @param endTime
         *        When the component ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * When the component was created.
         * </p>
         * 
         * @param creationTime
         *        When the component was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Who created the component.
         * </p>
         * 
         * @param createdBy
         *        Who created the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * <p>
         * Who created the component.
         * </p>
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * When the component was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the component was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Who last modified the component.
         * </p>
         * 
         * @param lastModifiedBy
         *        Who last modified the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * <p>
         * Who last modified the component.
         * </p>
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The hyperparameters of the component.
         * </p>
         * 
         * @param parameters
         *        The hyperparameters of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, TrialComponentParameterValue> parameters);

        /**
         * <p>
         * The input artifacts of the component.
         * </p>
         * 
         * @param inputArtifacts
         *        The input artifacts of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts);

        /**
         * <p>
         * The output artifacts of the component.
         * </p>
         * 
         * @param outputArtifacts
         *        The output artifacts of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience that creates an instance of the {@link MetadataProperties.Builder} avoiding the need to
         * create one manually via {@link MetadataProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * The metrics for the component.
         * </p>
         * 
         * @param metrics
         *        The metrics for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<TrialComponentMetricSummary> metrics);

        /**
         * <p>
         * The metrics for the component.
         * </p>
         * 
         * @param metrics
         *        The metrics for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(TrialComponentMetricSummary... metrics);

        /**
         * <p>
         * The metrics for the component.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrialComponentMetricSummary>.Builder}
         * avoiding the need to create one manually via {@link List<TrialComponentMetricSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrialComponentMetricSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #metrics(List<TrialComponentMetricSummary>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link List<TrialComponentMetricSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(List<TrialComponentMetricSummary>)
         */
        Builder metrics(Consumer<TrialComponentMetricSummary.Builder>... metrics);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trialComponentName;

        private String trialComponentArn;

        private String displayName;

        private TrialComponentSource source;

        private TrialComponentStatus status;

        private Instant startTime;

        private Instant endTime;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private MetadataProperties metadataProperties;

        private List<TrialComponentMetricSummary> metrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrialComponentResponse model) {
            super(model);
            trialComponentName(model.trialComponentName);
            trialComponentArn(model.trialComponentArn);
            displayName(model.displayName);
            source(model.source);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            parameters(model.parameters);
            inputArtifacts(model.inputArtifacts);
            outputArtifacts(model.outputArtifacts);
            metadataProperties(model.metadataProperties);
            metrics(model.metrics);
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getTrialComponentArn() {
            return trialComponentArn;
        }

        @Override
        public final Builder trialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
            return this;
        }

        public final void setTrialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final TrialComponentSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(TrialComponentSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(TrialComponentSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters != null ? CollectionUtils.mapValues(parameters, TrialComponentParameterValue::toBuilder) : null;
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            if (inputArtifacts instanceof SdkAutoConstructMap) {
                return null;
            }
            return inputArtifacts != null ? CollectionUtils.mapValues(inputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            if (outputArtifacts instanceof SdkAutoConstructMap) {
                return null;
            }
            return outputArtifacts != null ? CollectionUtils.mapValues(outputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        public final Collection<TrialComponentMetricSummary.Builder> getMetrics() {
            if (metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return metrics != null ? metrics.stream().map(TrialComponentMetricSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder metrics(Collection<TrialComponentMetricSummary> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(TrialComponentMetricSummary... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<TrialComponentMetricSummary.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> TrialComponentMetricSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetrics(Collection<TrialComponentMetricSummary.BuilderImpl> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copyFromBuilder(metrics);
        }

        @Override
        public DescribeTrialComponentResponse build() {
            return new DescribeTrialComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
