/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEdgePackagingJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListEdgePackagingJobsResponse.Builder, ListEdgePackagingJobsResponse> {
    private static final SdkField<List<EdgePackagingJobSummary>> EDGE_PACKAGING_JOB_SUMMARIES_FIELD = SdkField
            .<List<EdgePackagingJobSummary>> builder(MarshallingType.LIST)
            .memberName("EdgePackagingJobSummaries")
            .getter(getter(ListEdgePackagingJobsResponse::edgePackagingJobSummaries))
            .setter(setter(Builder::edgePackagingJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgePackagingJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgePackagingJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEdgePackagingJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EDGE_PACKAGING_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<EdgePackagingJobSummary> edgePackagingJobSummaries;

    private final String nextToken;

    private ListEdgePackagingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.edgePackagingJobSummaries = builder.edgePackagingJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EdgePackagingJobSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEdgePackagingJobSummaries() {
        return edgePackagingJobSummaries != null && !(edgePackagingJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of edge packaging jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEdgePackagingJobSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summaries of edge packaging jobs.
     */
    public final List<EdgePackagingJobSummary> edgePackagingJobSummaries() {
        return edgePackagingJobSummaries;
    }

    /**
     * <p>
     * Token to use when calling the next page of results.
     * </p>
     * 
     * @return Token to use when calling the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgePackagingJobSummaries() ? edgePackagingJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEdgePackagingJobsResponse)) {
            return false;
        }
        ListEdgePackagingJobsResponse other = (ListEdgePackagingJobsResponse) obj;
        return hasEdgePackagingJobSummaries() == other.hasEdgePackagingJobSummaries()
                && Objects.equals(edgePackagingJobSummaries(), other.edgePackagingJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEdgePackagingJobsResponse")
                .add("EdgePackagingJobSummaries", hasEdgePackagingJobSummaries() ? edgePackagingJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgePackagingJobSummaries":
            return Optional.ofNullable(clazz.cast(edgePackagingJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEdgePackagingJobsResponse, T> g) {
        return obj -> g.apply((ListEdgePackagingJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEdgePackagingJobsResponse> {
        /**
         * <p>
         * Summaries of edge packaging jobs.
         * </p>
         * 
         * @param edgePackagingJobSummaries
         *        Summaries of edge packaging jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobSummaries(Collection<EdgePackagingJobSummary> edgePackagingJobSummaries);

        /**
         * <p>
         * Summaries of edge packaging jobs.
         * </p>
         * 
         * @param edgePackagingJobSummaries
         *        Summaries of edge packaging jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobSummaries(EdgePackagingJobSummary... edgePackagingJobSummaries);

        /**
         * <p>
         * Summaries of edge packaging jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EdgePackagingJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<EdgePackagingJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EdgePackagingJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #edgePackagingJobSummaries(List<EdgePackagingJobSummary>)}.
         * 
         * @param edgePackagingJobSummaries
         *        a consumer that will call methods on {@link List<EdgePackagingJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edgePackagingJobSummaries(List<EdgePackagingJobSummary>)
         */
        Builder edgePackagingJobSummaries(Consumer<EdgePackagingJobSummary.Builder>... edgePackagingJobSummaries);

        /**
         * <p>
         * Token to use when calling the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Token to use when calling the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<EdgePackagingJobSummary> edgePackagingJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEdgePackagingJobsResponse model) {
            super(model);
            edgePackagingJobSummaries(model.edgePackagingJobSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<EdgePackagingJobSummary.Builder> getEdgePackagingJobSummaries() {
            if (edgePackagingJobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return edgePackagingJobSummaries != null ? edgePackagingJobSummaries.stream().map(EdgePackagingJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder edgePackagingJobSummaries(Collection<EdgePackagingJobSummary> edgePackagingJobSummaries) {
            this.edgePackagingJobSummaries = EdgePackagingJobSummariesCopier.copy(edgePackagingJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgePackagingJobSummaries(EdgePackagingJobSummary... edgePackagingJobSummaries) {
            edgePackagingJobSummaries(Arrays.asList(edgePackagingJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgePackagingJobSummaries(Consumer<EdgePackagingJobSummary.Builder>... edgePackagingJobSummaries) {
            edgePackagingJobSummaries(Stream.of(edgePackagingJobSummaries)
                    .map(c -> EdgePackagingJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEdgePackagingJobSummaries(Collection<EdgePackagingJobSummary.BuilderImpl> edgePackagingJobSummaries) {
            this.edgePackagingJobSummaries = EdgePackagingJobSummariesCopier.copyFromBuilder(edgePackagingJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEdgePackagingJobsResponse build() {
            return new ListEdgePackagingJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
