/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLabelingJobsForWorkteamResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListLabelingJobsForWorkteamResponse.Builder, ListLabelingJobsForWorkteamResponse> {
    private static final SdkField<List<LabelingJobForWorkteamSummary>> LABELING_JOB_SUMMARY_LIST_FIELD = SdkField
            .<List<LabelingJobForWorkteamSummary>> builder(MarshallingType.LIST)
            .memberName("LabelingJobSummaryList")
            .getter(getter(ListLabelingJobsForWorkteamResponse::labelingJobSummaryList))
            .setter(setter(Builder::labelingJobSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelingJobForWorkteamSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelingJobForWorkteamSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLabelingJobsForWorkteamResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LABELING_JOB_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<LabelingJobForWorkteamSummary> labelingJobSummaryList;

    private final String nextToken;

    private ListLabelingJobsForWorkteamResponse(BuilderImpl builder) {
        super(builder);
        this.labelingJobSummaryList = builder.labelingJobSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LabelingJobSummaryList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLabelingJobSummaryList() {
        return labelingJobSummaryList != null && !(labelingJobSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabelingJobSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
     */
    public final List<LabelingJobForWorkteamSummary> labelingJobSummaryList() {
        return labelingJobSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use
     * it in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling
     *         jobs, use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelingJobSummaryList() ? labelingJobSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelingJobsForWorkteamResponse)) {
            return false;
        }
        ListLabelingJobsForWorkteamResponse other = (ListLabelingJobsForWorkteamResponse) obj;
        return hasLabelingJobSummaryList() == other.hasLabelingJobSummaryList()
                && Objects.equals(labelingJobSummaryList(), other.labelingJobSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLabelingJobsForWorkteamResponse")
                .add("LabelingJobSummaryList", hasLabelingJobSummaryList() ? labelingJobSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobSummaryList":
            return Optional.ofNullable(clazz.cast(labelingJobSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelingJobsForWorkteamResponse, T> g) {
        return obj -> g.apply((ListLabelingJobsForWorkteamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLabelingJobsForWorkteamResponse> {
        /**
         * <p>
         * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * </p>
         * 
         * @param labelingJobSummaryList
         *        An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobSummaryList(Collection<LabelingJobForWorkteamSummary> labelingJobSummaryList);

        /**
         * <p>
         * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * </p>
         * 
         * @param labelingJobSummaryList
         *        An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobSummaryList(LabelingJobForWorkteamSummary... labelingJobSummaryList);

        /**
         * <p>
         * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LabelingJobForWorkteamSummary>.Builder}
         * avoiding the need to create one manually via {@link List<LabelingJobForWorkteamSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LabelingJobForWorkteamSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #labelingJobSummaryList(List<LabelingJobForWorkteamSummary>)}.
         * 
         * @param labelingJobSummaryList
         *        a consumer that will call methods on {@link List<LabelingJobForWorkteamSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingJobSummaryList(List<LabelingJobForWorkteamSummary>)
         */
        Builder labelingJobSummaryList(Consumer<LabelingJobForWorkteamSummary.Builder>... labelingJobSummaryList);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs,
         * use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of
         *        labeling jobs, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<LabelingJobForWorkteamSummary> labelingJobSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelingJobsForWorkteamResponse model) {
            super(model);
            labelingJobSummaryList(model.labelingJobSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<LabelingJobForWorkteamSummary.Builder> getLabelingJobSummaryList() {
            if (labelingJobSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return labelingJobSummaryList != null ? labelingJobSummaryList.stream().map(LabelingJobForWorkteamSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labelingJobSummaryList(Collection<LabelingJobForWorkteamSummary> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobForWorkteamSummaryListCopier.copy(labelingJobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(LabelingJobForWorkteamSummary... labelingJobSummaryList) {
            labelingJobSummaryList(Arrays.asList(labelingJobSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(Consumer<LabelingJobForWorkteamSummary.Builder>... labelingJobSummaryList) {
            labelingJobSummaryList(Stream.of(labelingJobSummaryList)
                    .map(c -> LabelingJobForWorkteamSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabelingJobSummaryList(Collection<LabelingJobForWorkteamSummary.BuilderImpl> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobForWorkteamSummaryListCopier.copyFromBuilder(labelingJobSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLabelingJobsForWorkteamResponse build() {
            return new ListLabelingJobsForWorkteamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
