/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the validation and image scan statuses of the model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackageStatusDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackageStatusDetails.Builder, ModelPackageStatusDetails> {
    private static final SdkField<List<ModelPackageStatusItem>> VALIDATION_STATUSES_FIELD = SdkField
            .<List<ModelPackageStatusItem>> builder(MarshallingType.LIST)
            .memberName("ValidationStatuses")
            .getter(getter(ModelPackageStatusDetails::validationStatuses))
            .setter(setter(Builder::validationStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackageStatusItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackageStatusItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ModelPackageStatusItem>> IMAGE_SCAN_STATUSES_FIELD = SdkField
            .<List<ModelPackageStatusItem>> builder(MarshallingType.LIST)
            .memberName("ImageScanStatuses")
            .getter(getter(ModelPackageStatusDetails::imageScanStatuses))
            .setter(setter(Builder::imageScanStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScanStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackageStatusItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackageStatusItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_STATUSES_FIELD,
            IMAGE_SCAN_STATUSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ModelPackageStatusItem> validationStatuses;

    private final List<ModelPackageStatusItem> imageScanStatuses;

    private ModelPackageStatusDetails(BuilderImpl builder) {
        this.validationStatuses = builder.validationStatuses;
        this.imageScanStatuses = builder.imageScanStatuses;
    }

    /**
     * Returns true if the ValidationStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasValidationStatuses() {
        return validationStatuses != null && !(validationStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation status of the model package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The validation status of the model package.
     */
    public final List<ModelPackageStatusItem> validationStatuses() {
        return validationStatuses;
    }

    /**
     * Returns true if the ImageScanStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasImageScanStatuses() {
        return imageScanStatuses != null && !(imageScanStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the scan of the Docker image container for the model package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImageScanStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the scan of the Docker image container for the model package.
     */
    public final List<ModelPackageStatusItem> imageScanStatuses() {
        return imageScanStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationStatuses() ? validationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImageScanStatuses() ? imageScanStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageStatusDetails)) {
            return false;
        }
        ModelPackageStatusDetails other = (ModelPackageStatusDetails) obj;
        return hasValidationStatuses() == other.hasValidationStatuses()
                && Objects.equals(validationStatuses(), other.validationStatuses())
                && hasImageScanStatuses() == other.hasImageScanStatuses()
                && Objects.equals(imageScanStatuses(), other.imageScanStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelPackageStatusDetails")
                .add("ValidationStatuses", hasValidationStatuses() ? validationStatuses() : null)
                .add("ImageScanStatuses", hasImageScanStatuses() ? imageScanStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValidationStatuses":
            return Optional.ofNullable(clazz.cast(validationStatuses()));
        case "ImageScanStatuses":
            return Optional.ofNullable(clazz.cast(imageScanStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageStatusDetails, T> g) {
        return obj -> g.apply((ModelPackageStatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackageStatusDetails> {
        /**
         * <p>
         * The validation status of the model package.
         * </p>
         * 
         * @param validationStatuses
         *        The validation status of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatuses(Collection<ModelPackageStatusItem> validationStatuses);

        /**
         * <p>
         * The validation status of the model package.
         * </p>
         * 
         * @param validationStatuses
         *        The validation status of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatuses(ModelPackageStatusItem... validationStatuses);

        /**
         * <p>
         * The validation status of the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelPackageStatusItem>.Builder} avoiding
         * the need to create one manually via {@link List<ModelPackageStatusItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelPackageStatusItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #validationStatuses(List<ModelPackageStatusItem>)}.
         * 
         * @param validationStatuses
         *        a consumer that will call methods on {@link List<ModelPackageStatusItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationStatuses(List<ModelPackageStatusItem>)
         */
        Builder validationStatuses(Consumer<ModelPackageStatusItem.Builder>... validationStatuses);

        /**
         * <p>
         * The status of the scan of the Docker image container for the model package.
         * </p>
         * 
         * @param imageScanStatuses
         *        The status of the scan of the Docker image container for the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanStatuses(Collection<ModelPackageStatusItem> imageScanStatuses);

        /**
         * <p>
         * The status of the scan of the Docker image container for the model package.
         * </p>
         * 
         * @param imageScanStatuses
         *        The status of the scan of the Docker image container for the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanStatuses(ModelPackageStatusItem... imageScanStatuses);

        /**
         * <p>
         * The status of the scan of the Docker image container for the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelPackageStatusItem>.Builder} avoiding
         * the need to create one manually via {@link List<ModelPackageStatusItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelPackageStatusItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #imageScanStatuses(List<ModelPackageStatusItem>)}.
         * 
         * @param imageScanStatuses
         *        a consumer that will call methods on {@link List<ModelPackageStatusItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanStatuses(List<ModelPackageStatusItem>)
         */
        Builder imageScanStatuses(Consumer<ModelPackageStatusItem.Builder>... imageScanStatuses);
    }

    static final class BuilderImpl implements Builder {
        private List<ModelPackageStatusItem> validationStatuses = DefaultSdkAutoConstructList.getInstance();

        private List<ModelPackageStatusItem> imageScanStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageStatusDetails model) {
            validationStatuses(model.validationStatuses);
            imageScanStatuses(model.imageScanStatuses);
        }

        public final Collection<ModelPackageStatusItem.Builder> getValidationStatuses() {
            if (validationStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return validationStatuses != null ? validationStatuses.stream().map(ModelPackageStatusItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationStatuses(Collection<ModelPackageStatusItem> validationStatuses) {
            this.validationStatuses = ModelPackageStatusItemListCopier.copy(validationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(ModelPackageStatusItem... validationStatuses) {
            validationStatuses(Arrays.asList(validationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(Consumer<ModelPackageStatusItem.Builder>... validationStatuses) {
            validationStatuses(Stream.of(validationStatuses).map(c -> ModelPackageStatusItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationStatuses(Collection<ModelPackageStatusItem.BuilderImpl> validationStatuses) {
            this.validationStatuses = ModelPackageStatusItemListCopier.copyFromBuilder(validationStatuses);
        }

        public final Collection<ModelPackageStatusItem.Builder> getImageScanStatuses() {
            if (imageScanStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return imageScanStatuses != null ? imageScanStatuses.stream().map(ModelPackageStatusItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageScanStatuses(Collection<ModelPackageStatusItem> imageScanStatuses) {
            this.imageScanStatuses = ModelPackageStatusItemListCopier.copy(imageScanStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(ModelPackageStatusItem... imageScanStatuses) {
            imageScanStatuses(Arrays.asList(imageScanStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(Consumer<ModelPackageStatusItem.Builder>... imageScanStatuses) {
            imageScanStatuses(Stream.of(imageScanStatuses).map(c -> ModelPackageStatusItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImageScanStatuses(Collection<ModelPackageStatusItem.BuilderImpl> imageScanStatuses) {
            this.imageScanStatuses = ModelPackageStatusItemListCopier.copyFromBuilder(imageScanStatuses);
        }

        @Override
        public ModelPackageStatusDetails build() {
            return new ModelPackageStatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
