/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSettings implements SdkPojo, Serializable, ToCopyableBuilder<UserSettings.Builder, UserSettings> {
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(UserSettings::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(UserSettings::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SharingSettings> SHARING_SETTINGS_FIELD = SdkField
            .<SharingSettings> builder(MarshallingType.SDK_POJO).memberName("SharingSettings")
            .getter(getter(UserSettings::sharingSettings)).setter(setter(Builder::sharingSettings))
            .constructor(SharingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharingSettings").build()).build();

    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField
            .<JupyterServerAppSettings> builder(MarshallingType.SDK_POJO).memberName("JupyterServerAppSettings")
            .getter(getter(UserSettings::jupyterServerAppSettings)).setter(setter(Builder::jupyterServerAppSettings))
            .constructor(JupyterServerAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build())
            .build();

    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField
            .<KernelGatewayAppSettings> builder(MarshallingType.SDK_POJO).memberName("KernelGatewayAppSettings")
            .getter(getter(UserSettings::kernelGatewayAppSettings)).setter(setter(Builder::kernelGatewayAppSettings))
            .constructor(KernelGatewayAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build())
            .build();

    private static final SdkField<TensorBoardAppSettings> TENSOR_BOARD_APP_SETTINGS_FIELD = SdkField
            .<TensorBoardAppSettings> builder(MarshallingType.SDK_POJO).memberName("TensorBoardAppSettings")
            .getter(getter(UserSettings::tensorBoardAppSettings)).setter(setter(Builder::tensorBoardAppSettings))
            .constructor(TensorBoardAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardAppSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_FIELD,
            SECURITY_GROUPS_FIELD, SHARING_SETTINGS_FIELD, JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD,
            TENSOR_BOARD_APP_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionRole;

    private final List<String> securityGroups;

    private final SharingSettings sharingSettings;

    private final JupyterServerAppSettings jupyterServerAppSettings;

    private final KernelGatewayAppSettings kernelGatewayAppSettings;

    private final TensorBoardAppSettings tensorBoardAppSettings;

    private UserSettings(BuilderImpl builder) {
        this.executionRole = builder.executionRole;
        this.securityGroups = builder.securityGroups;
        this.sharingSettings = builder.sharingSettings;
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
        this.tensorBoardAppSettings = builder.tensorBoardAppSettings;
    }

    /**
     * <p>
     * The execution role for the user.
     * </p>
     * 
     * @return The execution role for the user.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * </p>
     * <p>
     * Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
     * <code>PublicInternetOnly</code>.
     * </p>
     * <p>
     * Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
     *         <p>
     *         Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
     *         <code>PublicInternetOnly</code>.
     *         </p>
     *         <p>
     *         Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code>.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The sharing settings.
     * </p>
     * 
     * @return The sharing settings.
     */
    public final SharingSettings sharingSettings() {
        return sharingSettings;
    }

    /**
     * <p>
     * The Jupyter server's app settings.
     * </p>
     * 
     * @return The Jupyter server's app settings.
     */
    public final JupyterServerAppSettings jupyterServerAppSettings() {
        return jupyterServerAppSettings;
    }

    /**
     * <p>
     * The kernel gateway app settings.
     * </p>
     * 
     * @return The kernel gateway app settings.
     */
    public final KernelGatewayAppSettings kernelGatewayAppSettings() {
        return kernelGatewayAppSettings;
    }

    /**
     * <p>
     * The TensorBoard app settings.
     * </p>
     * 
     * @return The TensorBoard app settings.
     */
    public final TensorBoardAppSettings tensorBoardAppSettings() {
        return tensorBoardAppSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sharingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(kernelGatewayAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(tensorBoardAppSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings) obj;
        return Objects.equals(executionRole(), other.executionRole()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sharingSettings(), other.sharingSettings())
                && Objects.equals(jupyterServerAppSettings(), other.jupyterServerAppSettings())
                && Objects.equals(kernelGatewayAppSettings(), other.kernelGatewayAppSettings())
                && Objects.equals(tensorBoardAppSettings(), other.tensorBoardAppSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserSettings").add("ExecutionRole", executionRole())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SharingSettings", sharingSettings())
                .add("JupyterServerAppSettings", jupyterServerAppSettings())
                .add("KernelGatewayAppSettings", kernelGatewayAppSettings())
                .add("TensorBoardAppSettings", tensorBoardAppSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SharingSettings":
            return Optional.ofNullable(clazz.cast(sharingSettings()));
        case "JupyterServerAppSettings":
            return Optional.ofNullable(clazz.cast(jupyterServerAppSettings()));
        case "KernelGatewayAppSettings":
            return Optional.ofNullable(clazz.cast(kernelGatewayAppSettings()));
        case "TensorBoardAppSettings":
            return Optional.ofNullable(clazz.cast(tensorBoardAppSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSettings, T> g) {
        return obj -> g.apply((UserSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserSettings> {
        /**
         * <p>
         * The execution role for the user.
         * </p>
         * 
         * @param executionRole
         *        The execution role for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
         * </p>
         * <p>
         * Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
         * <code>PublicInternetOnly</code>.
         * </p>
         * <p>
         * Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code>.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
         *        <p>
         *        Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
         *        <code>PublicInternetOnly</code>.
         *        </p>
         *        <p>
         *        Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
         *        <code>VpcOnly</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
         * </p>
         * <p>
         * Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
         * <code>PublicInternetOnly</code>.
         * </p>
         * <p>
         * Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code>.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
         *        <p>
         *        Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
         *        <code>PublicInternetOnly</code>.
         *        </p>
         *        <p>
         *        Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
         *        <code>VpcOnly</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The sharing settings.
         * </p>
         * 
         * @param sharingSettings
         *        The sharing settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharingSettings(SharingSettings sharingSettings);

        /**
         * <p>
         * The sharing settings.
         * </p>
         * This is a convenience that creates an instance of the {@link SharingSettings.Builder} avoiding the need to
         * create one manually via {@link SharingSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link SharingSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #sharingSettings(SharingSettings)}.
         * 
         * @param sharingSettings
         *        a consumer that will call methods on {@link SharingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharingSettings(SharingSettings)
         */
        default Builder sharingSettings(Consumer<SharingSettings.Builder> sharingSettings) {
            return sharingSettings(SharingSettings.builder().applyMutation(sharingSettings).build());
        }

        /**
         * <p>
         * The Jupyter server's app settings.
         * </p>
         * 
         * @param jupyterServerAppSettings
         *        The Jupyter server's app settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings);

        /**
         * <p>
         * The Jupyter server's app settings.
         * </p>
         * This is a convenience that creates an instance of the {@link JupyterServerAppSettings.Builder} avoiding the
         * need to create one manually via {@link JupyterServerAppSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link JupyterServerAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #jupyterServerAppSettings(JupyterServerAppSettings)}.
         * 
         * @param jupyterServerAppSettings
         *        a consumer that will call methods on {@link JupyterServerAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jupyterServerAppSettings(JupyterServerAppSettings)
         */
        default Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return jupyterServerAppSettings(JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings).build());
        }

        /**
         * <p>
         * The kernel gateway app settings.
         * </p>
         * 
         * @param kernelGatewayAppSettings
         *        The kernel gateway app settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings);

        /**
         * <p>
         * The kernel gateway app settings.
         * </p>
         * This is a convenience that creates an instance of the {@link KernelGatewayAppSettings.Builder} avoiding the
         * need to create one manually via {@link KernelGatewayAppSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link KernelGatewayAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #kernelGatewayAppSettings(KernelGatewayAppSettings)}.
         * 
         * @param kernelGatewayAppSettings
         *        a consumer that will call methods on {@link KernelGatewayAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelGatewayAppSettings(KernelGatewayAppSettings)
         */
        default Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return kernelGatewayAppSettings(KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings).build());
        }

        /**
         * <p>
         * The TensorBoard app settings.
         * </p>
         * 
         * @param tensorBoardAppSettings
         *        The TensorBoard app settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tensorBoardAppSettings(TensorBoardAppSettings tensorBoardAppSettings);

        /**
         * <p>
         * The TensorBoard app settings.
         * </p>
         * This is a convenience that creates an instance of the {@link TensorBoardAppSettings.Builder} avoiding the
         * need to create one manually via {@link TensorBoardAppSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link TensorBoardAppSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #tensorBoardAppSettings(TensorBoardAppSettings)}.
         * 
         * @param tensorBoardAppSettings
         *        a consumer that will call methods on {@link TensorBoardAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tensorBoardAppSettings(TensorBoardAppSettings)
         */
        default Builder tensorBoardAppSettings(Consumer<TensorBoardAppSettings.Builder> tensorBoardAppSettings) {
            return tensorBoardAppSettings(TensorBoardAppSettings.builder().applyMutation(tensorBoardAppSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String executionRole;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private SharingSettings sharingSettings;

        private JupyterServerAppSettings jupyterServerAppSettings;

        private KernelGatewayAppSettings kernelGatewayAppSettings;

        private TensorBoardAppSettings tensorBoardAppSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSettings model) {
            executionRole(model.executionRole);
            securityGroups(model.securityGroups);
            sharingSettings(model.sharingSettings);
            jupyterServerAppSettings(model.jupyterServerAppSettings);
            kernelGatewayAppSettings(model.kernelGatewayAppSettings);
            tensorBoardAppSettings(model.tensorBoardAppSettings);
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        public final SharingSettings.Builder getSharingSettings() {
            return sharingSettings != null ? sharingSettings.toBuilder() : null;
        }

        @Override
        public final Builder sharingSettings(SharingSettings sharingSettings) {
            this.sharingSettings = sharingSettings;
            return this;
        }

        public final void setSharingSettings(SharingSettings.BuilderImpl sharingSettings) {
            this.sharingSettings = sharingSettings != null ? sharingSettings.build() : null;
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return jupyterServerAppSettings != null ? jupyterServerAppSettings.toBuilder() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return kernelGatewayAppSettings != null ? kernelGatewayAppSettings.toBuilder() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        public final TensorBoardAppSettings.Builder getTensorBoardAppSettings() {
            return tensorBoardAppSettings != null ? tensorBoardAppSettings.toBuilder() : null;
        }

        @Override
        public final Builder tensorBoardAppSettings(TensorBoardAppSettings tensorBoardAppSettings) {
            this.tensorBoardAppSettings = tensorBoardAppSettings;
            return this;
        }

        public final void setTensorBoardAppSettings(TensorBoardAppSettings.BuilderImpl tensorBoardAppSettings) {
            this.tensorBoardAppSettings = tensorBoardAppSettings != null ? tensorBoardAppSettings.build() : null;
        }

        @Override
        public UserSettings build() {
            return new UserSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
