/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A short summary of a trial component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentSimpleSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentSimpleSummary.Builder, TrialComponentSimpleSummary> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentName").getter(getter(TrialComponentSimpleSummary::trialComponentName))
            .setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<String> TRIAL_COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentArn").getter(getter(TrialComponentSimpleSummary::trialComponentArn))
            .setter(setter(Builder::trialComponentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentArn").build()).build();

    private static final SdkField<TrialComponentSource> TRIAL_COMPONENT_SOURCE_FIELD = SdkField
            .<TrialComponentSource> builder(MarshallingType.SDK_POJO).memberName("TrialComponentSource")
            .getter(getter(TrialComponentSimpleSummary::trialComponentSource)).setter(setter(Builder::trialComponentSource))
            .constructor(TrialComponentSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSource").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TrialComponentSimpleSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(TrialComponentSimpleSummary::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD,
            TRIAL_COMPONENT_ARN_FIELD, TRIAL_COMPONENT_SOURCE_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trialComponentName;

    private final String trialComponentArn;

    private final TrialComponentSource trialComponentSource;

    private final Instant creationTime;

    private final UserContext createdBy;

    private TrialComponentSimpleSummary(BuilderImpl builder) {
        this.trialComponentName = builder.trialComponentName;
        this.trialComponentArn = builder.trialComponentArn;
        this.trialComponentSource = builder.trialComponentSource;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The name of the trial component.
     * </p>
     * 
     * @return The name of the trial component.
     */
    public final String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial component.
     */
    public final String trialComponentArn() {
        return trialComponentArn;
    }

    /**
     * Returns the value of the TrialComponentSource property for this object.
     * 
     * @return The value of the TrialComponentSource property for this object.
     */
    public final TrialComponentSource trialComponentSource() {
        return trialComponentSource;
    }

    /**
     * <p>
     * When the component was created.
     * </p>
     * 
     * @return When the component was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentSource());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentSimpleSummary)) {
            return false;
        }
        TrialComponentSimpleSummary other = (TrialComponentSimpleSummary) obj;
        return Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(trialComponentArn(), other.trialComponentArn())
                && Objects.equals(trialComponentSource(), other.trialComponentSource())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrialComponentSimpleSummary").add("TrialComponentName", trialComponentName())
                .add("TrialComponentArn", trialComponentArn()).add("TrialComponentSource", trialComponentSource())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "TrialComponentArn":
            return Optional.ofNullable(clazz.cast(trialComponentArn()));
        case "TrialComponentSource":
            return Optional.ofNullable(clazz.cast(trialComponentSource()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentSimpleSummary, T> g) {
        return obj -> g.apply((TrialComponentSimpleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentSimpleSummary> {
        /**
         * <p>
         * The name of the trial component.
         * </p>
         * 
         * @param trialComponentName
         *        The name of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial component.
         * </p>
         * 
         * @param trialComponentArn
         *        The Amazon Resource Name (ARN) of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentArn(String trialComponentArn);

        /**
         * Sets the value of the TrialComponentSource property for this object.
         *
         * @param trialComponentSource
         *        The new value for the TrialComponentSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSource(TrialComponentSource trialComponentSource);

        /**
         * Sets the value of the TrialComponentSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrialComponentSource.Builder} avoiding the need
         * to create one manually via {@link TrialComponentSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponentSource.Builder#build()} is called immediately and
         * its result is passed to {@link #trialComponentSource(TrialComponentSource)}.
         * 
         * @param trialComponentSource
         *        a consumer that will call methods on {@link TrialComponentSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialComponentSource(TrialComponentSource)
         */
        default Builder trialComponentSource(Consumer<TrialComponentSource.Builder> trialComponentSource) {
            return trialComponentSource(TrialComponentSource.builder().applyMutation(trialComponentSource).build());
        }

        /**
         * <p>
         * When the component was created.
         * </p>
         * 
         * @param creationTime
         *        When the component was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String trialComponentName;

        private String trialComponentArn;

        private TrialComponentSource trialComponentSource;

        private Instant creationTime;

        private UserContext createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentSimpleSummary model) {
            trialComponentName(model.trialComponentName);
            trialComponentArn(model.trialComponentArn);
            trialComponentSource(model.trialComponentSource);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getTrialComponentArn() {
            return trialComponentArn;
        }

        @Override
        public final Builder trialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
            return this;
        }

        public final void setTrialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
        }

        public final TrialComponentSource.Builder getTrialComponentSource() {
            return trialComponentSource != null ? trialComponentSource.toBuilder() : null;
        }

        @Override
        public final Builder trialComponentSource(TrialComponentSource trialComponentSource) {
            this.trialComponentSource = trialComponentSource;
            return this;
        }

        public final void setTrialComponentSource(TrialComponentSource.BuilderImpl trialComponentSource) {
            this.trialComponentSource = trialComponentSource != null ? trialComponentSource.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public TrialComponentSimpleSummary build() {
            return new TrialComponentSimpleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
