/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrainingJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeTrainingJobResponse.Builder, DescribeTrainingJobResponse> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingJobName").getter(getter(DescribeTrainingJobResponse::trainingJobName))
            .setter(setter(Builder::trainingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()).build();

    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingJobArn").getter(getter(DescribeTrainingJobResponse::trainingJobArn))
            .setter(setter(Builder::trainingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()).build();

    private static final SdkField<String> TUNING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TuningJobArn").getter(getter(DescribeTrainingJobResponse::tuningJobArn))
            .setter(setter(Builder::tuningJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobArn").build()).build();

    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelingJobArn").getter(getter(DescribeTrainingJobResponse::labelingJobArn))
            .setter(setter(Builder::labelingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobArn").getter(getter(DescribeTrainingJobResponse::autoMLJobArn))
            .setter(setter(Builder::autoMLJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()).build();

    private static final SdkField<ModelArtifacts> MODEL_ARTIFACTS_FIELD = SdkField
            .<ModelArtifacts> builder(MarshallingType.SDK_POJO).memberName("ModelArtifacts")
            .getter(getter(DescribeTrainingJobResponse::modelArtifacts)).setter(setter(Builder::modelArtifacts))
            .constructor(ModelArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifacts").build()).build();

    private static final SdkField<String> TRAINING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingJobStatus").getter(getter(DescribeTrainingJobResponse::trainingJobStatusAsString))
            .setter(setter(Builder::trainingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatus").build()).build();

    private static final SdkField<String> SECONDARY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecondaryStatus").getter(getter(DescribeTrainingJobResponse::secondaryStatusAsString))
            .setter(setter(Builder::secondaryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryStatus").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeTrainingJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("HyperParameters")
            .getter(getter(DescribeTrainingJobResponse::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<AlgorithmSpecification> builder(MarshallingType.SDK_POJO).memberName("AlgorithmSpecification")
            .getter(getter(DescribeTrainingJobResponse::algorithmSpecification)).setter(setter(Builder::algorithmSpecification))
            .constructor(AlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeTrainingJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<Channel>> builder(MarshallingType.LIST)
            .memberName("InputDataConfig")
            .getter(getter(DescribeTrainingJobResponse::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Channel> builder(MarshallingType.SDK_POJO)
                                            .constructor(Channel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(DescribeTrainingJobResponse::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<ResourceConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceConfig")
            .getter(getter(DescribeTrainingJobResponse::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(ResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(DescribeTrainingJobResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(DescribeTrainingJobResponse::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeTrainingJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingStartTime").getter(getter(DescribeTrainingJobResponse::trainingStartTime))
            .setter(setter(Builder::trainingStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()).build();

    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingEndTime").getter(getter(DescribeTrainingJobResponse::trainingEndTime))
            .setter(setter(Builder::trainingEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeTrainingJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<List<SecondaryStatusTransition>> SECONDARY_STATUS_TRANSITIONS_FIELD = SdkField
            .<List<SecondaryStatusTransition>> builder(MarshallingType.LIST)
            .memberName("SecondaryStatusTransitions")
            .getter(getter(DescribeTrainingJobResponse::secondaryStatusTransitions))
            .setter(setter(Builder::secondaryStatusTransitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryStatusTransitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecondaryStatusTransition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecondaryStatusTransition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricData>> FINAL_METRIC_DATA_LIST_FIELD = SdkField
            .<List<MetricData>> builder(MarshallingType.LIST)
            .memberName("FinalMetricDataList")
            .getter(getter(DescribeTrainingJobResponse::finalMetricDataList))
            .setter(setter(Builder::finalMetricDataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalMetricDataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricData> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableNetworkIsolation").getter(getter(DescribeTrainingJobResponse::enableNetworkIsolation))
            .setter(setter(Builder::enableNetworkIsolation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build())
            .build();

    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInterContainerTrafficEncryption")
            .getter(getter(DescribeTrainingJobResponse::enableInterContainerTrafficEncryption))
            .setter(setter(Builder::enableInterContainerTrafficEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableInterContainerTrafficEncryption").build()).build();

    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableManagedSpotTraining")
            .getter(getter(DescribeTrainingJobResponse::enableManagedSpotTraining))
            .setter(setter(Builder::enableManagedSpotTraining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManagedSpotTraining").build())
            .build();

    private static final SdkField<CheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField
            .<CheckpointConfig> builder(MarshallingType.SDK_POJO).memberName("CheckpointConfig")
            .getter(getter(DescribeTrainingJobResponse::checkpointConfig)).setter(setter(Builder::checkpointConfig))
            .constructor(CheckpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfig").build()).build();

    private static final SdkField<Integer> TRAINING_TIME_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TrainingTimeInSeconds").getter(getter(DescribeTrainingJobResponse::trainingTimeInSeconds))
            .setter(setter(Builder::trainingTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingTimeInSeconds").build())
            .build();

    private static final SdkField<Integer> BILLABLE_TIME_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BillableTimeInSeconds").getter(getter(DescribeTrainingJobResponse::billableTimeInSeconds))
            .setter(setter(Builder::billableTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillableTimeInSeconds").build())
            .build();

    private static final SdkField<DebugHookConfig> DEBUG_HOOK_CONFIG_FIELD = SdkField
            .<DebugHookConfig> builder(MarshallingType.SDK_POJO).memberName("DebugHookConfig")
            .getter(getter(DescribeTrainingJobResponse::debugHookConfig)).setter(setter(Builder::debugHookConfig))
            .constructor(DebugHookConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugHookConfig").build()).build();

    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField
            .<ExperimentConfig> builder(MarshallingType.SDK_POJO).memberName("ExperimentConfig")
            .getter(getter(DescribeTrainingJobResponse::experimentConfig)).setter(setter(Builder::experimentConfig))
            .constructor(ExperimentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()).build();

    private static final SdkField<List<DebugRuleConfiguration>> DEBUG_RULE_CONFIGURATIONS_FIELD = SdkField
            .<List<DebugRuleConfiguration>> builder(MarshallingType.LIST)
            .memberName("DebugRuleConfigurations")
            .getter(getter(DescribeTrainingJobResponse::debugRuleConfigurations))
            .setter(setter(Builder::debugRuleConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DebugRuleConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DebugRuleConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TensorBoardOutputConfig> TENSOR_BOARD_OUTPUT_CONFIG_FIELD = SdkField
            .<TensorBoardOutputConfig> builder(MarshallingType.SDK_POJO).memberName("TensorBoardOutputConfig")
            .getter(getter(DescribeTrainingJobResponse::tensorBoardOutputConfig))
            .setter(setter(Builder::tensorBoardOutputConfig)).constructor(TensorBoardOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardOutputConfig").build())
            .build();

    private static final SdkField<List<DebugRuleEvaluationStatus>> DEBUG_RULE_EVALUATION_STATUSES_FIELD = SdkField
            .<List<DebugRuleEvaluationStatus>> builder(MarshallingType.LIST)
            .memberName("DebugRuleEvaluationStatuses")
            .getter(getter(DescribeTrainingJobResponse::debugRuleEvaluationStatuses))
            .setter(setter(Builder::debugRuleEvaluationStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleEvaluationStatuses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DebugRuleEvaluationStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(DebugRuleEvaluationStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProfilerConfig> PROFILER_CONFIG_FIELD = SdkField
            .<ProfilerConfig> builder(MarshallingType.SDK_POJO).memberName("ProfilerConfig")
            .getter(getter(DescribeTrainingJobResponse::profilerConfig)).setter(setter(Builder::profilerConfig))
            .constructor(ProfilerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerConfig").build()).build();

    private static final SdkField<List<ProfilerRuleConfiguration>> PROFILER_RULE_CONFIGURATIONS_FIELD = SdkField
            .<List<ProfilerRuleConfiguration>> builder(MarshallingType.LIST)
            .memberName("ProfilerRuleConfigurations")
            .getter(getter(DescribeTrainingJobResponse::profilerRuleConfigurations))
            .setter(setter(Builder::profilerRuleConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerRuleConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfilerRuleConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfilerRuleConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProfilerRuleEvaluationStatus>> PROFILER_RULE_EVALUATION_STATUSES_FIELD = SdkField
            .<List<ProfilerRuleEvaluationStatus>> builder(MarshallingType.LIST)
            .memberName("ProfilerRuleEvaluationStatuses")
            .getter(getter(DescribeTrainingJobResponse::profilerRuleEvaluationStatuses))
            .setter(setter(Builder::profilerRuleEvaluationStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerRuleEvaluationStatuses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfilerRuleEvaluationStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfilerRuleEvaluationStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROFILING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfilingStatus").getter(getter(DescribeTrainingJobResponse::profilingStatusAsString))
            .setter(setter(Builder::profilingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilingStatus").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Environment")
            .getter(getter(DescribeTrainingJobResponse::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD,
            TRAINING_JOB_ARN_FIELD, TUNING_JOB_ARN_FIELD, LABELING_JOB_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD, MODEL_ARTIFACTS_FIELD,
            TRAINING_JOB_STATUS_FIELD, SECONDARY_STATUS_FIELD, FAILURE_REASON_FIELD, HYPER_PARAMETERS_FIELD,
            ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD,
            RESOURCE_CONFIG_FIELD, VPC_CONFIG_FIELD, STOPPING_CONDITION_FIELD, CREATION_TIME_FIELD, TRAINING_START_TIME_FIELD,
            TRAINING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, SECONDARY_STATUS_TRANSITIONS_FIELD, FINAL_METRIC_DATA_LIST_FIELD,
            ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD,
            CHECKPOINT_CONFIG_FIELD, TRAINING_TIME_IN_SECONDS_FIELD, BILLABLE_TIME_IN_SECONDS_FIELD, DEBUG_HOOK_CONFIG_FIELD,
            EXPERIMENT_CONFIG_FIELD, DEBUG_RULE_CONFIGURATIONS_FIELD, TENSOR_BOARD_OUTPUT_CONFIG_FIELD,
            DEBUG_RULE_EVALUATION_STATUSES_FIELD, PROFILER_CONFIG_FIELD, PROFILER_RULE_CONFIGURATIONS_FIELD,
            PROFILER_RULE_EVALUATION_STATUSES_FIELD, PROFILING_STATUS_FIELD, ENVIRONMENT_FIELD));

    private final String trainingJobName;

    private final String trainingJobArn;

    private final String tuningJobArn;

    private final String labelingJobArn;

    private final String autoMLJobArn;

    private final ModelArtifacts modelArtifacts;

    private final String trainingJobStatus;

    private final String secondaryStatus;

    private final String failureReason;

    private final Map<String, String> hyperParameters;

    private final AlgorithmSpecification algorithmSpecification;

    private final String roleArn;

    private final List<Channel> inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final ResourceConfig resourceConfig;

    private final VpcConfig vpcConfig;

    private final StoppingCondition stoppingCondition;

    private final Instant creationTime;

    private final Instant trainingStartTime;

    private final Instant trainingEndTime;

    private final Instant lastModifiedTime;

    private final List<SecondaryStatusTransition> secondaryStatusTransitions;

    private final List<MetricData> finalMetricDataList;

    private final Boolean enableNetworkIsolation;

    private final Boolean enableInterContainerTrafficEncryption;

    private final Boolean enableManagedSpotTraining;

    private final CheckpointConfig checkpointConfig;

    private final Integer trainingTimeInSeconds;

    private final Integer billableTimeInSeconds;

    private final DebugHookConfig debugHookConfig;

    private final ExperimentConfig experimentConfig;

    private final List<DebugRuleConfiguration> debugRuleConfigurations;

    private final TensorBoardOutputConfig tensorBoardOutputConfig;

    private final List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses;

    private final ProfilerConfig profilerConfig;

    private final List<ProfilerRuleConfiguration> profilerRuleConfigurations;

    private final List<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses;

    private final String profilingStatus;

    private final Map<String, String> environment;

    private DescribeTrainingJobResponse(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.tuningJobArn = builder.tuningJobArn;
        this.labelingJobArn = builder.labelingJobArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.modelArtifacts = builder.modelArtifacts;
        this.trainingJobStatus = builder.trainingJobStatus;
        this.secondaryStatus = builder.secondaryStatus;
        this.failureReason = builder.failureReason;
        this.hyperParameters = builder.hyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.creationTime = builder.creationTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.secondaryStatusTransitions = builder.secondaryStatusTransitions;
        this.finalMetricDataList = builder.finalMetricDataList;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.checkpointConfig = builder.checkpointConfig;
        this.trainingTimeInSeconds = builder.trainingTimeInSeconds;
        this.billableTimeInSeconds = builder.billableTimeInSeconds;
        this.debugHookConfig = builder.debugHookConfig;
        this.experimentConfig = builder.experimentConfig;
        this.debugRuleConfigurations = builder.debugRuleConfigurations;
        this.tensorBoardOutputConfig = builder.tensorBoardOutputConfig;
        this.debugRuleEvaluationStatuses = builder.debugRuleEvaluationStatuses;
        this.profilerConfig = builder.profilerConfig;
        this.profilerRuleConfigurations = builder.profilerRuleConfigurations;
        this.profilerRuleEvaluationStatuses = builder.profilerRuleEvaluationStatuses;
        this.profilingStatus = builder.profilingStatus;
        this.environment = builder.environment;
    }

    /**
     * <p>
     * Name of the model training job.
     * </p>
     * 
     * @return Name of the model training job.
     */
    public final String trainingJobName() {
        return trainingJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training job.
     */
    public final String trainingJobArn() {
        return trainingJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a
     * hyperparameter tuning job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was
     *         launched by a hyperparameter tuning job.
     */
    public final String tuningJobArn() {
        return tuningJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or
     * training job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the
     *         transform or training job.
     */
    public final String labelingJobArn() {
        return labelingJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AutoML job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AutoML job.
     */
    public final String autoMLJobArn() {
        return autoMLJobArn;
    }

    /**
     * <p>
     * Information about the Amazon S3 location that is configured for storing model artifacts.
     * </p>
     * 
     * @return Information about the Amazon S3 location that is configured for storing model artifacts.
     */
    public final ModelArtifacts modelArtifacts() {
        return modelArtifacts;
    }

    /**
     * <p>
     * The status of the training job.
     * </p>
     * <p>
     * Amazon SageMaker provides the following training job statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InProgress</code> - The training is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code> - The training job has completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
     * <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopping</code> - The training job is stopping.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code> - The training job has stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more detailed information, see <code>SecondaryStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingJobStatus}
     * will return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the training job.</p>
     *         <p>
     *         Amazon SageMaker provides the following training job statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>InProgress</code> - The training is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code> - The training job has completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
     *         <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - The training job is stopping.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code> - The training job has stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more detailed information, see <code>SecondaryStatus</code>.
     * @see TrainingJobStatus
     */
    public final TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(trainingJobStatus);
    }

    /**
     * <p>
     * The status of the training job.
     * </p>
     * <p>
     * Amazon SageMaker provides the following training job statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InProgress</code> - The training is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code> - The training job has completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
     * <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopping</code> - The training job is stopping.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code> - The training job has stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more detailed information, see <code>SecondaryStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingJobStatus}
     * will return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the training job.</p>
     *         <p>
     *         Amazon SageMaker provides the following training job statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>InProgress</code> - The training is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code> - The training job has completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
     *         <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - The training job is stopping.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code> - The training job has stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more detailed information, see <code>SecondaryStatus</code>.
     * @see TrainingJobStatus
     */
    public final String trainingJobStatusAsString() {
        return trainingJobStatus;
    }

    /**
     * <p>
     * Provides detailed information about the state of the training job. For detailed information on the secondary
     * status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.
     * </p>
     * <p>
     * Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
     * </p>
     * <dl>
     * <dt>InProgress</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Starting</code> - Starting the training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode.
     * It indicates that data is being downloaded to the ML storage volumes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Training</code> - Training is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code> - The training job has completed.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
     * <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Stopped</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code> - The training job has stopped.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Stopping</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Stopping</code> - Stopping the training job.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <important>
     * <p>
     * Valid values for <code>SecondaryStatus</code> are subject to change.
     * </p>
     * </important>
     * <p>
     * We no longer support the following secondary statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LaunchingMLInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PreparingTrainingStack</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DownloadingTrainingImage</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #secondaryStatus}
     * will return {@link SecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #secondaryStatusAsString}.
     * </p>
     * 
     * @return Provides detailed information about the state of the training job. For detailed information on the
     *         secondary status of the training job, see <code>StatusMessage</code> under
     *         <a>SecondaryStatusTransition</a>.</p>
     *         <p>
     *         Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
     *         </p>
     *         <dl>
     *         <dt>InProgress</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Starting</code> - Starting the training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input
     *         mode. It indicates that data is being downloaded to the ML storage volumes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Training</code> - Training is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3
     *         location.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code> - The training job has completed.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
     *         <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Stopped</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code> - The training job has stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Stopping</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - Stopping the training job.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         </dl>
     *         <important>
     *         <p>
     *         Valid values for <code>SecondaryStatus</code> are subject to change.
     *         </p>
     *         </important>
     *         <p>
     *         We no longer support the following secondary statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LaunchingMLInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PreparingTrainingStack</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DownloadingTrainingImage</code>
     *         </p>
     *         </li>
     * @see SecondaryStatus
     */
    public final SecondaryStatus secondaryStatus() {
        return SecondaryStatus.fromValue(secondaryStatus);
    }

    /**
     * <p>
     * Provides detailed information about the state of the training job. For detailed information on the secondary
     * status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.
     * </p>
     * <p>
     * Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
     * </p>
     * <dl>
     * <dt>InProgress</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Starting</code> - Starting the training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode.
     * It indicates that data is being downloaded to the ML storage volumes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Training</code> - Training is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code> - The training job has completed.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
     * <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Stopped</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code> - The training job has stopped.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Stopping</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>Stopping</code> - Stopping the training job.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <important>
     * <p>
     * Valid values for <code>SecondaryStatus</code> are subject to change.
     * </p>
     * </important>
     * <p>
     * We no longer support the following secondary statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LaunchingMLInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PreparingTrainingStack</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DownloadingTrainingImage</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #secondaryStatus}
     * will return {@link SecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #secondaryStatusAsString}.
     * </p>
     * 
     * @return Provides detailed information about the state of the training job. For detailed information on the
     *         secondary status of the training job, see <code>StatusMessage</code> under
     *         <a>SecondaryStatusTransition</a>.</p>
     *         <p>
     *         Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
     *         </p>
     *         <dl>
     *         <dt>InProgress</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Starting</code> - Starting the training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input
     *         mode. It indicates that data is being downloaded to the ML storage volumes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Training</code> - Training is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3
     *         location.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code> - The training job has completed.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
     *         <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Stopped</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code> - The training job has stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Stopping</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - Stopping the training job.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         </dl>
     *         <important>
     *         <p>
     *         Valid values for <code>SecondaryStatus</code> are subject to change.
     *         </p>
     *         </important>
     *         <p>
     *         We no longer support the following secondary statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LaunchingMLInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PreparingTrainingStack</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DownloadingTrainingImage</code>
     *         </p>
     *         </li>
     * @see SecondaryStatus
     */
    public final String secondaryStatusAsString() {
        return secondaryStatus;
    }

    /**
     * <p>
     * If the training job failed, the reason it failed.
     * </p>
     * 
     * @return If the training job failed, the reason it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * Returns true if the HyperParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Algorithm-specific parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHyperParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Algorithm-specific parameters.
     */
    public final Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * <p>
     * Information about the algorithm used for training, and algorithm metadata.
     * </p>
     * 
     * @return Information about the algorithm used for training, and algorithm metadata.
     */
    public final AlgorithmSpecification algorithmSpecification() {
        return algorithmSpecification;
    }

    /**
     * <p>
     * The AWS Identity and Access Management (IAM) role configured for the training job.
     * </p>
     * 
     * @return The AWS Identity and Access Management (IAM) role configured for the training job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the InputDataConfig property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Channel</code> objects that describes each data input channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputDataConfig()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Channel</code> objects that describes each data input channel.
     */
    public final List<Channel> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates
     * subfolders for model artifacts.
     * </p>
     * 
     * @return The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker
     *         creates subfolders for model artifacts.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * Resources, including ML compute instances and ML storage volumes, that are configured for model training.
     * </p>
     * 
     * @return Resources, including ML compute instances and ML storage volumes, that are configured for model training.
     */
    public final ResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon
     * Virtual Private Cloud</a>.
     * </p>
     * 
     * @return A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more
     *         information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect
     *         Training Jobs by Using an Amazon Virtual Private Cloud</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Specifies a limit to how long a model training job can run. It also specifies the maximum time to wait for a spot
     * instance. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model
     * training costs.
     * </p>
     * <p>
     * To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination
     * for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of
     * training are not lost.
     * </p>
     * 
     * @return Specifies a limit to how long a model training job can run. It also specifies the maximum time to wait
     *         for a spot instance. When the job reaches the time limit, Amazon SageMaker ends the training job. Use
     *         this API to cap model training costs.</p>
     *         <p>
     *         To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
     *         termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so
     *         the results of training are not lost.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * <p>
     * A timestamp that indicates when the training job was created.
     * </p>
     * 
     * @return A timestamp that indicates when the training job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Indicates the time when the training job starts on training instances. You are billed for the time interval
     * between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later
     * than this time. The difference is due to the time it takes to download the training data and to the size of the
     * training container.
     * </p>
     * 
     * @return Indicates the time when the training job starts on training instances. You are billed for the time
     *         interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch
     *         Logs might be later than this time. The difference is due to the time it takes to download the training
     *         data and to the size of the training container.
     */
    public final Instant trainingStartTime() {
        return trainingStartTime;
    }

    /**
     * <p>
     * Indicates the time when the training job ends on training instances. You are billed for the time interval between
     * the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time
     * after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job
     * failure.
     * </p>
     * 
     * @return Indicates the time when the training job ends on training instances. You are billed for the time interval
     *         between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs,
     *         this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon
     *         SageMaker detects a job failure.
     */
    public final Instant trainingEndTime() {
        return trainingEndTime;
    }

    /**
     * <p>
     * A timestamp that indicates when the status of the training job was last modified.
     * </p>
     * 
     * @return A timestamp that indicates when the status of the training job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns true if the SecondaryStatusTransitions property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasSecondaryStatusTransitions() {
        return secondaryStatusTransitions != null && !(secondaryStatusTransitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A history of all of the secondary statuses that the training job has transitioned through.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondaryStatusTransitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A history of all of the secondary statuses that the training job has transitioned through.
     */
    public final List<SecondaryStatusTransition> secondaryStatusTransitions() {
        return secondaryStatusTransitions;
    }

    /**
     * Returns true if the FinalMetricDataList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFinalMetricDataList() {
        return finalMetricDataList != null && !(finalMetricDataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the
     * training algorithm emitted to Amazon CloudWatch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFinalMetricDataList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that
     *         the training algorithm emitted to Amazon CloudWatch.
     */
    public final List<MetricData> finalMetricDataList() {
        return finalMetricDataList;
    }

    /**
     * <p>
     * If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster
     * for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are
     * configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the
     * specified VPC, but the training container does not have network access.
     * </p>
     * 
     * @return If you want to allow inbound or outbound network calls, except for calls between peers within a training
     *         cluster for distributed training, choose <code>True</code>. If you enable network isolation for training
     *         jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model
     *         artifacts through the specified VPC, but the training container does not have network access.
     */
    public final Boolean enableNetworkIsolation() {
        return enableNetworkIsolation;
    }

    /**
     * <p>
     * To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>.
     * Encryption provides greater security for distributed training, but training might take longer. How long it takes
     * depends on the amount of communication between compute instances, especially if you use a deep learning
     * algorithms in distributed training.
     * </p>
     * 
     * @return To encrypt all communications between ML compute instances in distributed training, choose
     *         <code>True</code>. Encryption provides greater security for distributed training, but training might take
     *         longer. How long it takes depends on the amount of communication between compute instances, especially if
     *         you use a deep learning algorithms in distributed training.
     */
    public final Boolean enableInterContainerTrafficEncryption() {
        return enableInterContainerTrafficEncryption;
    }

    /**
     * <p>
     * A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).
     * </p>
     * 
     * @return A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (
     *         <code>False</code>).
     */
    public final Boolean enableManagedSpotTraining() {
        return enableManagedSpotTraining;
    }

    /**
     * Returns the value of the CheckpointConfig property for this object.
     * 
     * @return The value of the CheckpointConfig property for this object.
     */
    public final CheckpointConfig checkpointConfig() {
        return checkpointConfig;
    }

    /**
     * <p>
     * The training time in seconds.
     * </p>
     * 
     * @return The training time in seconds.
     */
    public final Integer trainingTimeInSeconds() {
        return trainingTimeInSeconds;
    }

    /**
     * <p>
     * The billable time in seconds. Billable time refers to the absolute wall-clock time.
     * </p>
     * <p>
     * Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your
     * training cluster to get the total compute time Amazon SageMaker will bill you if you run distributed training.
     * The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .
     * </p>
     * <p>
     * You can calculate the savings from using managed spot training using the formula
     * <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if
     * <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.
     * </p>
     * 
     * @return The billable time in seconds. Billable time refers to the absolute wall-clock time.</p>
     *         <p>
     *         Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in
     *         your training cluster to get the total compute time Amazon SageMaker will bill you if you run distributed
     *         training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .
     *         </p>
     *         <p>
     *         You can calculate the savings from using managed spot training using the formula
     *         <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if
     *         <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is
     *         80%.
     */
    public final Integer billableTimeInSeconds() {
        return billableTimeInSeconds;
    }

    /**
     * Returns the value of the DebugHookConfig property for this object.
     * 
     * @return The value of the DebugHookConfig property for this object.
     */
    public final DebugHookConfig debugHookConfig() {
        return debugHookConfig;
    }

    /**
     * Returns the value of the ExperimentConfig property for this object.
     * 
     * @return The value of the ExperimentConfig property for this object.
     */
    public final ExperimentConfig experimentConfig() {
        return experimentConfig;
    }

    /**
     * Returns true if the DebugRuleConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDebugRuleConfigurations() {
        return debugRuleConfigurations != null && !(debugRuleConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for Debugger rules for debugging output tensors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDebugRuleConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration information for Debugger rules for debugging output tensors.
     */
    public final List<DebugRuleConfiguration> debugRuleConfigurations() {
        return debugRuleConfigurations;
    }

    /**
     * Returns the value of the TensorBoardOutputConfig property for this object.
     * 
     * @return The value of the TensorBoardOutputConfig property for this object.
     */
    public final TensorBoardOutputConfig tensorBoardOutputConfig() {
        return tensorBoardOutputConfig;
    }

    /**
     * Returns true if the DebugRuleEvaluationStatuses property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasDebugRuleEvaluationStatuses() {
        return debugRuleEvaluationStatuses != null && !(debugRuleEvaluationStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Evaluation status of Debugger rules for debugging on a training job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDebugRuleEvaluationStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Evaluation status of Debugger rules for debugging on a training job.
     */
    public final List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses() {
        return debugRuleEvaluationStatuses;
    }

    /**
     * Returns the value of the ProfilerConfig property for this object.
     * 
     * @return The value of the ProfilerConfig property for this object.
     */
    public final ProfilerConfig profilerConfig() {
        return profilerConfig;
    }

    /**
     * Returns true if the ProfilerRuleConfigurations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasProfilerRuleConfigurations() {
        return profilerRuleConfigurations != null && !(profilerRuleConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for Debugger rules for profiling system and framework metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProfilerRuleConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration information for Debugger rules for profiling system and framework metrics.
     */
    public final List<ProfilerRuleConfiguration> profilerRuleConfigurations() {
        return profilerRuleConfigurations;
    }

    /**
     * Returns true if the ProfilerRuleEvaluationStatuses property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasProfilerRuleEvaluationStatuses() {
        return profilerRuleEvaluationStatuses != null && !(profilerRuleEvaluationStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Evaluation status of Debugger rules for profiling on a training job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProfilerRuleEvaluationStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Evaluation status of Debugger rules for profiling on a training job.
     */
    public final List<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses() {
        return profilerRuleEvaluationStatuses;
    }

    /**
     * <p>
     * Profiling status of a training job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profilingStatus}
     * will return {@link ProfilingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #profilingStatusAsString}.
     * </p>
     * 
     * @return Profiling status of a training job.
     * @see ProfilingStatus
     */
    public final ProfilingStatus profilingStatus() {
        return ProfilingStatus.fromValue(profilingStatus);
    }

    /**
     * <p>
     * Profiling status of a training job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profilingStatus}
     * will return {@link ProfilingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #profilingStatusAsString}.
     * </p>
     * 
     * @return Profiling status of a training job.
     * @see ProfilingStatus
     */
    public final String profilingStatusAsString() {
        return profilingStatus;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The environment variables to set in the Docker container.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(tuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryStatusTransitions() ? secondaryStatusTransitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFinalMetricDataList() ? finalMetricDataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(billableTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(debugHookConfig());
        hashCode = 31 * hashCode + Objects.hashCode(experimentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasDebugRuleConfigurations() ? debugRuleConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tensorBoardOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasDebugRuleEvaluationStatuses() ? debugRuleEvaluationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(profilerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfilerRuleConfigurations() ? profilerRuleConfigurations() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasProfilerRuleEvaluationStatuses() ? profilerRuleEvaluationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(profilingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrainingJobResponse)) {
            return false;
        }
        DescribeTrainingJobResponse other = (DescribeTrainingJobResponse) obj;
        return Objects.equals(trainingJobName(), other.trainingJobName())
                && Objects.equals(trainingJobArn(), other.trainingJobArn())
                && Objects.equals(tuningJobArn(), other.tuningJobArn())
                && Objects.equals(labelingJobArn(), other.labelingJobArn())
                && Objects.equals(autoMLJobArn(), other.autoMLJobArn())
                && Objects.equals(modelArtifacts(), other.modelArtifacts())
                && Objects.equals(trainingJobStatusAsString(), other.trainingJobStatusAsString())
                && Objects.equals(secondaryStatusAsString(), other.secondaryStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters())
                && Objects.equals(algorithmSpecification(), other.algorithmSpecification())
                && Objects.equals(roleArn(), other.roleArn()) && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(resourceConfig(), other.resourceConfig()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(trainingStartTime(), other.trainingStartTime())
                && Objects.equals(trainingEndTime(), other.trainingEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && hasSecondaryStatusTransitions() == other.hasSecondaryStatusTransitions()
                && Objects.equals(secondaryStatusTransitions(), other.secondaryStatusTransitions())
                && hasFinalMetricDataList() == other.hasFinalMetricDataList()
                && Objects.equals(finalMetricDataList(), other.finalMetricDataList())
                && Objects.equals(enableNetworkIsolation(), other.enableNetworkIsolation())
                && Objects.equals(enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption())
                && Objects.equals(enableManagedSpotTraining(), other.enableManagedSpotTraining())
                && Objects.equals(checkpointConfig(), other.checkpointConfig())
                && Objects.equals(trainingTimeInSeconds(), other.trainingTimeInSeconds())
                && Objects.equals(billableTimeInSeconds(), other.billableTimeInSeconds())
                && Objects.equals(debugHookConfig(), other.debugHookConfig())
                && Objects.equals(experimentConfig(), other.experimentConfig())
                && hasDebugRuleConfigurations() == other.hasDebugRuleConfigurations()
                && Objects.equals(debugRuleConfigurations(), other.debugRuleConfigurations())
                && Objects.equals(tensorBoardOutputConfig(), other.tensorBoardOutputConfig())
                && hasDebugRuleEvaluationStatuses() == other.hasDebugRuleEvaluationStatuses()
                && Objects.equals(debugRuleEvaluationStatuses(), other.debugRuleEvaluationStatuses())
                && Objects.equals(profilerConfig(), other.profilerConfig())
                && hasProfilerRuleConfigurations() == other.hasProfilerRuleConfigurations()
                && Objects.equals(profilerRuleConfigurations(), other.profilerRuleConfigurations())
                && hasProfilerRuleEvaluationStatuses() == other.hasProfilerRuleEvaluationStatuses()
                && Objects.equals(profilerRuleEvaluationStatuses(), other.profilerRuleEvaluationStatuses())
                && Objects.equals(profilingStatusAsString(), other.profilingStatusAsString())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeTrainingJobResponse")
                .add("TrainingJobName", trainingJobName())
                .add("TrainingJobArn", trainingJobArn())
                .add("TuningJobArn", tuningJobArn())
                .add("LabelingJobArn", labelingJobArn())
                .add("AutoMLJobArn", autoMLJobArn())
                .add("ModelArtifacts", modelArtifacts())
                .add("TrainingJobStatus", trainingJobStatusAsString())
                .add("SecondaryStatus", secondaryStatusAsString())
                .add("FailureReason", failureReason())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null)
                .add("AlgorithmSpecification", algorithmSpecification())
                .add("RoleArn", roleArn())
                .add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null)
                .add("OutputDataConfig", outputDataConfig())
                .add("ResourceConfig", resourceConfig())
                .add("VpcConfig", vpcConfig())
                .add("StoppingCondition", stoppingCondition())
                .add("CreationTime", creationTime())
                .add("TrainingStartTime", trainingStartTime())
                .add("TrainingEndTime", trainingEndTime())
                .add("LastModifiedTime", lastModifiedTime())
                .add("SecondaryStatusTransitions", hasSecondaryStatusTransitions() ? secondaryStatusTransitions() : null)
                .add("FinalMetricDataList", hasFinalMetricDataList() ? finalMetricDataList() : null)
                .add("EnableNetworkIsolation", enableNetworkIsolation())
                .add("EnableInterContainerTrafficEncryption", enableInterContainerTrafficEncryption())
                .add("EnableManagedSpotTraining", enableManagedSpotTraining())
                .add("CheckpointConfig", checkpointConfig())
                .add("TrainingTimeInSeconds", trainingTimeInSeconds())
                .add("BillableTimeInSeconds", billableTimeInSeconds())
                .add("DebugHookConfig", debugHookConfig())
                .add("ExperimentConfig", experimentConfig())
                .add("DebugRuleConfigurations", hasDebugRuleConfigurations() ? debugRuleConfigurations() : null)
                .add("TensorBoardOutputConfig", tensorBoardOutputConfig())
                .add("DebugRuleEvaluationStatuses", hasDebugRuleEvaluationStatuses() ? debugRuleEvaluationStatuses() : null)
                .add("ProfilerConfig", profilerConfig())
                .add("ProfilerRuleConfigurations", hasProfilerRuleConfigurations() ? profilerRuleConfigurations() : null)
                .add("ProfilerRuleEvaluationStatuses",
                        hasProfilerRuleEvaluationStatuses() ? profilerRuleEvaluationStatuses() : null)
                .add("ProfilingStatus", profilingStatusAsString()).add("Environment", hasEnvironment() ? environment() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJobName":
            return Optional.ofNullable(clazz.cast(trainingJobName()));
        case "TrainingJobArn":
            return Optional.ofNullable(clazz.cast(trainingJobArn()));
        case "TuningJobArn":
            return Optional.ofNullable(clazz.cast(tuningJobArn()));
        case "LabelingJobArn":
            return Optional.ofNullable(clazz.cast(labelingJobArn()));
        case "AutoMLJobArn":
            return Optional.ofNullable(clazz.cast(autoMLJobArn()));
        case "ModelArtifacts":
            return Optional.ofNullable(clazz.cast(modelArtifacts()));
        case "TrainingJobStatus":
            return Optional.ofNullable(clazz.cast(trainingJobStatusAsString()));
        case "SecondaryStatus":
            return Optional.ofNullable(clazz.cast(secondaryStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "HyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "AlgorithmSpecification":
            return Optional.ofNullable(clazz.cast(algorithmSpecification()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TrainingStartTime":
            return Optional.ofNullable(clazz.cast(trainingStartTime()));
        case "TrainingEndTime":
            return Optional.ofNullable(clazz.cast(trainingEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "SecondaryStatusTransitions":
            return Optional.ofNullable(clazz.cast(secondaryStatusTransitions()));
        case "FinalMetricDataList":
            return Optional.ofNullable(clazz.cast(finalMetricDataList()));
        case "EnableNetworkIsolation":
            return Optional.ofNullable(clazz.cast(enableNetworkIsolation()));
        case "EnableInterContainerTrafficEncryption":
            return Optional.ofNullable(clazz.cast(enableInterContainerTrafficEncryption()));
        case "EnableManagedSpotTraining":
            return Optional.ofNullable(clazz.cast(enableManagedSpotTraining()));
        case "CheckpointConfig":
            return Optional.ofNullable(clazz.cast(checkpointConfig()));
        case "TrainingTimeInSeconds":
            return Optional.ofNullable(clazz.cast(trainingTimeInSeconds()));
        case "BillableTimeInSeconds":
            return Optional.ofNullable(clazz.cast(billableTimeInSeconds()));
        case "DebugHookConfig":
            return Optional.ofNullable(clazz.cast(debugHookConfig()));
        case "ExperimentConfig":
            return Optional.ofNullable(clazz.cast(experimentConfig()));
        case "DebugRuleConfigurations":
            return Optional.ofNullable(clazz.cast(debugRuleConfigurations()));
        case "TensorBoardOutputConfig":
            return Optional.ofNullable(clazz.cast(tensorBoardOutputConfig()));
        case "DebugRuleEvaluationStatuses":
            return Optional.ofNullable(clazz.cast(debugRuleEvaluationStatuses()));
        case "ProfilerConfig":
            return Optional.ofNullable(clazz.cast(profilerConfig()));
        case "ProfilerRuleConfigurations":
            return Optional.ofNullable(clazz.cast(profilerRuleConfigurations()));
        case "ProfilerRuleEvaluationStatuses":
            return Optional.ofNullable(clazz.cast(profilerRuleEvaluationStatuses()));
        case "ProfilingStatus":
            return Optional.ofNullable(clazz.cast(profilingStatusAsString()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrainingJobResponse, T> g) {
        return obj -> g.apply((DescribeTrainingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrainingJobResponse> {
        /**
         * <p>
         * Name of the model training job.
         * </p>
         * 
         * @param trainingJobName
         *        Name of the model training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobName(String trainingJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training job.
         * </p>
         * 
         * @param trainingJobArn
         *        The Amazon Resource Name (ARN) of the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobArn(String trainingJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched
         * by a hyperparameter tuning job.
         * </p>
         * 
         * @param tuningJobArn
         *        The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was
         *        launched by a hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuningJobArn(String tuningJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform
         * or training job.
         * </p>
         * 
         * @param labelingJobArn
         *        The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the
         *        transform or training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobArn(String labelingJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AutoML job.
         * </p>
         * 
         * @param autoMLJobArn
         *        The Amazon Resource Name (ARN) of an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArn(String autoMLJobArn);

        /**
         * <p>
         * Information about the Amazon S3 location that is configured for storing model artifacts.
         * </p>
         * 
         * @param modelArtifacts
         *        Information about the Amazon S3 location that is configured for storing model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArtifacts(ModelArtifacts modelArtifacts);

        /**
         * <p>
         * Information about the Amazon S3 location that is configured for storing model artifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelArtifacts.Builder} avoiding the need to
         * create one manually via {@link ModelArtifacts#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #modelArtifacts(ModelArtifacts)}.
         * 
         * @param modelArtifacts
         *        a consumer that will call methods on {@link ModelArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelArtifacts(ModelArtifacts)
         */
        default Builder modelArtifacts(Consumer<ModelArtifacts.Builder> modelArtifacts) {
            return modelArtifacts(ModelArtifacts.builder().applyMutation(modelArtifacts).build());
        }

        /**
         * <p>
         * The status of the training job.
         * </p>
         * <p>
         * Amazon SageMaker provides the following training job statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>InProgress</code> - The training is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code> - The training job has completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
         * <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopping</code> - The training job is stopping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code> - The training job has stopped.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more detailed information, see <code>SecondaryStatus</code>.
         * </p>
         * 
         * @param trainingJobStatus
         *        The status of the training job.</p>
         *        <p>
         *        Amazon SageMaker provides the following training job statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>InProgress</code> - The training is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code> - The training job has completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
         *        <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - The training job is stopping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code> - The training job has stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more detailed information, see <code>SecondaryStatus</code>.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder trainingJobStatus(String trainingJobStatus);

        /**
         * <p>
         * The status of the training job.
         * </p>
         * <p>
         * Amazon SageMaker provides the following training job statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>InProgress</code> - The training is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code> - The training job has completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
         * <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopping</code> - The training job is stopping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code> - The training job has stopped.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more detailed information, see <code>SecondaryStatus</code>.
         * </p>
         * 
         * @param trainingJobStatus
         *        The status of the training job.</p>
         *        <p>
         *        Amazon SageMaker provides the following training job statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>InProgress</code> - The training is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code> - The training job has completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The training job has failed. To see the reason for the failure, see the
         *        <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - The training job is stopping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code> - The training job has stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more detailed information, see <code>SecondaryStatus</code>.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder trainingJobStatus(TrainingJobStatus trainingJobStatus);

        /**
         * <p>
         * Provides detailed information about the state of the training job. For detailed information on the secondary
         * status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.
         * </p>
         * <p>
         * Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
         * </p>
         * <dl>
         * <dt>InProgress</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Starting</code> - Starting the training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input
         * mode. It indicates that data is being downloaded to the ML storage volumes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Training</code> - Training is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code> - The training job has completed.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
         * <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Stopped</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code> - The training job has stopped.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Stopping</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Stopping</code> - Stopping the training job.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * <important>
         * <p>
         * Valid values for <code>SecondaryStatus</code> are subject to change.
         * </p>
         * </important>
         * <p>
         * We no longer support the following secondary statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LaunchingMLInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PreparingTrainingStack</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DownloadingTrainingImage</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param secondaryStatus
         *        Provides detailed information about the state of the training job. For detailed information on the
         *        secondary status of the training job, see <code>StatusMessage</code> under
         *        <a>SecondaryStatusTransition</a>.</p>
         *        <p>
         *        Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
         *        </p>
         *        <dl>
         *        <dt>InProgress</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Starting</code> - Starting the training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training
         *        input mode. It indicates that data is being downloaded to the ML storage volumes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Training</code> - Training is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Interrupted</code> - The job stopped because the managed spot training instances were
         *        interrupted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3
         *        location.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code> - The training job has completed.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
         *        <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Stopped</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code> - The training job has stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Stopping</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - Stopping the training job.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        </dl>
         *        <important>
         *        <p>
         *        Valid values for <code>SecondaryStatus</code> are subject to change.
         *        </p>
         *        </important>
         *        <p>
         *        We no longer support the following secondary statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LaunchingMLInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PreparingTrainingStack</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DownloadingTrainingImage</code>
         *        </p>
         *        </li>
         * @see SecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryStatus
         */
        Builder secondaryStatus(String secondaryStatus);

        /**
         * <p>
         * Provides detailed information about the state of the training job. For detailed information on the secondary
         * status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.
         * </p>
         * <p>
         * Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
         * </p>
         * <dl>
         * <dt>InProgress</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Starting</code> - Starting the training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input
         * mode. It indicates that data is being downloaded to the ML storage volumes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Training</code> - Training is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code> - The training job has completed.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
         * <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Stopped</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code> - The training job has stopped.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Stopping</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>Stopping</code> - Stopping the training job.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * <important>
         * <p>
         * Valid values for <code>SecondaryStatus</code> are subject to change.
         * </p>
         * </important>
         * <p>
         * We no longer support the following secondary statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LaunchingMLInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PreparingTrainingStack</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DownloadingTrainingImage</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param secondaryStatus
         *        Provides detailed information about the state of the training job. For detailed information on the
         *        secondary status of the training job, see <code>StatusMessage</code> under
         *        <a>SecondaryStatusTransition</a>.</p>
         *        <p>
         *        Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:
         *        </p>
         *        <dl>
         *        <dt>InProgress</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Starting</code> - Starting the training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training
         *        input mode. It indicates that data is being downloaded to the ML storage volumes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Training</code> - Training is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Interrupted</code> - The job stopped because the managed spot training instances were
         *        interrupted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3
         *        location.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code> - The training job has completed.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The training job has failed. The reason for the failure is returned in the
         *        <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Stopped</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code> - The training job has stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Stopping</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - Stopping the training job.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        </dl>
         *        <important>
         *        <p>
         *        Valid values for <code>SecondaryStatus</code> are subject to change.
         *        </p>
         *        </important>
         *        <p>
         *        We no longer support the following secondary statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LaunchingMLInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PreparingTrainingStack</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DownloadingTrainingImage</code>
         *        </p>
         *        </li>
         * @see SecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryStatus
         */
        Builder secondaryStatus(SecondaryStatus secondaryStatus);

        /**
         * <p>
         * If the training job failed, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If the training job failed, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Algorithm-specific parameters.
         * </p>
         * 
         * @param hyperParameters
         *        Algorithm-specific parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * Information about the algorithm used for training, and algorithm metadata.
         * </p>
         * 
         * @param algorithmSpecification
         *        Information about the algorithm used for training, and algorithm metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification);

        /**
         * <p>
         * Information about the algorithm used for training, and algorithm metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link AlgorithmSpecification.Builder} avoiding the
         * need to create one manually via {@link AlgorithmSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlgorithmSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #algorithmSpecification(AlgorithmSpecification)}.
         * 
         * @param algorithmSpecification
         *        a consumer that will call methods on {@link AlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmSpecification(AlgorithmSpecification)
         */
        default Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return algorithmSpecification(AlgorithmSpecification.builder().applyMutation(algorithmSpecification).build());
        }

        /**
         * <p>
         * The AWS Identity and Access Management (IAM) role configured for the training job.
         * </p>
         * 
         * @param roleArn
         *        The AWS Identity and Access Management (IAM) role configured for the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An array of <code>Channel</code> objects that describes each data input channel.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <code>Channel</code> objects that describes each data input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<Channel> inputDataConfig);

        /**
         * <p>
         * An array of <code>Channel</code> objects that describes each data input channel.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <code>Channel</code> objects that describes each data input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Channel... inputDataConfig);

        /**
         * <p>
         * An array of <code>Channel</code> objects that describes each data input channel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Channel>.Builder} avoiding the need to
         * create one manually via {@link List<Channel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Channel>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(List<Channel>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link List<Channel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(List<Channel>)
         */
        Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig);

        /**
         * <p>
         * The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker
         * creates subfolders for model artifacts.
         * </p>
         * 
         * @param outputDataConfig
         *        The S3 path where model artifacts that you configured when creating the job are stored. Amazon
         *        SageMaker creates subfolders for model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker
         * creates subfolders for model artifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputDataConfig.Builder} avoiding the need to
         * create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * Resources, including ML compute instances and ML storage volumes, that are configured for model training.
         * </p>
         * 
         * @param resourceConfig
         *        Resources, including ML compute instances and ML storage volumes, that are configured for model
         *        training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(ResourceConfig resourceConfig);

        /**
         * <p>
         * Resources, including ML compute instances and ML storage volumes, that are configured for model training.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceConfig.Builder} avoiding the need to
         * create one manually via {@link ResourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceConfig(ResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link ResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(ResourceConfig)
         */
        default Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return resourceConfig(ResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information,
         * see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using
         * an Amazon Virtual Private Cloud</a>.
         * </p>
         * 
         * @param vpcConfig
         *        A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more
         *        information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect
         *        Training Jobs by Using an Amazon Virtual Private Cloud</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information,
         * see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using
         * an Amazon Virtual Private Cloud</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Specifies a limit to how long a model training job can run. It also specifies the maximum time to wait for a
         * spot instance. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to
         * cap model training costs.
         * </p>
         * <p>
         * To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
         * termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the
         * results of training are not lost.
         * </p>
         * 
         * @param stoppingCondition
         *        Specifies a limit to how long a model training job can run. It also specifies the maximum time to wait
         *        for a spot instance. When the job reaches the time limit, Amazon SageMaker ends the training job. Use
         *        this API to cap model training costs.</p>
         *        <p>
         *        To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
         *        termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so
         *        the results of training are not lost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * Specifies a limit to how long a model training job can run. It also specifies the maximum time to wait for a
         * spot instance. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to
         * cap model training costs.
         * </p>
         * <p>
         * To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
         * termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the
         * results of training are not lost.
         * </p>
         * This is a convenience that creates an instance of the {@link StoppingCondition.Builder} avoiding the need to
         * create one manually via {@link StoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the training job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when the training job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Indicates the time when the training job starts on training instances. You are billed for the time interval
         * between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be
         * later than this time. The difference is due to the time it takes to download the training data and to the
         * size of the training container.
         * </p>
         * 
         * @param trainingStartTime
         *        Indicates the time when the training job starts on training instances. You are billed for the time
         *        interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch
         *        Logs might be later than this time. The difference is due to the time it takes to download the
         *        training data and to the size of the training container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingStartTime(Instant trainingStartTime);

        /**
         * <p>
         * Indicates the time when the training job ends on training instances. You are billed for the time interval
         * between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this
         * is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
         * detects a job failure.
         * </p>
         * 
         * @param trainingEndTime
         *        Indicates the time when the training job ends on training instances. You are billed for the time
         *        interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and
         *        stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time
         *        when Amazon SageMaker detects a job failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingEndTime(Instant trainingEndTime);

        /**
         * <p>
         * A timestamp that indicates when the status of the training job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that indicates when the status of the training job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A history of all of the secondary statuses that the training job has transitioned through.
         * </p>
         * 
         * @param secondaryStatusTransitions
         *        A history of all of the secondary statuses that the training job has transitioned through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions);

        /**
         * <p>
         * A history of all of the secondary statuses that the training job has transitioned through.
         * </p>
         * 
         * @param secondaryStatusTransitions
         *        A history of all of the secondary statuses that the training job has transitioned through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryStatusTransitions(SecondaryStatusTransition... secondaryStatusTransitions);

        /**
         * <p>
         * A history of all of the secondary statuses that the training job has transitioned through.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecondaryStatusTransition>.Builder}
         * avoiding the need to create one manually via {@link List<SecondaryStatusTransition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecondaryStatusTransition>.Builder#build()} is called
         * immediately and its result is passed to {@link #secondaryStatusTransitions(List<SecondaryStatusTransition>)}.
         * 
         * @param secondaryStatusTransitions
         *        a consumer that will call methods on {@link List<SecondaryStatusTransition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryStatusTransitions(List<SecondaryStatusTransition>)
         */
        Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder>... secondaryStatusTransitions);

        /**
         * <p>
         * A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the
         * training algorithm emitted to Amazon CloudWatch.
         * </p>
         * 
         * @param finalMetricDataList
         *        A collection of <code>MetricData</code> objects that specify the names, values, and dates and times
         *        that the training algorithm emitted to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalMetricDataList(Collection<MetricData> finalMetricDataList);

        /**
         * <p>
         * A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the
         * training algorithm emitted to Amazon CloudWatch.
         * </p>
         * 
         * @param finalMetricDataList
         *        A collection of <code>MetricData</code> objects that specify the names, values, and dates and times
         *        that the training algorithm emitted to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalMetricDataList(MetricData... finalMetricDataList);

        /**
         * <p>
         * A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the
         * training algorithm emitted to Amazon CloudWatch.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricData>.Builder} avoiding the need to
         * create one manually via {@link List<MetricData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricData>.Builder#build()} is called immediately and its
         * result is passed to {@link #finalMetricDataList(List<MetricData>)}.
         * 
         * @param finalMetricDataList
         *        a consumer that will call methods on {@link List<MetricData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalMetricDataList(List<MetricData>)
         */
        Builder finalMetricDataList(Consumer<MetricData.Builder>... finalMetricDataList);

        /**
         * <p>
         * If you want to allow inbound or outbound network calls, except for calls between peers within a training
         * cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs
         * that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts
         * through the specified VPC, but the training container does not have network access.
         * </p>
         * 
         * @param enableNetworkIsolation
         *        If you want to allow inbound or outbound network calls, except for calls between peers within a
         *        training cluster for distributed training, choose <code>True</code>. If you enable network isolation
         *        for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer
         *        data and model artifacts through the specified VPC, but the training container does not have network
         *        access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNetworkIsolation(Boolean enableNetworkIsolation);

        /**
         * <p>
         * To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>.
         * Encryption provides greater security for distributed training, but training might take longer. How long it
         * takes depends on the amount of communication between compute instances, especially if you use a deep learning
         * algorithms in distributed training.
         * </p>
         * 
         * @param enableInterContainerTrafficEncryption
         *        To encrypt all communications between ML compute instances in distributed training, choose
         *        <code>True</code>. Encryption provides greater security for distributed training, but training might
         *        take longer. How long it takes depends on the amount of communication between compute instances,
         *        especially if you use a deep learning algorithms in distributed training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption);

        /**
         * <p>
         * A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>
         * ).
         * </p>
         * 
         * @param enableManagedSpotTraining
         *        A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (
         *        <code>False</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining);

        /**
         * Sets the value of the CheckpointConfig property for this object.
         *
         * @param checkpointConfig
         *        The new value for the CheckpointConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfig(CheckpointConfig checkpointConfig);

        /**
         * Sets the value of the CheckpointConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link CheckpointConfig.Builder} avoiding the need to
         * create one manually via {@link CheckpointConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CheckpointConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #checkpointConfig(CheckpointConfig)}.
         * 
         * @param checkpointConfig
         *        a consumer that will call methods on {@link CheckpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfig(CheckpointConfig)
         */
        default Builder checkpointConfig(Consumer<CheckpointConfig.Builder> checkpointConfig) {
            return checkpointConfig(CheckpointConfig.builder().applyMutation(checkpointConfig).build());
        }

        /**
         * <p>
         * The training time in seconds.
         * </p>
         * 
         * @param trainingTimeInSeconds
         *        The training time in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingTimeInSeconds(Integer trainingTimeInSeconds);

        /**
         * <p>
         * The billable time in seconds. Billable time refers to the absolute wall-clock time.
         * </p>
         * <p>
         * Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your
         * training cluster to get the total compute time Amazon SageMaker will bill you if you run distributed
         * training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .
         * </p>
         * <p>
         * You can calculate the savings from using managed spot training using the formula
         * <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if
         * <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.
         * </p>
         * 
         * @param billableTimeInSeconds
         *        The billable time in seconds. Billable time refers to the absolute wall-clock time.</p>
         *        <p>
         *        Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in
         *        your training cluster to get the total compute time Amazon SageMaker will bill you if you run
         *        distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .
         *        </p>
         *        <p>
         *        You can calculate the savings from using managed spot training using the formula
         *        <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if
         *        <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings
         *        is 80%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billableTimeInSeconds(Integer billableTimeInSeconds);

        /**
         * Sets the value of the DebugHookConfig property for this object.
         *
         * @param debugHookConfig
         *        The new value for the DebugHookConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugHookConfig(DebugHookConfig debugHookConfig);

        /**
         * Sets the value of the DebugHookConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link DebugHookConfig.Builder} avoiding the need to
         * create one manually via {@link DebugHookConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DebugHookConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #debugHookConfig(DebugHookConfig)}.
         * 
         * @param debugHookConfig
         *        a consumer that will call methods on {@link DebugHookConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #debugHookConfig(DebugHookConfig)
         */
        default Builder debugHookConfig(Consumer<DebugHookConfig.Builder> debugHookConfig) {
            return debugHookConfig(DebugHookConfig.builder().applyMutation(debugHookConfig).build());
        }

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * @param experimentConfig
         *        The new value for the ExperimentConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentConfig(ExperimentConfig experimentConfig);

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExperimentConfig.Builder} avoiding the need to
         * create one manually via {@link ExperimentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentConfig(ExperimentConfig)}.
         * 
         * @param experimentConfig
         *        a consumer that will call methods on {@link ExperimentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentConfig(ExperimentConfig)
         */
        default Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return experimentConfig(ExperimentConfig.builder().applyMutation(experimentConfig).build());
        }

        /**
         * <p>
         * Configuration information for Debugger rules for debugging output tensors.
         * </p>
         * 
         * @param debugRuleConfigurations
         *        Configuration information for Debugger rules for debugging output tensors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations);

        /**
         * <p>
         * Configuration information for Debugger rules for debugging output tensors.
         * </p>
         * 
         * @param debugRuleConfigurations
         *        Configuration information for Debugger rules for debugging output tensors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugRuleConfigurations(DebugRuleConfiguration... debugRuleConfigurations);

        /**
         * <p>
         * Configuration information for Debugger rules for debugging output tensors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DebugRuleConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<DebugRuleConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DebugRuleConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #debugRuleConfigurations(List<DebugRuleConfiguration>)}.
         * 
         * @param debugRuleConfigurations
         *        a consumer that will call methods on {@link List<DebugRuleConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #debugRuleConfigurations(List<DebugRuleConfiguration>)
         */
        Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder>... debugRuleConfigurations);

        /**
         * Sets the value of the TensorBoardOutputConfig property for this object.
         *
         * @param tensorBoardOutputConfig
         *        The new value for the TensorBoardOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig);

        /**
         * Sets the value of the TensorBoardOutputConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link TensorBoardOutputConfig.Builder} avoiding the
         * need to create one manually via {@link TensorBoardOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TensorBoardOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #tensorBoardOutputConfig(TensorBoardOutputConfig)}.
         * 
         * @param tensorBoardOutputConfig
         *        a consumer that will call methods on {@link TensorBoardOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tensorBoardOutputConfig(TensorBoardOutputConfig)
         */
        default Builder tensorBoardOutputConfig(Consumer<TensorBoardOutputConfig.Builder> tensorBoardOutputConfig) {
            return tensorBoardOutputConfig(TensorBoardOutputConfig.builder().applyMutation(tensorBoardOutputConfig).build());
        }

        /**
         * <p>
         * Evaluation status of Debugger rules for debugging on a training job.
         * </p>
         * 
         * @param debugRuleEvaluationStatuses
         *        Evaluation status of Debugger rules for debugging on a training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses);

        /**
         * <p>
         * Evaluation status of Debugger rules for debugging on a training job.
         * </p>
         * 
         * @param debugRuleEvaluationStatuses
         *        Evaluation status of Debugger rules for debugging on a training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugRuleEvaluationStatuses(DebugRuleEvaluationStatus... debugRuleEvaluationStatuses);

        /**
         * <p>
         * Evaluation status of Debugger rules for debugging on a training job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DebugRuleEvaluationStatus>.Builder}
         * avoiding the need to create one manually via {@link List<DebugRuleEvaluationStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DebugRuleEvaluationStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #debugRuleEvaluationStatuses(List<DebugRuleEvaluationStatus>)}
         * .
         * 
         * @param debugRuleEvaluationStatuses
         *        a consumer that will call methods on {@link List<DebugRuleEvaluationStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #debugRuleEvaluationStatuses(List<DebugRuleEvaluationStatus>)
         */
        Builder debugRuleEvaluationStatuses(Consumer<DebugRuleEvaluationStatus.Builder>... debugRuleEvaluationStatuses);

        /**
         * Sets the value of the ProfilerConfig property for this object.
         *
         * @param profilerConfig
         *        The new value for the ProfilerConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerConfig(ProfilerConfig profilerConfig);

        /**
         * Sets the value of the ProfilerConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ProfilerConfig.Builder} avoiding the need to
         * create one manually via {@link ProfilerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProfilerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #profilerConfig(ProfilerConfig)}.
         * 
         * @param profilerConfig
         *        a consumer that will call methods on {@link ProfilerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilerConfig(ProfilerConfig)
         */
        default Builder profilerConfig(Consumer<ProfilerConfig.Builder> profilerConfig) {
            return profilerConfig(ProfilerConfig.builder().applyMutation(profilerConfig).build());
        }

        /**
         * <p>
         * Configuration information for Debugger rules for profiling system and framework metrics.
         * </p>
         * 
         * @param profilerRuleConfigurations
         *        Configuration information for Debugger rules for profiling system and framework metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations);

        /**
         * <p>
         * Configuration information for Debugger rules for profiling system and framework metrics.
         * </p>
         * 
         * @param profilerRuleConfigurations
         *        Configuration information for Debugger rules for profiling system and framework metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerRuleConfigurations(ProfilerRuleConfiguration... profilerRuleConfigurations);

        /**
         * <p>
         * Configuration information for Debugger rules for profiling system and framework metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProfilerRuleConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<ProfilerRuleConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProfilerRuleConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #profilerRuleConfigurations(List<ProfilerRuleConfiguration>)}.
         * 
         * @param profilerRuleConfigurations
         *        a consumer that will call methods on {@link List<ProfilerRuleConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilerRuleConfigurations(List<ProfilerRuleConfiguration>)
         */
        Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder>... profilerRuleConfigurations);

        /**
         * <p>
         * Evaluation status of Debugger rules for profiling on a training job.
         * </p>
         * 
         * @param profilerRuleEvaluationStatuses
         *        Evaluation status of Debugger rules for profiling on a training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerRuleEvaluationStatuses(Collection<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses);

        /**
         * <p>
         * Evaluation status of Debugger rules for profiling on a training job.
         * </p>
         * 
         * @param profilerRuleEvaluationStatuses
         *        Evaluation status of Debugger rules for profiling on a training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerRuleEvaluationStatuses(ProfilerRuleEvaluationStatus... profilerRuleEvaluationStatuses);

        /**
         * <p>
         * Evaluation status of Debugger rules for profiling on a training job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProfilerRuleEvaluationStatus>.Builder}
         * avoiding the need to create one manually via {@link List<ProfilerRuleEvaluationStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProfilerRuleEvaluationStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #profilerRuleEvaluationStatuses(List<ProfilerRuleEvaluationStatus>)}.
         * 
         * @param profilerRuleEvaluationStatuses
         *        a consumer that will call methods on {@link List<ProfilerRuleEvaluationStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilerRuleEvaluationStatuses(List<ProfilerRuleEvaluationStatus>)
         */
        Builder profilerRuleEvaluationStatuses(Consumer<ProfilerRuleEvaluationStatus.Builder>... profilerRuleEvaluationStatuses);

        /**
         * <p>
         * Profiling status of a training job.
         * </p>
         * 
         * @param profilingStatus
         *        Profiling status of a training job.
         * @see ProfilingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfilingStatus
         */
        Builder profilingStatus(String profilingStatus);

        /**
         * <p>
         * Profiling status of a training job.
         * </p>
         * 
         * @param profilingStatus
         *        Profiling status of a training job.
         * @see ProfilingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfilingStatus
         */
        Builder profilingStatus(ProfilingStatus profilingStatus);

        /**
         * <p>
         * The environment variables to set in the Docker container.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trainingJobName;

        private String trainingJobArn;

        private String tuningJobArn;

        private String labelingJobArn;

        private String autoMLJobArn;

        private ModelArtifacts modelArtifacts;

        private String trainingJobStatus;

        private String secondaryStatus;

        private String failureReason;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private AlgorithmSpecification algorithmSpecification;

        private String roleArn;

        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private OutputDataConfig outputDataConfig;

        private ResourceConfig resourceConfig;

        private VpcConfig vpcConfig;

        private StoppingCondition stoppingCondition;

        private Instant creationTime;

        private Instant trainingStartTime;

        private Instant trainingEndTime;

        private Instant lastModifiedTime;

        private List<SecondaryStatusTransition> secondaryStatusTransitions = DefaultSdkAutoConstructList.getInstance();

        private List<MetricData> finalMetricDataList = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableNetworkIsolation;

        private Boolean enableInterContainerTrafficEncryption;

        private Boolean enableManagedSpotTraining;

        private CheckpointConfig checkpointConfig;

        private Integer trainingTimeInSeconds;

        private Integer billableTimeInSeconds;

        private DebugHookConfig debugHookConfig;

        private ExperimentConfig experimentConfig;

        private List<DebugRuleConfiguration> debugRuleConfigurations = DefaultSdkAutoConstructList.getInstance();

        private TensorBoardOutputConfig tensorBoardOutputConfig;

        private List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses = DefaultSdkAutoConstructList.getInstance();

        private ProfilerConfig profilerConfig;

        private List<ProfilerRuleConfiguration> profilerRuleConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses = DefaultSdkAutoConstructList.getInstance();

        private String profilingStatus;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrainingJobResponse model) {
            super(model);
            trainingJobName(model.trainingJobName);
            trainingJobArn(model.trainingJobArn);
            tuningJobArn(model.tuningJobArn);
            labelingJobArn(model.labelingJobArn);
            autoMLJobArn(model.autoMLJobArn);
            modelArtifacts(model.modelArtifacts);
            trainingJobStatus(model.trainingJobStatus);
            secondaryStatus(model.secondaryStatus);
            failureReason(model.failureReason);
            hyperParameters(model.hyperParameters);
            algorithmSpecification(model.algorithmSpecification);
            roleArn(model.roleArn);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            resourceConfig(model.resourceConfig);
            vpcConfig(model.vpcConfig);
            stoppingCondition(model.stoppingCondition);
            creationTime(model.creationTime);
            trainingStartTime(model.trainingStartTime);
            trainingEndTime(model.trainingEndTime);
            lastModifiedTime(model.lastModifiedTime);
            secondaryStatusTransitions(model.secondaryStatusTransitions);
            finalMetricDataList(model.finalMetricDataList);
            enableNetworkIsolation(model.enableNetworkIsolation);
            enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            enableManagedSpotTraining(model.enableManagedSpotTraining);
            checkpointConfig(model.checkpointConfig);
            trainingTimeInSeconds(model.trainingTimeInSeconds);
            billableTimeInSeconds(model.billableTimeInSeconds);
            debugHookConfig(model.debugHookConfig);
            experimentConfig(model.experimentConfig);
            debugRuleConfigurations(model.debugRuleConfigurations);
            tensorBoardOutputConfig(model.tensorBoardOutputConfig);
            debugRuleEvaluationStatuses(model.debugRuleEvaluationStatuses);
            profilerConfig(model.profilerConfig);
            profilerRuleConfigurations(model.profilerRuleConfigurations);
            profilerRuleEvaluationStatuses(model.profilerRuleEvaluationStatuses);
            profilingStatus(model.profilingStatus);
            environment(model.environment);
        }

        public final String getTrainingJobName() {
            return trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final String getTuningJobArn() {
            return tuningJobArn;
        }

        @Override
        public final Builder tuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
            return this;
        }

        public final void setTuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
        }

        public final String getLabelingJobArn() {
            return labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        public final String getAutoMLJobArn() {
            return autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final ModelArtifacts.Builder getModelArtifacts() {
            return modelArtifacts != null ? modelArtifacts.toBuilder() : null;
        }

        @Override
        public final Builder modelArtifacts(ModelArtifacts modelArtifacts) {
            this.modelArtifacts = modelArtifacts;
            return this;
        }

        public final void setModelArtifacts(ModelArtifacts.BuilderImpl modelArtifacts) {
            this.modelArtifacts = modelArtifacts != null ? modelArtifacts.build() : null;
        }

        public final String getTrainingJobStatus() {
            return trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus == null ? null : trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        public final String getSecondaryStatus() {
            return secondaryStatus;
        }

        @Override
        public final Builder secondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
            return this;
        }

        @Override
        public final Builder secondaryStatus(SecondaryStatus secondaryStatus) {
            this.secondaryStatus(secondaryStatus == null ? null : secondaryStatus.toString());
            return this;
        }

        public final void setSecondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return algorithmSpecification != null ? algorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            if (inputDataConfig instanceof SdkAutoConstructList) {
                return null;
            }
            return inputDataConfig != null ? inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> Channel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingStartTime() {
            return trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        public final Instant getTrainingEndTime() {
            return trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Collection<SecondaryStatusTransition.Builder> getSecondaryStatusTransitions() {
            if (secondaryStatusTransitions instanceof SdkAutoConstructList) {
                return null;
            }
            return secondaryStatusTransitions != null ? secondaryStatusTransitions.stream()
                    .map(SecondaryStatusTransition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copy(secondaryStatusTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(SecondaryStatusTransition... secondaryStatusTransitions) {
            secondaryStatusTransitions(Arrays.asList(secondaryStatusTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder>... secondaryStatusTransitions) {
            secondaryStatusTransitions(Stream.of(secondaryStatusTransitions)
                    .map(c -> SecondaryStatusTransition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryStatusTransitions(
                Collection<SecondaryStatusTransition.BuilderImpl> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copyFromBuilder(secondaryStatusTransitions);
        }

        public final Collection<MetricData.Builder> getFinalMetricDataList() {
            if (finalMetricDataList instanceof SdkAutoConstructList) {
                return null;
            }
            return finalMetricDataList != null ? finalMetricDataList.stream().map(MetricData::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder finalMetricDataList(Collection<MetricData> finalMetricDataList) {
            this.finalMetricDataList = FinalMetricDataListCopier.copy(finalMetricDataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalMetricDataList(MetricData... finalMetricDataList) {
            finalMetricDataList(Arrays.asList(finalMetricDataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalMetricDataList(Consumer<MetricData.Builder>... finalMetricDataList) {
            finalMetricDataList(Stream.of(finalMetricDataList).map(c -> MetricData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFinalMetricDataList(Collection<MetricData.BuilderImpl> finalMetricDataList) {
            this.finalMetricDataList = FinalMetricDataListCopier.copyFromBuilder(finalMetricDataList);
        }

        public final Boolean getEnableNetworkIsolation() {
            return enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        public final CheckpointConfig.Builder getCheckpointConfig() {
            return checkpointConfig != null ? checkpointConfig.toBuilder() : null;
        }

        @Override
        public final Builder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final void setCheckpointConfig(CheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        public final Integer getTrainingTimeInSeconds() {
            return trainingTimeInSeconds;
        }

        @Override
        public final Builder trainingTimeInSeconds(Integer trainingTimeInSeconds) {
            this.trainingTimeInSeconds = trainingTimeInSeconds;
            return this;
        }

        public final void setTrainingTimeInSeconds(Integer trainingTimeInSeconds) {
            this.trainingTimeInSeconds = trainingTimeInSeconds;
        }

        public final Integer getBillableTimeInSeconds() {
            return billableTimeInSeconds;
        }

        @Override
        public final Builder billableTimeInSeconds(Integer billableTimeInSeconds) {
            this.billableTimeInSeconds = billableTimeInSeconds;
            return this;
        }

        public final void setBillableTimeInSeconds(Integer billableTimeInSeconds) {
            this.billableTimeInSeconds = billableTimeInSeconds;
        }

        public final DebugHookConfig.Builder getDebugHookConfig() {
            return debugHookConfig != null ? debugHookConfig.toBuilder() : null;
        }

        @Override
        public final Builder debugHookConfig(DebugHookConfig debugHookConfig) {
            this.debugHookConfig = debugHookConfig;
            return this;
        }

        public final void setDebugHookConfig(DebugHookConfig.BuilderImpl debugHookConfig) {
            this.debugHookConfig = debugHookConfig != null ? debugHookConfig.build() : null;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return experimentConfig != null ? experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        public final Collection<DebugRuleConfiguration.Builder> getDebugRuleConfigurations() {
            if (debugRuleConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return debugRuleConfigurations != null ? debugRuleConfigurations.stream().map(DebugRuleConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copy(debugRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(DebugRuleConfiguration... debugRuleConfigurations) {
            debugRuleConfigurations(Arrays.asList(debugRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder>... debugRuleConfigurations) {
            debugRuleConfigurations(Stream.of(debugRuleConfigurations)
                    .map(c -> DebugRuleConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDebugRuleConfigurations(Collection<DebugRuleConfiguration.BuilderImpl> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copyFromBuilder(debugRuleConfigurations);
        }

        public final TensorBoardOutputConfig.Builder getTensorBoardOutputConfig() {
            return tensorBoardOutputConfig != null ? tensorBoardOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder tensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig;
            return this;
        }

        public final void setTensorBoardOutputConfig(TensorBoardOutputConfig.BuilderImpl tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig != null ? tensorBoardOutputConfig.build() : null;
        }

        public final Collection<DebugRuleEvaluationStatus.Builder> getDebugRuleEvaluationStatuses() {
            if (debugRuleEvaluationStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return debugRuleEvaluationStatuses != null ? debugRuleEvaluationStatuses.stream()
                    .map(DebugRuleEvaluationStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder debugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses = DebugRuleEvaluationStatusesCopier.copy(debugRuleEvaluationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleEvaluationStatuses(DebugRuleEvaluationStatus... debugRuleEvaluationStatuses) {
            debugRuleEvaluationStatuses(Arrays.asList(debugRuleEvaluationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleEvaluationStatuses(
                Consumer<DebugRuleEvaluationStatus.Builder>... debugRuleEvaluationStatuses) {
            debugRuleEvaluationStatuses(Stream.of(debugRuleEvaluationStatuses)
                    .map(c -> DebugRuleEvaluationStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDebugRuleEvaluationStatuses(
                Collection<DebugRuleEvaluationStatus.BuilderImpl> debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses = DebugRuleEvaluationStatusesCopier.copyFromBuilder(debugRuleEvaluationStatuses);
        }

        public final ProfilerConfig.Builder getProfilerConfig() {
            return profilerConfig != null ? profilerConfig.toBuilder() : null;
        }

        @Override
        public final Builder profilerConfig(ProfilerConfig profilerConfig) {
            this.profilerConfig = profilerConfig;
            return this;
        }

        public final void setProfilerConfig(ProfilerConfig.BuilderImpl profilerConfig) {
            this.profilerConfig = profilerConfig != null ? profilerConfig.build() : null;
        }

        public final Collection<ProfilerRuleConfiguration.Builder> getProfilerRuleConfigurations() {
            if (profilerRuleConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return profilerRuleConfigurations != null ? profilerRuleConfigurations.stream()
                    .map(ProfilerRuleConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copy(profilerRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(ProfilerRuleConfiguration... profilerRuleConfigurations) {
            profilerRuleConfigurations(Arrays.asList(profilerRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder>... profilerRuleConfigurations) {
            profilerRuleConfigurations(Stream.of(profilerRuleConfigurations)
                    .map(c -> ProfilerRuleConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProfilerRuleConfigurations(
                Collection<ProfilerRuleConfiguration.BuilderImpl> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copyFromBuilder(profilerRuleConfigurations);
        }

        public final Collection<ProfilerRuleEvaluationStatus.Builder> getProfilerRuleEvaluationStatuses() {
            if (profilerRuleEvaluationStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return profilerRuleEvaluationStatuses != null ? profilerRuleEvaluationStatuses.stream()
                    .map(ProfilerRuleEvaluationStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder profilerRuleEvaluationStatuses(
                Collection<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses) {
            this.profilerRuleEvaluationStatuses = ProfilerRuleEvaluationStatusesCopier.copy(profilerRuleEvaluationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleEvaluationStatuses(ProfilerRuleEvaluationStatus... profilerRuleEvaluationStatuses) {
            profilerRuleEvaluationStatuses(Arrays.asList(profilerRuleEvaluationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleEvaluationStatuses(
                Consumer<ProfilerRuleEvaluationStatus.Builder>... profilerRuleEvaluationStatuses) {
            profilerRuleEvaluationStatuses(Stream.of(profilerRuleEvaluationStatuses)
                    .map(c -> ProfilerRuleEvaluationStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProfilerRuleEvaluationStatuses(
                Collection<ProfilerRuleEvaluationStatus.BuilderImpl> profilerRuleEvaluationStatuses) {
            this.profilerRuleEvaluationStatuses = ProfilerRuleEvaluationStatusesCopier
                    .copyFromBuilder(profilerRuleEvaluationStatuses);
        }

        public final String getProfilingStatus() {
            return profilingStatus;
        }

        @Override
        public final Builder profilingStatus(String profilingStatus) {
            this.profilingStatus = profilingStatus;
            return this;
        }

        @Override
        public final Builder profilingStatus(ProfilingStatus profilingStatus) {
            this.profilingStatus(profilingStatus == null ? null : profilingStatus.toString());
            return this;
        }

        public final void setProfilingStatus(String profilingStatus) {
            this.profilingStatus = profilingStatus;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TrainingEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TrainingEnvironmentMapCopier.copy(environment);
        }

        @Override
        public DescribeTrainingJobResponse build() {
            return new DescribeTrainingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
