/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEndpointsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListEndpointsResponse.Builder, ListEndpointsResponse> {
    private static final SdkField<List<EndpointSummary>> ENDPOINTS_FIELD = SdkField
            .<List<EndpointSummary>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(ListEndpointsResponse::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EndpointSummary> endpoints;

    private final String nextToken;

    private ListEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Endpoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array or endpoint objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array or endpoint objects.
     */
    public final List<EndpointSummary> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use
     * it in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training
     *         jobs, use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsResponse)) {
            return false;
        }
        ListEndpointsResponse other = (ListEndpointsResponse) obj;
        return hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEndpointsResponse").add("Endpoints", hasEndpoints() ? endpoints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsResponse, T> g) {
        return obj -> g.apply((ListEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEndpointsResponse> {
        /**
         * <p>
         * An array or endpoint objects.
         * </p>
         * 
         * @param endpoints
         *        An array or endpoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<EndpointSummary> endpoints);

        /**
         * <p>
         * An array or endpoint objects.
         * </p>
         * 
         * @param endpoints
         *        An array or endpoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(EndpointSummary... endpoints);

        /**
         * <p>
         * An array or endpoint objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndpointSummary>.Builder} avoiding the need
         * to create one manually via {@link List<EndpointSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #endpoints(List<EndpointSummary>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<EndpointSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<EndpointSummary>)
         */
        Builder endpoints(Consumer<EndpointSummary.Builder>... endpoints);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs,
         * use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of
         *        training jobs, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<EndpointSummary> endpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsResponse model) {
            super(model);
            endpoints(model.endpoints);
            nextToken(model.nextToken);
        }

        public final Collection<EndpointSummary.Builder> getEndpoints() {
            if (endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return endpoints != null ? endpoints.stream().map(EndpointSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<EndpointSummary> endpoints) {
            this.endpoints = EndpointSummaryListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(EndpointSummary... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<EndpointSummary.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> EndpointSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<EndpointSummary.BuilderImpl> endpoints) {
            this.endpoints = EndpointSummaryListCopier.copyFromBuilder(endpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsResponse build() {
            return new ListEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
