/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the properties of a trial. To get the complete set of properties, call the <a>DescribeTrial</a> API and
 * provide the <code>TrialName</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialSummary implements SdkPojo, Serializable, ToCopyableBuilder<TrialSummary.Builder, TrialSummary> {
    private static final SdkField<String> TRIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialArn").getter(getter(TrialSummary::trialArn)).setter(setter(Builder::trialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialArn").build()).build();

    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialName").getter(getter(TrialSummary::trialName)).setter(setter(Builder::trialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(TrialSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<TrialSource> TRIAL_SOURCE_FIELD = SdkField.<TrialSource> builder(MarshallingType.SDK_POJO)
            .memberName("TrialSource").getter(getter(TrialSummary::trialSource)).setter(setter(Builder::trialSource))
            .constructor(TrialSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialSource").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TrialSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(TrialSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_ARN_FIELD,
            TRIAL_NAME_FIELD, DISPLAY_NAME_FIELD, TRIAL_SOURCE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trialArn;

    private final String trialName;

    private final String displayName;

    private final TrialSource trialSource;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private TrialSummary(BuilderImpl builder) {
        this.trialArn = builder.trialArn;
        this.trialName = builder.trialName;
        this.displayName = builder.displayName;
        this.trialSource = builder.trialSource;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial.
     */
    public final String trialArn() {
        return trialArn;
    }

    /**
     * <p>
     * The name of the trial.
     * </p>
     * 
     * @return The name of the trial.
     */
    public final String trialName() {
        return trialName;
    }

    /**
     * <p>
     * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
     * displayed.
     * </p>
     * 
     * @return The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code>
     *         is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the TrialSource property for this object.
     * 
     * @return The value of the TrialSource property for this object.
     */
    public final TrialSource trialSource() {
        return trialSource;
    }

    /**
     * <p>
     * When the trial was created.
     * </p>
     * 
     * @return When the trial was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the trial was last modified.
     * </p>
     * 
     * @return When the trial was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trialArn());
        hashCode = 31 * hashCode + Objects.hashCode(trialName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(trialSource());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialSummary)) {
            return false;
        }
        TrialSummary other = (TrialSummary) obj;
        return Objects.equals(trialArn(), other.trialArn()) && Objects.equals(trialName(), other.trialName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(trialSource(), other.trialSource())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrialSummary").add("TrialArn", trialArn()).add("TrialName", trialName())
                .add("DisplayName", displayName()).add("TrialSource", trialSource()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialArn":
            return Optional.ofNullable(clazz.cast(trialArn()));
        case "TrialName":
            return Optional.ofNullable(clazz.cast(trialName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "TrialSource":
            return Optional.ofNullable(clazz.cast(trialSource()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialSummary, T> g) {
        return obj -> g.apply((TrialSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial.
         * </p>
         * 
         * @param trialArn
         *        The Amazon Resource Name (ARN) of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialArn(String trialArn);

        /**
         * <p>
         * The name of the trial.
         * </p>
         * 
         * @param trialName
         *        The name of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialName(String trialName);

        /**
         * <p>
         * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
         * displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the trial as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>TrialName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the TrialSource property for this object.
         *
         * @param trialSource
         *        The new value for the TrialSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialSource(TrialSource trialSource);

        /**
         * Sets the value of the TrialSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrialSource.Builder} avoiding the need to create
         * one manually via {@link TrialSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialSource.Builder#build()} is called immediately and its result
         * is passed to {@link #trialSource(TrialSource)}.
         * 
         * @param trialSource
         *        a consumer that will call methods on {@link TrialSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialSource(TrialSource)
         */
        default Builder trialSource(Consumer<TrialSource.Builder> trialSource) {
            return trialSource(TrialSource.builder().applyMutation(trialSource).build());
        }

        /**
         * <p>
         * When the trial was created.
         * </p>
         * 
         * @param creationTime
         *        When the trial was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the trial was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the trial was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String trialArn;

        private String trialName;

        private String displayName;

        private TrialSource trialSource;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialSummary model) {
            trialArn(model.trialArn);
            trialName(model.trialName);
            displayName(model.displayName);
            trialSource(model.trialSource);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getTrialArn() {
            return trialArn;
        }

        @Override
        public final Builder trialArn(String trialArn) {
            this.trialArn = trialArn;
            return this;
        }

        public final void setTrialArn(String trialArn) {
            this.trialArn = trialArn;
        }

        public final String getTrialName() {
            return trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final TrialSource.Builder getTrialSource() {
            return trialSource != null ? trialSource.toBuilder() : null;
        }

        @Override
        public final Builder trialSource(TrialSource trialSource) {
            this.trialSource = trialSource;
            return this;
        }

        public final void setTrialSource(TrialSource.BuilderImpl trialSource) {
            this.trialSource = trialSource != null ? trialSource.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public TrialSummary build() {
            return new TrialSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
